/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class RedshiftTimestamp
extends Timestamp {
    private static final long serialVersionUID = -6245623465210738466L;
    private static final String MINUS_INFINITY_KEYWORD = "-infinity";
    private static final String INFINITY_KEYWORD = "infinity";
    private static ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final int UNINITIALIZED_TIMEZONE = 25;
    private static final long FIRST_AD_TIMESTAMP = -62135769599767L;
    private Calendar calendar;
    private String s;
    private int offSetHour;
    private int offSetMinute;
    private boolean isAD = true;

    public RedshiftTimestamp(long time) {
        this(time, null);
    }

    public RedshiftTimestamp(long time, Calendar calendar) {
        this(time, calendar, null);
    }

    public RedshiftTimestamp(long time, Calendar calendar, String s) {
        super(time);
        this.setCalendar(calendar);
        this.s = s;
        if (calendar != null) {
            int rawOffset = calendar.getTimeZone().getRawOffset();
            this.offSetHour = rawOffset / 3600000;
            this.offSetMinute = rawOffset / 60000 % 60;
        }
        if (-62135769599767L > time) {
            this.isAD = false;
        }
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RedshiftTimestamp)) {
            return false;
        }
        RedshiftTimestamp other = (RedshiftTimestamp)obj;
        return !(this.calendar == null ? other.calendar != null : !this.calendar.equals(other.calendar));
    }

    @Override
    public Object clone() {
        RedshiftTimestamp clone = (RedshiftTimestamp)super.clone();
        if (this.getCalendar() != null) {
            clone.setCalendar((Calendar)this.getCalendar().clone());
        }
        return clone;
    }

    @Override
    public String toString() {
        if (this.s == null) {
            return super.toString();
        }
        String s2 = this.getRedshiftString();
        return s2;
    }

    private static long convertTimeMillis(long timeMillis, Calendar to, Calendar from) {
        from.setTimeInMillis(timeMillis);
        to.set(from.get(1), from.get(2), from.get(5), from.get(11), from.get(12), from.get(13));
        to.set(14, from.get(14));
        to.set(0, from.get(0));
        return to.getTimeInMillis();
    }

    private synchronized Timestamp getAdjustedTimestamp() {
        return RedshiftTimestamp.getTimestamp(this, Calendar.getInstance(), this.calendar);
    }

    private static Timestamp getTimestamp(Timestamp timestamp, Calendar to, Calendar from) {
        if (null == timestamp) {
            return null;
        }
        if (null == to || null == from) {
            throw new NullPointerException("Calendar cannot be null.");
        }
        to.clear();
        from.clear();
        if (to.equals(from)) {
            return timestamp;
        }
        Timestamp tz = new Timestamp(RedshiftTimestamp.convertTimeMillis(timestamp.getTime(), to, from));
        tz.setNanos(timestamp.getNanos());
        return tz;
    }

    public String getPostgresqlString() {
        return this.getRedshiftString();
    }

    private String getRedshiftString() {
        if (this.getTime() == Long.MIN_VALUE) {
            return MINUS_INFINITY_KEYWORD;
        }
        if (this.getTime() == Long.MAX_VALUE) {
            return INFINITY_KEYWORD;
        }
        StringBuilder baseResult = new StringBuilder();
        Calendar cal = this.getCalendar();
        cal.setTime(this.getAdjustedTimestamp());
        baseResult.append(TIMESTAMP_FORMAT.get().format(cal.getTime()));
        String nanoSeconds = String.valueOf(this.getNanos());
        if (0 < this.getNanos()) {
            baseResult.append(".");
            baseResult.append(nanoSeconds);
            if (6 < nanoSeconds.length()) {
                baseResult.delete(baseResult.length() - (nanoSeconds.length() - 6), baseResult.length());
            }
        }
        if (25 != this.offSetHour) {
            baseResult.append(this.offSetHour < 0 ? (char)'-' : '+');
            if (0 != this.offSetHour) {
                baseResult.append(String.format("%02d", Math.abs(this.offSetHour)));
            } else {
                baseResult.append("00");
            }
            if (0 != this.offSetMinute) {
                baseResult.append(":");
                baseResult.append(String.format("%02d", Math.abs(this.offSetMinute)));
            }
        }
        if (!this.isAD) {
            baseResult.append(" BC");
        }
        return baseResult.toString();
    }
}

