/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl.bin.utf8;

import com.amazon.ion.impl.bin.utf8.Utf8StringEncoder;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Utf8StringEncoderPool {
    INSTANCE;

    private static final int MAX_QUEUE_SIZE = 128;
    private final ArrayBlockingQueue<Utf8StringEncoder> bufferQueue = new ArrayBlockingQueue(128);

    public static Utf8StringEncoderPool getInstance() {
        return INSTANCE;
    }

    public Utf8StringEncoder getOrCreateUtf8Encoder() {
        Utf8StringEncoder encoder = this.bufferQueue.poll();
        if (encoder == null) {
            encoder = new Utf8StringEncoder(this);
        }
        return encoder;
    }

    public void returnEncoderToPool(Utf8StringEncoder encoder) {
        this.bufferQueue.offer(encoder);
    }
}

