/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.HttpURLConnectionWebRequest;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.ResponseReader;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebUtils2;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

abstract class WebRequest {
    private static final String LOGTAG = WebRequest.class.getSimpleName();
    private static final String HEADER_ACCEPT_KEY = "Accept";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_KEY = "charset";
    public static final int DEFAULT_TIMEOUT = 20000;
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_PLAIN_TEXT = "text/plain";
    public static final String CONTENT_TYPE_CSS = "text/css";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_JAVASCRIPT = "application/javascript";
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String CHARSET_UTF_16 = "UTF-16";
    public static final int DEFAULT_PORT = -1;
    String requestBody = null;
    String acceptContentType = null;
    String contentType = null;
    String charset = null;
    private String urlString = null;
    private String secureHost = null;
    private String nonSecureHost = null;
    private String path = null;
    private int port = -1;
    private HttpMethod httpMethod = HttpMethod.GET;
    private int timeout = 20000;
    private MetricsCollector metricsCollector;
    private boolean disconnectEnabled;
    protected final HashMap<String, String> headers;
    protected QueryStringParameters queryStringParameters;
    protected HashMap<String, String> postParameters;
    boolean logRequestBodyEnabled = false;
    boolean logResponseEnabled = false;
    protected boolean logUrlEnabled = false;
    protected boolean secure = false;
    private String logTag = LOGTAG;
    protected Metrics.MetricType serviceCallLatencyMetric;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(this.logTag);

    WebRequest() {
        boolean tlsEnabled;
        this.queryStringParameters = new QueryStringParameters();
        this.headers = new HashMap();
        this.postParameters = new HashMap();
        this.secure = tlsEnabled = Settings.getInstance().getBoolean("tlsEnabled", false);
        this.disconnectEnabled = true;
    }

    public void convertToJSONPostRequest() {
        this.setHttpMethod(HttpMethod.POST);
        this.putHeader(HEADER_ACCEPT_KEY, CONTENT_TYPE_JSON);
        this.putHeader(HEADER_CONTENT_TYPE, "application/json; charset=UTF-8");
    }

    public WebResponse makeCall() throws WebRequestException {
        WebResponse response;
        URL url;
        if (ThreadUtils.isOnMainThread()) {
            this.logger.e("The network request should not be performed on the main thread.");
        }
        this.setContentTypeHeaders();
        String urlString = this.getUrl();
        try {
            url = this.createURL(urlString);
        }
        catch (MalformedURLException e) {
            this.logger.e("Problem with URI syntax: %s", e.getMessage());
            throw new WebRequestException(WebRequestStatus.MALFORMED_URL, "Could not construct URL from String " + urlString, e);
        }
        this.writeMetricStart(this.serviceCallLatencyMetric);
        try {
            response = this.doHttpNetworkCall(url);
        }
        catch (WebRequestException e) {
            throw e;
        }
        finally {
            this.writeMetricStop(this.serviceCallLatencyMetric);
        }
        if (this.logResponseEnabled) {
            this.logger.d("Response: %s %s", response.getHttpStatusCode(), response.getHttpStatus());
        }
        return response;
    }

    protected abstract WebResponse doHttpNetworkCall(URL var1) throws WebRequestException;

    protected abstract void closeConnection();

    public void enableLogUrl(boolean enabled) {
        this.logUrlEnabled = enabled;
    }

    public void enableLogRequestBody(boolean enabled) {
        this.logRequestBodyEnabled = enabled;
    }

    public void enableLogResponse(boolean enabled) {
        this.logResponseEnabled = enabled;
    }

    public void enableLog(boolean enabled) {
        this.enableLogUrl(enabled);
        this.enableLogRequestBody(enabled);
        this.enableLogResponse(enabled);
    }

    protected void logUrl(String url) {
        if (this.logUrlEnabled) {
            this.logger.d("%s %s", new Object[]{this.getHttpMethod(), url});
        }
    }

    public String getQueryParameter(String name) {
        return this.queryStringParameters.get(name);
    }

    public void putUrlEncodedQueryParameter(String name, String value) {
        this.queryStringParameters.putUrlEncoded(name, value);
    }

    public String putUnencodedQueryParameter(String name, String value) {
        return this.queryStringParameters.putUnencoded(name, value);
    }

    public void setQueryStringParameters(QueryStringParameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
    }

    public String getPostParameter(String name) {
        if (StringUtils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        return this.postParameters.get(name);
    }

    public void putPostParameter(String name, String value) {
        if (StringUtils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        if (value == null) {
            this.postParameters.remove(name);
        } else {
            this.postParameters.put(name, value);
        }
    }

    public String getHeader(String name) {
        if (StringUtils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        return this.headers.get(name);
    }

    public void putHeader(String name, String value) {
        if (StringUtils.isNullOrWhiteSpace(name)) {
            throw new IllegalArgumentException("The name must not be null or empty string.");
        }
        this.headers.put(name, value);
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("The httpMethod must not be null.");
        }
        this.httpMethod = httpMethod;
    }

    public String getHost() {
        return this.getUseSecure() ? this.secureHost : this.nonSecureHost;
    }

    public void setHost(String host) {
        if (StringUtils.isNullOrWhiteSpace(host)) {
            throw new IllegalArgumentException("The host must not be null.");
        }
        this.secureHost = host;
        this.nonSecureHost = host;
    }

    public void setSecureHost(String secureHost) {
        if (StringUtils.isNullOrWhiteSpace(secureHost)) {
            throw new IllegalArgumentException("The host must not be null.");
        }
        this.secureHost = secureHost;
    }

    public void setNonSecureHost(String nonSecureHost) {
        if (StringUtils.isNullOrWhiteSpace(nonSecureHost)) {
            throw new IllegalArgumentException("The host must not be null.");
        }
        this.nonSecureHost = nonSecureHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean getUseSecure() {
        return DebugProperties.getInstance().getDebugPropertyAsBoolean("debug.useSecure", this.secure);
    }

    public void setUseSecure(boolean secure) {
        this.secure = secure;
    }

    public void setUrlString(String urlString) {
        if (urlString != null && this.getUseSecure() && urlString.startsWith("http:")) {
            urlString = urlString.replaceFirst("http", "https");
        }
        this.urlString = urlString;
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setRequestBodyString(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getRequestBodyString() {
        return this.requestBody;
    }

    public String getRequestBody() {
        if (this.getRequestBodyString() != null) {
            return this.getRequestBodyString();
        }
        if (this.postParameters.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.postParameters.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append(";\n");
        }
        return builder.toString();
    }

    public void setAcceptContentType(String acceptContentType) {
        this.acceptContentType = this.contentType;
    }

    public String getAcceptContentType() {
        return this.acceptContentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }

    public void setServiceCallLatencyMetric(Metrics.MetricType metric) {
        this.serviceCallLatencyMetric = metric;
    }

    public void setAdditionalQueryParamsString(String paramsString) {
        this.queryStringParameters.setRawAppendage(paramsString);
    }

    public void setExternalLogTag(String externalLogTag) {
        this.logTag = externalLogTag == null ? LOGTAG + " " + this.getSubLogTag() : externalLogTag + " " + LOGTAG + " " + this.getSubLogTag();
        this.logger.withLogTag(this.logTag);
    }

    public boolean getDisconnectEnabled() {
        return this.disconnectEnabled;
    }

    public void setDisconnectEnabled(boolean disconnectEnabled) {
        this.disconnectEnabled = disconnectEnabled;
    }

    protected MobileAdsLogger getLogger() {
        return this.logger;
    }

    private String getLogTag() {
        return this.logTag;
    }

    protected abstract String getSubLogTag();

    protected void setContentTypeHeaders() {
        if (this.acceptContentType != null) {
            this.putHeader(HEADER_ACCEPT_KEY, this.contentType);
        }
        if (this.contentType != null) {
            String contentType = this.contentType;
            if (this.charset != null) {
                contentType = contentType + "; charset=" + this.charset;
            }
            this.putHeader(HEADER_CONTENT_TYPE, contentType);
        }
    }

    protected void writeMetricStart(Metrics.MetricType metric) {
        if (metric != null && this.metricsCollector != null) {
            this.metricsCollector.startMetric(metric);
        }
    }

    protected void writeMetricStop(Metrics.MetricType metric) {
        if (metric != null && this.metricsCollector != null) {
            this.metricsCollector.stopMetric(metric);
        }
    }

    protected URI createUri() throws URISyntaxException, MalformedURLException {
        return new URL(this.getUrlString()).toURI();
    }

    protected URI createURI(String url) throws MalformedURLException, URISyntaxException {
        return this.createURI(this.createURL(url));
    }

    protected URI createURI(URL url) throws URISyntaxException {
        return url.toURI();
    }

    protected URL createURL(String urlString) throws MalformedURLException {
        return new URL(urlString);
    }

    protected void appendQuery(StringBuilder builder) {
        this.queryStringParameters.append(builder);
    }

    protected String getScheme() {
        if (this.getUseSecure()) {
            return "https";
        }
        return "http";
    }

    public String toString() {
        return this.getUrl();
    }

    protected String getUrl() {
        if (this.urlString != null) {
            return this.urlString;
        }
        StringBuilder builder = new StringBuilder(this.getScheme());
        builder.append("://");
        builder.append(this.getHost());
        if (this.getPort() != -1) {
            builder.append(":");
            builder.append(this.getPort());
        }
        builder.append(this.getPath());
        this.appendQuery(builder);
        return builder.toString();
    }

    class WebRequestInputStream
    extends InputStream {
        private final InputStream decoratedStream;

        public WebRequestInputStream(InputStream decoratedStream) {
            this.decoratedStream = decoratedStream;
        }

        public int read() throws IOException {
            return this.decoratedStream.read();
        }

        public void close() throws IOException {
            this.decoratedStream.close();
            if (WebRequest.this.disconnectEnabled) {
                WebRequest.this.closeConnection();
            }
        }
    }

    static class QueryStringParameters {
        private final HashMap<String, String> params = new HashMap();
        private String rawAppendage;

        QueryStringParameters() {
        }

        int size() {
            return this.params.size();
        }

        void setRawAppendage(String rawAppendage) {
            this.rawAppendage = rawAppendage;
        }

        void putUrlEncoded(String param, boolean value) {
            this.putUrlEncoded(param, Boolean.toString(value));
        }

        void putUrlEncodedIfNotNullOrEmpty(String param, String value) {
            this.putUrlEncodedIfTrue(param, value, !StringUtils.isNullOrEmpty(value));
        }

        void putUrlEncodedIfTrue(String param, String value, boolean check) {
            if (check) {
                this.putUrlEncoded(param, value);
            }
        }

        String get(String name) {
            if (StringUtils.isNullOrWhiteSpace(name)) {
                throw new IllegalArgumentException("The name must not be null or empty string.");
            }
            return this.params.get(name);
        }

        void putUrlEncoded(String name, String value) {
            if (StringUtils.isNullOrWhiteSpace(name)) {
                throw new IllegalArgumentException("The name must not be null or empty string.");
            }
            if (value == null) {
                this.params.remove(name);
            } else {
                this.params.put(name, value);
            }
        }

        String putUnencoded(String name, String value) {
            WebUtils2 webUtils = new WebUtils2();
            String encodedName = webUtils.getURLEncodedString(name);
            this.putUrlEncoded(encodedName, webUtils.getURLEncodedString(value));
            return encodedName;
        }

        void append(StringBuilder builder) {
            if (this.size() == 0 && StringUtils.isNullOrEmpty(this.rawAppendage)) {
                return;
            }
            builder.append("?");
            boolean first = true;
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append("&");
                }
                builder.append(param.getKey());
                builder.append("=");
                builder.append(param.getValue());
            }
            if (this.rawAppendage != null && !this.rawAppendage.equals("")) {
                if (this.size() != 0) {
                    builder.append("&");
                }
                builder.append(this.rawAppendage);
            }
        }
    }

    public static class WebRequestFactory {
        public WebRequest createWebRequest() {
            return new HttpURLConnectionWebRequest();
        }

        public WebRequest createJSONGetWebRequest() {
            WebRequest request = this.createWebRequest();
            request.setHttpMethod(HttpMethod.GET);
            request.putHeader(WebRequest.HEADER_ACCEPT_KEY, WebRequest.CONTENT_TYPE_JSON);
            return request;
        }

        public WebRequest createJSONPostWebRequest() {
            WebRequest request = this.createWebRequest();
            request.convertToJSONPostRequest();
            return request;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebRequestStatus {
        NETWORK_FAILURE,
        NETWORK_TIMEOUT,
        MALFORMED_URL,
        INVALID_CLIENT_PROTOCOL,
        UNSUPPORTED_ENCODING;

    }

    public class WebRequestException
    extends Exception {
        private static final long serialVersionUID = -4980265484926465548L;
        private final WebRequestStatus status;

        protected WebRequestException(WebRequestStatus status, String message, Throwable cause) {
            super(message, cause);
            this.status = status;
        }

        protected WebRequestException(WebRequestStatus status, String message) {
            this(status, message, null);
        }

        public WebRequestStatus getStatus() {
            return this.status;
        }
    }

    public class WebResponse {
        private int httpStatusCode;
        private String httpStatus;
        private WebRequestInputStream inputStream;

        protected WebResponse() {
        }

        protected void setInputStream(InputStream inputStream) {
            this.inputStream = new WebRequestInputStream(inputStream);
        }

        public ResponseReader getResponseReader() {
            ResponseReader reader = new ResponseReader(this.inputStream);
            reader.enableLog(WebRequest.this.logResponseEnabled);
            reader.setExternalLogTag(WebRequest.this.getLogTag());
            return reader;
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        protected void setHttpStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
        }

        public boolean isHttpStatusCodeOK() {
            return this.getHttpStatusCode() == 200;
        }

        public String getHttpStatus() {
            return this.httpStatus;
        }

        protected void setHttpStatus(String httpStatus) {
            this.httpStatus = httpStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethod {
        GET("GET"),
        POST("POST");

        private final String methodString;

        private HttpMethod(String methodString) {
            this.methodString = methodString;
        }

        public String toString() {
            return this.methodString;
        }
    }
}

