/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdVideoPlayer;

class VideoActionHandler
implements AdActivity.AdActivityAdapter {
    private RelativeLayout layout;
    private AdVideoPlayer player;
    private Activity activity;

    VideoActionHandler() {
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void onCreate() {
        Bundle data = this.activity.getIntent().getExtras();
        this.layout = new RelativeLayout((Context)this.activity);
        this.layout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.activity.setContentView((View)this.layout);
        this.initPlayer(data);
        this.player.playVideo();
    }

    private void setPlayerListener(AdVideoPlayer player) {
        player.setListener(new AdVideoPlayer.AdVideoPlayerListener(){

            public void onError() {
                VideoActionHandler.this.activity.finish();
            }

            public void onComplete() {
                VideoActionHandler.this.activity.finish();
            }
        });
    }

    private void initPlayer(Bundle data) {
        this.player = new AdVideoPlayer((Context)this.activity);
        this.player.setPlayData(data.getString("url"));
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(13);
        this.player.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.player.setViewGroup((ViewGroup)this.layout);
        this.setPlayerListener(this.player);
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStop() {
        this.player.releasePlayer();
        this.player = null;
        this.activity.finish();
    }

    public void preOnCreate() {
        this.activity.requestWindowFeature(1);
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public boolean onBackPressed() {
        return false;
    }

    public void onWindowFocusChanged() {
    }
}

