/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadUtils {
    private static ThreadRunner threadRunner = new ThreadRunner();

    ThreadUtils() {
    }

    public static ThreadRunner getThreadRunner() {
        return threadRunner;
    }

    static void setThreadRunner(ThreadRunner threadRunner) {
        ThreadUtils.threadRunner = threadRunner;
    }

    public static boolean isOnMainThread() {
        return ThreadVerify.getInstance().isOnMainThread();
    }

    public static final <T> void executeAsyncTask(MobileAdsAsyncTask<T, ?, ?> task, T ... params) {
        threadRunner.executeAsyncTask(ExecutionStyle.RUN_ASAP, ExecutionThread.MAIN_THREAD, task, params);
    }

    public static final <T> void executeAsyncTask(ThreadRunner threadRunner, ExecutionStyle executionStyle, ExecutionThread executionThread, MobileAdsAsyncTask<T, ?, ?> task, T ... params) {
        threadRunner.executeAsyncTask(executionStyle, executionThread, task, params);
    }

    public static void scheduleRunnable(Runnable proc) {
        ThreadUtils.scheduleRunnable(proc, threadRunner);
    }

    public static void scheduleRunnable(Runnable proc, ThreadRunner threadRunner) {
        threadRunner.execute(proc, ExecutionStyle.SCHEDULE, ExecutionThread.BACKGROUND_THREAD);
    }

    public static void executeRunnableWithThreadCheck(Runnable proc) {
        ThreadUtils.executeRunnableWithThreadCheck(proc, threadRunner);
    }

    public static void executeRunnableWithThreadCheck(Runnable proc, ThreadRunner threadRunner) {
        threadRunner.execute(proc, ExecutionStyle.RUN_ASAP, ExecutionThread.BACKGROUND_THREAD);
    }

    public static void scheduleOnMainThread(Runnable proc) {
        ThreadUtils.scheduleOnMainThread(proc, threadRunner);
    }

    public static void scheduleOnMainThread(Runnable proc, ThreadRunner threadRunner) {
        threadRunner.execute(proc, ExecutionStyle.SCHEDULE, ExecutionThread.MAIN_THREAD);
    }

    public static void executeOnMainThread(Runnable proc) {
        ThreadUtils.executeOnMainThread(proc, threadRunner);
    }

    public static void executeOnMainThread(Runnable proc, ThreadRunner threadRunner) {
        threadRunner.execute(proc, ExecutionStyle.RUN_ASAP, ExecutionThread.MAIN_THREAD);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MobileAdsAsyncTask<Params, Progress, Result>
    extends AsyncTask<Params, Progress, Result> {
        MobileAdsAsyncTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(Result result) {
            super.onPostExecute(result);
        }

        protected abstract Result doInBackground(Params ... var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionStyle {
        RUN_ASAP,
        SCHEDULE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionThread {
        MAIN_THREAD,
        BACKGROUND_THREAD;

    }

    static class ThreadVerify {
        private static ThreadVerify instance = new ThreadVerify();

        ThreadVerify() {
        }

        static ThreadVerify getInstance() {
            return instance;
        }

        boolean isOnMainThread() {
            return Looper.getMainLooper().getThread() == Thread.currentThread();
        }
    }

    public static class ThreadExecutor
    extends RunnableExecutor {
        private final ThreadVerify threadVerify;
        private final RunnableExecutor threadScheduler;

        public ThreadExecutor(ThreadVerify threadVerify, RunnableExecutor threadScheduler) {
            super(ExecutionStyle.RUN_ASAP, threadScheduler.executionThread);
            this.threadVerify = threadVerify;
            this.threadScheduler = threadScheduler;
        }

        public void execute(Runnable proc) {
            boolean shouldSchedule;
            switch (this.threadScheduler.getExecutionThread()) {
                case MAIN_THREAD: {
                    shouldSchedule = !this.threadVerify.isOnMainThread();
                    break;
                }
                case BACKGROUND_THREAD: {
                    shouldSchedule = this.threadVerify.isOnMainThread();
                    break;
                }
                default: {
                    shouldSchedule = false;
                }
            }
            if (shouldSchedule) {
                this.threadScheduler.execute(proc);
            } else {
                proc.run();
            }
        }
    }

    public static class BackgroundThreadRunner
    extends ThreadExecutor {
        public BackgroundThreadRunner(ThreadVerify threadVerify) {
            super(threadVerify, new ThreadPoolScheduler());
        }
    }

    public static class MainThreadRunner
    extends ThreadExecutor {
        public MainThreadRunner(ThreadVerify threadVerify) {
            super(threadVerify, new MainThreadScheduler());
        }
    }

    public static class SingleThreadScheduler
    extends RunnableExecutor {
        private ExecutorService executorService = Executors.newSingleThreadExecutor();

        public SingleThreadScheduler() {
            super(ExecutionStyle.SCHEDULE, ExecutionThread.BACKGROUND_THREAD);
        }

        public void execute(Runnable proc) {
            this.executorService.submit(proc);
        }
    }

    public static class ThreadPoolScheduler
    extends RunnableExecutor {
        private static final int numberThreads = 1;
        private static final int maxNumberThreads = 3;
        private static final int keepAliveTimeSeconds = 30;
        private final ExecutorService executorService = new ThreadPoolExecutor(1, 3, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

        public ThreadPoolScheduler() {
            super(ExecutionStyle.SCHEDULE, ExecutionThread.BACKGROUND_THREAD);
        }

        public void execute(Runnable proc) {
            this.executorService.submit(proc);
        }
    }

    public static class MainThreadScheduler
    extends RunnableExecutor {
        public MainThreadScheduler() {
            super(ExecutionStyle.SCHEDULE, ExecutionThread.MAIN_THREAD);
        }

        public void execute(Runnable proc) {
            Handler h = new Handler(Looper.getMainLooper());
            h.post(proc);
        }
    }

    public static abstract class RunnableExecutor {
        private final ExecutionStyle executionStyle;
        private final ExecutionThread executionThread;

        public RunnableExecutor(ExecutionStyle executionStyle, ExecutionThread executionThread) {
            this.executionStyle = executionStyle;
            this.executionThread = executionThread;
        }

        public abstract void execute(Runnable var1);

        public ExecutionStyle getExecutionStyle() {
            return this.executionStyle;
        }

        public ExecutionThread getExecutionThread() {
            return this.executionThread;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadRunner {
        private static final String LOGTAG = ThreadRunner.class.getSimpleName();
        private final MobileAdsLogger logger;
        private final HashMap<ExecutionStyle, HashMap<ExecutionThread, RunnableExecutor>> executors = new HashMap();

        ThreadRunner() {
            this(new MobileAdsLoggerFactory());
            ThreadVerify threadVerify = new ThreadVerify();
            this.withExecutor(new ThreadPoolScheduler());
            this.withExecutor(new BackgroundThreadRunner(threadVerify));
            this.withExecutor(new MainThreadScheduler());
            this.withExecutor(new MainThreadRunner(threadVerify));
        }

        ThreadRunner(MobileAdsLoggerFactory loggerFactory) {
            this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        }

        public ThreadRunner withExecutor(RunnableExecutor executor) {
            HashMap<ExecutionThread, RunnableExecutor> executorsForStyle = this.executors.get((Object)executor.getExecutionStyle());
            if (executorsForStyle == null) {
                executorsForStyle = new HashMap();
                this.executors.put(executor.getExecutionStyle(), executorsForStyle);
            }
            executorsForStyle.put(executor.getExecutionThread(), executor);
            return this;
        }

        public void execute(Runnable proc, ExecutionStyle executionStyle, ExecutionThread executionThread) {
            HashMap<ExecutionThread, RunnableExecutor> executorsForStyle = this.executors.get((Object)executionStyle);
            if (executorsForStyle == null) {
                this.logger.e("No executor available for %s execution style.", new Object[]{executionStyle});
                return;
            }
            RunnableExecutor executor = executorsForStyle.get((Object)executionThread);
            if (executor == null) {
                this.logger.e("No executor available for %s execution style on % execution thread.", new Object[]{executionStyle, executionThread});
            }
            executor.execute(proc);
        }

        public <T> void executeAsyncTask(MobileAdsAsyncTask<T, ?, ?> task, T ... params) {
            this.executeAsyncTask(ExecutionStyle.RUN_ASAP, ExecutionThread.MAIN_THREAD, task, params);
        }

        public <T> void executeAsyncTask(ExecutionStyle executionStyle, ExecutionThread executionThread, final MobileAdsAsyncTask<T, ?, ?> task, final T ... params) {
            threadRunner.execute(new Runnable(){

                public void run() {
                    AndroidTargetUtils.executeAsyncTask(task, params);
                }
            }, executionStyle, executionThread);
        }
    }
}

