/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.util.SparseArray;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.ThreadUtils;

abstract class StartUpWaiter
implements Configuration.ConfigurationListener,
Settings.SettingsListener {
    static final int CALLBACK_ON_MAIN_THREAD = 0;
    static final int DEFAULT = 1;
    private static final SparseArray<ThreadUtils.RunnableExecutor> executors = new SparseArray();
    private int callbackType = 1;
    private final Settings settings;
    private final Configuration configuration;

    public StartUpWaiter(Settings settings, Configuration configuration) {
        this.settings = settings;
        this.configuration = configuration;
    }

    public void start() {
        this.settings.listenForSettings(this);
    }

    public void startAndCallbackOnMainThread() {
        this.callbackType = 0;
        this.start();
    }

    public void settingsLoaded() {
        this.configuration.queueConfigurationListener(this);
    }

    public void onConfigurationReady() {
        Runnable proc = new Runnable(){

            public void run() {
                StartUpWaiter.this.startUpReady();
            }
        };
        this.onFinished(proc);
    }

    public void onConfigurationFailure() {
        Runnable proc = new Runnable(){

            public void run() {
                StartUpWaiter.this.startUpFailed();
            }
        };
        this.onFinished(proc);
    }

    private void onFinished(Runnable proc) {
        StartUpWaiter.getExecutor(this.callbackType).execute(proc);
    }

    Settings getSettings() {
        return this.settings;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    static ThreadUtils.RunnableExecutor getExecutor(int callbackType) {
        return (ThreadUtils.RunnableExecutor)executors.get(callbackType, executors.get(1));
    }

    protected abstract void startUpReady();

    protected abstract void startUpFailed();

    static void putRunnableExecutor(int callbackType, ThreadUtils.RunnableExecutor executor) {
        if (executor == null) {
            executors.remove(callbackType);
        } else {
            executors.put(callbackType, (Object)executor);
        }
    }

    static {
        StartUpWaiter.putRunnableExecutor(0, new ThreadUtils.MainThreadScheduler());
        StartUpWaiter.putRunnableExecutor(1, new ThreadUtils.ThreadPoolScheduler());
    }
}

