/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.SISDeviceRequest;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.WebRequest;
import org.json.JSONObject;

class SISUpdateDeviceInfoRequest
extends SISDeviceRequest {
    private static final String LOGTAG = "SISUpdateDeviceInfoRequest";
    private static final Metrics.MetricType CALL_METRIC_TYPE = Metrics.MetricType.SIS_LATENCY_UPDATE_DEVICE_INFO;
    private static final String PATH = "/update_dev_info";

    public SISUpdateDeviceInfoRequest() {
        this.setCallMetricType(CALL_METRIC_TYPE);
        this.setLogTag(LOGTAG);
        this.setPath(PATH);
    }

    public WebRequest.QueryStringParameters getQueryParameters() {
        String adId = DebugProperties.getInstance().getDebugPropertyAsString("debug.adid", this.getAdvertisingIdentifierInfo().getSISDeviceIdentifier());
        WebRequest.QueryStringParameters baseQueryParameters = super.getQueryParameters();
        if (!StringUtils.isNullOrEmpty(adId)) {
            baseQueryParameters.putUrlEncoded("adId", adId);
        }
        return baseQueryParameters;
    }

    public void onResponseReceived(JSONObject payload) {
        String adId = JSONUtils.getStringFromJSON(payload, "adId", "");
        boolean idChanged = JSONUtils.getBooleanFromJSON(payload, "idChanged", false);
        if (idChanged) {
            Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.SIS_COUNTER_IDENTIFIED_DEVICE_CHANGED);
        }
        if (adId.length() > 0) {
            MobileAdsInfoStore.getInstance().getRegistrationInfo().putAdId(adId, this.getAdvertisingIdentifierInfo());
        }
    }
}

