/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.SISRequest;
import com.amazon.device.ads.SISRequestorCallback;
import com.amazon.device.ads.Version;
import com.amazon.device.ads.WebRequest;
import java.util.Map;
import org.json.JSONObject;

class SISRequestor {
    private final SISRequest[] sisRequests;
    private final SISRequestorCallback sisRequestorCallback;
    private final WebRequest.WebRequestFactory webRequestFactory;
    protected static final String API_LEVEL_ENDPOINT = "/api3";

    public SISRequestor(SISRequest ... sisRequests) {
        this((SISRequestorCallback)null, sisRequests);
    }

    public SISRequestor(SISRequestorCallback sisRequestorCallback, SISRequest ... sisRequests) {
        this(new WebRequest.WebRequestFactory(), sisRequestorCallback, sisRequests);
    }

    SISRequestor(WebRequest.WebRequestFactory webRequestFactory, SISRequestorCallback sisRequestorCallback, SISRequest ... sisRequests) {
        this.webRequestFactory = webRequestFactory;
        this.sisRequestorCallback = sisRequestorCallback;
        this.sisRequests = sisRequests;
    }

    public void startCallSIS() {
        this.callSIS();
        SISRequestorCallback sisRequestorCallback = this.getSisRequestorCallback();
        if (sisRequestorCallback != null) {
            sisRequestorCallback.onSISCallComplete();
        }
    }

    protected void callSIS() {
        for (SISRequest sisRequest : this.sisRequests) {
            this.callSIS(sisRequest);
        }
    }

    protected void callSIS(SISRequest sisRequest) {
        WebRequest.WebResponse response;
        WebRequest request = this.getWebRequest(sisRequest);
        try {
            response = request.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            return;
        }
        JSONObject jsonPayload = response.getResponseReader().readAsJSON();
        if (jsonPayload == null) {
            return;
        }
        int rcode = JSONUtils.getIntegerFromJSON(jsonPayload, "rcode", 0);
        String msg = JSONUtils.getStringFromJSON(jsonPayload, "msg", "");
        if (rcode == 1) {
            sisRequest.getLogger().i("Result - code: %d, msg: %s", rcode, msg);
            sisRequest.onResponseReceived(jsonPayload);
        } else {
            sisRequest.getLogger().w("Result - code: %d, msg: %s", rcode, msg);
        }
    }

    protected WebRequest getWebRequest(SISRequest sisRequest) {
        WebRequest request = this.webRequestFactory.createWebRequest();
        request.setExternalLogTag(sisRequest.getLogTag());
        request.setHttpMethod(WebRequest.HttpMethod.POST);
        request.setHost(SISRequestor.getHostname());
        request.setPath(SISRequestor.getEndpoint(sisRequest));
        request.enableLog(true);
        if (sisRequest.getPostParameters() != null) {
            for (Map.Entry<String, String> postParameter : sisRequest.getPostParameters().entrySet()) {
                request.putPostParameter(postParameter.getKey(), postParameter.getValue());
            }
        }
        WebRequest.QueryStringParameters queryStringParameters = sisRequest.getQueryParameters();
        RegistrationInfo registrationInfo = MobileAdsInfoStore.getInstance().getRegistrationInfo();
        queryStringParameters.putUrlEncoded("appId", registrationInfo.getAppKey());
        queryStringParameters.putUrlEncoded("sdkVer", Version.getSDKVersion());
        request.setQueryStringParameters(queryStringParameters);
        request.setMetricsCollector(Metrics.getInstance().getMetricsCollector());
        request.setServiceCallLatencyMetric(sisRequest.getCallMetricType());
        return request;
    }

    protected static String getHostname() {
        int endpointIndex;
        String hostname = Configuration.getInstance().getString(Configuration.ConfigOption.SIS_URL);
        if (hostname != null && (endpointIndex = hostname.indexOf("/")) > -1) {
            hostname = hostname.substring(0, endpointIndex);
        }
        return hostname;
    }

    protected static String getEndpoint(SISRequest sisRequest) {
        String endpoint = Configuration.getInstance().getString(Configuration.ConfigOption.SIS_URL);
        if (endpoint != null) {
            int endpointIndex = endpoint.indexOf("/");
            endpoint = endpointIndex > -1 ? endpoint.substring(endpointIndex) : "";
        }
        endpoint = endpoint + API_LEVEL_ENDPOINT + sisRequest.getPath();
        return endpoint;
    }

    protected SISRequestorCallback getSisRequestorCallback() {
        return this.sisRequestorCallback;
    }

    static class SISRequestorFactory {
        SISRequestorFactory() {
        }

        public SISRequestor createSISRequestor(SISRequest ... sisRequests) {
            return this.createSISRequestor((SISRequestorCallback)null, sisRequests);
        }

        public SISRequestor createSISRequestor(SISRequestorCallback sisRequestorCallback, SISRequest ... sisRequests) {
            return new SISRequestor(sisRequestorCallback, sisRequests);
        }
    }
}

