/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.AppEventRegistrationHandler;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.SISDeviceRequest;
import com.amazon.device.ads.SISRegisterEventRequest;
import com.amazon.device.ads.SISRequestor;
import com.amazon.device.ads.SISRequestorCallback;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.SystemTime;
import com.amazon.device.ads.ThreadUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;

class SISRegistration {
    private static final String LOGTAG = SISRegistration.class.getSimpleName();
    private static final String SIS_LAST_CHECKIN_PREF_NAME = "amzn-ad-sis-last-checkin";
    protected static final long DEFAULT_SIS_CHECKIN_INTERVAL = 86400000L;
    private static final ThreadUtils.SingleThreadScheduler singleThreadScheduler = new ThreadUtils.SingleThreadScheduler();
    private final ThreadUtils.RunnableExecutor executor;
    private final ThreadUtils.ThreadVerify threadVerify;
    private final MobileAdsLogger logger;
    private final AdvertisingIdentifier advertisingIdentifier;
    private final SISRegisterEventRequest.SISRequestFactory sisRequestFactory;
    private final SISRequestor.SISRequestorFactory sisRequestorFactory;
    private final MobileAdsInfoStore infoStore;
    private final Configuration configuration;
    private final Settings settings;
    private final AppEventRegistrationHandler appEventRegistrationHandler;
    private final SystemTime systemTime;
    private final DebugProperties debugProperties;

    public SISRegistration() {
        this(new SISRegisterEventRequest.SISRequestFactory(), new SISRequestor.SISRequestorFactory(), new AdvertisingIdentifier(), MobileAdsInfoStore.getInstance(), Configuration.getInstance(), Settings.getInstance(), AppEventRegistrationHandler.getInstance(), new SystemTime(), singleThreadScheduler, new ThreadUtils.ThreadVerify(), new MobileAdsLoggerFactory(), DebugProperties.getInstance());
    }

    SISRegistration(SISRegisterEventRequest.SISRequestFactory sisRequestFactory, SISRequestor.SISRequestorFactory sisRequestorFactory, AdvertisingIdentifier advertisingIdentifier, MobileAdsInfoStore infoStore, Configuration configuration, Settings settings, AppEventRegistrationHandler appEventRegistrationHandler, SystemTime systemTime, ThreadUtils.RunnableExecutor runnableExecutor, ThreadUtils.ThreadVerify threadVerify, MobileAdsLoggerFactory loggerFactory, DebugProperties debugProperties) {
        this.sisRequestFactory = sisRequestFactory;
        this.sisRequestorFactory = sisRequestorFactory;
        this.advertisingIdentifier = advertisingIdentifier;
        this.infoStore = infoStore;
        this.configuration = configuration;
        this.settings = settings;
        this.appEventRegistrationHandler = appEventRegistrationHandler;
        this.systemTime = systemTime;
        this.executor = runnableExecutor;
        this.threadVerify = threadVerify;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.debugProperties = debugProperties;
    }

    private MobileAdsLogger getLogger() {
        return this.logger;
    }

    protected boolean canRegister(long currentTime) {
        RegistrationInfo registrationInfo = this.infoStore.getRegistrationInfo();
        return this.exceededCheckinInterval(currentTime) || registrationInfo.shouldGetNewSISDeviceIdentifer() || registrationInfo.shouldGetNewSISRegistration() || this.debugProperties.getDebugPropertyAsBoolean("debug.shouldRegisterSIS", false) != false;
    }

    protected boolean shouldUpdateDeviceInfo() {
        return this.infoStore.getRegistrationInfo().isRegisteredWithSIS();
    }

    public void registerApp() {
        Runnable proc = new Runnable(){

            public void run() {
                SISRegistration.this.waitForConfigurationThenBeginRegistration();
            }
        };
        this.executor.execute(proc);
    }

    void waitForConfigurationThenBeginRegistration() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean canRegister = new AtomicBoolean(false);
        this.configuration.queueConfigurationListener(new Configuration.ConfigurationListener(){

            public void onConfigurationReady() {
                canRegister.set(true);
                latch.countDown();
            }

            public void onConfigurationFailure() {
                SISRegistration.this.getLogger().w("Configuration fetching failed so device registration will not proceed.");
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (canRegister.get()) {
            this.registerAppWorker();
        }
    }

    void registerAppWorker() {
        long currentTime = this.systemTime.currentTimeMillis();
        AdvertisingIdentifier.Info advertisingIdentifierInfo = this.advertisingIdentifier.getAdvertisingIdentifierInfo();
        if (advertisingIdentifierInfo.canDo() && this.canRegister(currentTime)) {
            this.putLastSISCheckin(currentTime);
            if (this.shouldUpdateDeviceInfo()) {
                this.updateDeviceInfo(this.advertisingIdentifier);
            } else {
                this.register(this.advertisingIdentifier);
            }
        }
    }

    protected boolean exceededCheckinInterval(long now) {
        return now - this.getLastSISCheckin() > this.debugProperties.getDebugPropertyAsLong("debug.sisCheckinInterval", 86400000L);
    }

    protected void register(AdvertisingIdentifier advertisingIdentifier) {
        SISDeviceRequest generateDIDRequest = this.sisRequestFactory.createDeviceRequest(SISRegisterEventRequest.SISRequestType.GENERATE_DID).setAdvertisingIdentifier(advertisingIdentifier);
        RegisterEventsSISRequestorCallback sisRequestorCallback = new RegisterEventsSISRequestorCallback(this);
        SISRequestor sisRequestor = this.sisRequestorFactory.createSISRequestor(sisRequestorCallback, generateDIDRequest);
        sisRequestor.startCallSIS();
    }

    protected void updateDeviceInfo(AdvertisingIdentifier advertisingIdentifier) {
        SISDeviceRequest updateDeviceInfoRequest = this.sisRequestFactory.createDeviceRequest(SISRegisterEventRequest.SISRequestType.UPDATE_DEVICE_INFO).setAdvertisingIdentifier(advertisingIdentifier);
        RegisterEventsSISRequestorCallback sisRequestorCallback = new RegisterEventsSISRequestorCallback(this);
        SISRequestor sisRequestor = this.sisRequestorFactory.createSISRequestor(sisRequestorCallback, updateDeviceInfoRequest);
        sisRequestor.startCallSIS();
    }

    protected long getLastSISCheckin() {
        return this.settings.getLong(SIS_LAST_CHECKIN_PREF_NAME, 0L);
    }

    private void putLastSISCheckin(long currentTime) {
        this.settings.putLong(SIS_LAST_CHECKIN_PREF_NAME, currentTime);
    }

    protected void registerEvents() {
        JSONArray appEvents;
        if (this.threadVerify.isOnMainThread()) {
            this.getLogger().e("Registering events must be done on a background thread.");
            return;
        }
        AdvertisingIdentifier.Info advertisingIdentifierInfo = this.advertisingIdentifier.getAdvertisingIdentifierInfo();
        if (advertisingIdentifierInfo.hasSISDeviceIdentifier() && (appEvents = this.appEventRegistrationHandler.getAppEventsJSONArray()) != null) {
            SISRegisterEventRequest registerEventRequest = this.sisRequestFactory.createRegisterEventRequest(advertisingIdentifierInfo, appEvents);
            SISRequestor sisRequestor = this.sisRequestorFactory.createSISRequestor(registerEventRequest);
            sisRequestor.startCallSIS();
        }
    }

    protected static class RegisterEventsSISRequestorCallback
    implements SISRequestorCallback {
        private final SISRegistration sisRegistration;

        public RegisterEventsSISRequestorCallback(SISRegistration sisRegistration) {
            this.sisRegistration = sisRegistration;
        }

        public void onSISCallComplete() {
            this.sisRegistration.registerEvents();
        }
    }
}

