/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdControlCallback;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdControllerFactory;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdListenerExecutor;
import com.amazon.device.ads.AdListenerExecutorFactory;
import com.amazon.device.ads.AdLoadStarter;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.AdRegistrationExecutor;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdState;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.DefaultAdListener;
import com.amazon.device.ads.IntentBuilder;
import com.amazon.device.ads.IntentBuilderFactory;
import com.amazon.device.ads.InterstitialAdActivityAdapter;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.RelativePosition;
import com.amazon.device.ads.ThreadUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class InterstitialAd
implements Ad {
    private static final String LOGTAG = InterstitialAd.class.getSimpleName();
    protected static final String BROADCAST_INTENT = "amazon.mobile.ads.interstitial";
    protected static final String BROADCAST_ACTION = "action";
    protected static final String ACTION_INTERSTITIAL_DISMISSED = "dismissed";
    protected static final String ACTION_INTERSTITIAL_FINISHED_LOADING = "finished";
    protected static final String BROADCAST_UNIQUE_IDENTIFIER_KEY = "uniqueIdentifier";
    protected static final String BROADCAST_CREATIVE = "creative";
    protected static final String MSG_PREPARE_AD_DESTROYED = "This interstitial ad has been destroyed and can no longer be used. Create a new InterstitialAd object to load a new ad.";
    protected static final String MSG_PREPARE_AD_SHOWING = "An interstitial ad is currently showing. Please wait for the user to dismiss the ad before loading an ad.";
    protected static final String MSG_PREPARE_AD_READY_TO_SHOW = "An interstitial ad is ready to show. Please call showAd() to show the ad before loading another ad.";
    protected static final String MSG_PREPARE_AD_LOADING = "An interstitial ad is currently loading. Please wait for the ad to finish loading and showing before loading another ad.";
    protected static final String MSG_SHOW_AD_EXPIRED = "This interstitial ad has expired. Please load another ad.";
    protected static final String MSG_SHOW_AD_ANOTHER_SHOWING = "Another interstitial ad is currently showing. Please wait for the InterstitialAdListener.onAdDismissed callback of the other ad.";
    protected static final String MSG_SHOW_AD_DESTROYED = "The interstitial ad cannot be shown because it has been destroyed. Create a new InterstitialAd object to load a new ad.";
    protected static final String MSG_SHOW_AD_DISMISSED = "The interstitial ad cannot be shown because it has already been displayed to the user. Please call loadAd(AdTargetingOptions) to load a new ad.";
    protected static final String MSG_SHOW_AD_READY_TO_LOAD = "The interstitial ad cannot be shown because it has not loaded successfully. Please call loadAd(AdTargetingOptions) to load an ad first.";
    protected static final String MSG_SHOW_AD_LOADING = "The interstitial ad cannot be shown because it is still loading. Please wait for the AdListener.onAdLoaded() callback before showing the ad.";
    protected static final String MSG_SHOW_AD_SHOWING = "The interstitial ad cannot be shown because it is already displayed on the screen. Please wait for the InterstitialAdListener.onAdDismissed() callback and then load a new ad.";
    private static final AtomicBoolean isAdShowing = new AtomicBoolean(false);
    private boolean isThisAdShowing = false;
    private final Context context;
    private int timeout = 20000;
    private final AdListenerExecutorFactory adListenerExecutorFactory;
    private AdListenerExecutor adListenerExecutor;
    private final AdControllerFactory adControllerFactory;
    private AdController adController;
    private boolean isInitialized = false;
    private final MobileAdsLoggerFactory loggerFactory;
    private final MobileAdsLogger logger;
    private final IntentBuilderFactory intentBuilderFactory;
    private final AdRegistrationExecutor adRegistration;
    private final AdLoadStarter adLoadStarter;
    private final AtomicBoolean previousAdExpired = new AtomicBoolean(false);

    public InterstitialAd(Context context) {
        this(context, new MobileAdsLoggerFactory(), new AdControllerFactory(), new IntentBuilderFactory(), AdRegistration.getAmazonAdRegistrationExecutor(), new AdLoadStarter());
    }

    InterstitialAd(Context context, MobileAdsLoggerFactory loggerFactory, AdControllerFactory adControllerFactory, IntentBuilderFactory intentBuilderFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        this(context, loggerFactory, new AdListenerExecutorFactory(loggerFactory), adControllerFactory, intentBuilderFactory, adRegistration, adLoadStarter);
    }

    InterstitialAd(Context context, MobileAdsLoggerFactory loggerFactory, AdListenerExecutorFactory adListenerExecutorFactory, AdControllerFactory adControllerFactory, IntentBuilderFactory intentBuilderFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        if (context == null) {
            throw new IllegalArgumentException("InterstitialAd requires a non-null Context");
        }
        this.context = context;
        this.loggerFactory = loggerFactory;
        this.logger = this.loggerFactory.createMobileAdsLogger(LOGTAG);
        this.adListenerExecutorFactory = adListenerExecutorFactory;
        this.adControllerFactory = adControllerFactory;
        this.intentBuilderFactory = intentBuilderFactory;
        this.adRegistration = adRegistration;
        this.adLoadStarter = adLoadStarter;
    }

    private void initializeIfNecessary() {
        if (this.isInitialized()) {
            return;
        }
        this.isInitialized = true;
        this.adRegistration.initializeAds(this.context.getApplicationContext());
        if (this.adListenerExecutor == null) {
            this.setListener(null);
        }
        this.initializeAdController();
        this.setAdditionalMetrics();
    }

    private void initializeAdController() {
        this.setAdController(this.createAdController(this.context));
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    private AdController getAdController() {
        this.initializeIfNecessary();
        if (this.adController == null) {
            this.initializeAdController();
        }
        return this.adController;
    }

    static void resetIsAdShowing() {
        isAdShowing.set(false);
    }

    public void setListener(AdListener adListener) {
        if (adListener == null) {
            adListener = new DefaultAdListener(LOGTAG);
        }
        this.adListenerExecutor = this.adListenerExecutorFactory.createAdListenerExecutor(adListener);
    }

    public boolean loadAd() {
        return this.loadAd(null);
    }

    public boolean loadAd(AdTargetingOptions options) {
        this.didAdActivityFail();
        if (!this.isReadyToLoad()) {
            switch (this.getAdController().getAdState()) {
                case RENDERED: {
                    this.logger.w(MSG_PREPARE_AD_READY_TO_SHOW);
                    break;
                }
                case SHOWING: {
                    this.logger.w(MSG_PREPARE_AD_SHOWING);
                    break;
                }
                case INVALID: {
                    if (this.getAdController().isExpired()) {
                        this.getAdController().resetToReady();
                        return this.loadAd(options);
                    }
                    this.logger.e("An interstitial ad could not be loaded because of an unknown issue with the web views.");
                    break;
                }
                case DESTROYED: {
                    this.logger.e("An interstitial ad could not be loaded because the view has been destroyed.");
                    break;
                }
                default: {
                    this.logger.w(MSG_PREPARE_AD_LOADING);
                }
            }
            return false;
        }
        this.previousAdExpired.set(false);
        this.adLoadStarter.loadAds(this.getTimeout(), options, new AdSlot(this.getAdController(), options));
        return this.getAdController().getAndResetIsPrepared();
    }

    private MetricsCollector getMetricsCollector() {
        return this.getAdController().getMetricsCollector();
    }

    public static boolean isAdShowing() {
        return isAdShowing.get();
    }

    public boolean isLoading() {
        return this.getAdController().getAdState().equals((Object)AdState.LOADING) || this.getAdController().getAdState().equals((Object)AdState.LOADED) || this.getAdController().getAdState().equals((Object)AdState.RENDERING);
    }

    public boolean isShowing() {
        return this.getAdController().getAdState().equals((Object)AdState.SHOWING);
    }

    boolean isReadyToLoad() {
        return this.getAdController().getAdState().equals((Object)AdState.READY_TO_LOAD);
    }

    boolean isReadyToShow() {
        return this.getAdController().getAdState().equals((Object)AdState.RENDERED);
    }

    public boolean isReady() {
        return this.isReadyToShow() && !this.getAdController().isExpired();
    }

    boolean didAdActivityFail() {
        boolean isFailed;
        boolean bl = isFailed = this.isThisAdShowing && !isAdShowing.get();
        if (isFailed) {
            this.getMetricsCollector().incrementMetric(Metrics.MetricType.INTERSTITIAL_AD_ACTIVITY_FAILED);
            this.getAdController().closeAd();
        }
        return isFailed;
    }

    public boolean showAd() {
        if (this.didAdActivityFail()) {
            this.logger.e("The ad could not be shown because it previously failed to show. Please load a new ad.");
            return false;
        }
        if (this.previousAdExpired.get()) {
            this.logger.w(MSG_SHOW_AD_EXPIRED);
            return false;
        }
        long renderLatencyStartTime = System.nanoTime();
        if (this.isReadyToShow()) {
            if (this.getAdController().isExpired()) {
                this.logger.w(MSG_SHOW_AD_EXPIRED);
                return false;
            }
            if (isAdShowing.getAndSet(true)) {
                this.logger.w(MSG_SHOW_AD_ANOTHER_SHOWING);
                return false;
            }
            if (this.getAdController().startAdDrawing()) {
                this.isThisAdShowing = true;
                this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME, renderLatencyStartTime);
                this.getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_SHOW_DURATION, renderLatencyStartTime);
                AdControllerFactory.cacheAdController(this.getAdController());
                this.getMetricsCollector().startMetric(Metrics.MetricType.AD_SHOW_LATENCY);
                boolean activityShown = this.showAdInActivity();
                if (!activityShown) {
                    this.clearCachedAdController();
                    this.getAdController().resetToReady();
                    isAdShowing.set(false);
                    this.isThisAdShowing = false;
                    this.getMetricsCollector().stopMetric(Metrics.MetricType.AD_LATENCY_RENDER_FAILED);
                }
                return activityShown;
            }
            this.logger.w("Interstitial ad could not be shown.");
            return false;
        }
        if (this.isReadyToLoad()) {
            this.logger.w(MSG_SHOW_AD_READY_TO_LOAD);
        } else if (this.isLoading()) {
            this.logger.w(MSG_SHOW_AD_LOADING);
        } else if (this.isShowing()) {
            this.logger.w(MSG_SHOW_AD_SHOWING);
        } else {
            this.logger.w("An interstitial ad is not ready to show.");
        }
        return false;
    }

    private void clearCachedAdController() {
        AdControllerFactory.removeCachedAdController();
    }

    boolean showAdInActivity() {
        IntentBuilder intentBuilder = this.intentBuilderFactory.createIntentBuilder();
        boolean isSuccess = intentBuilder.withClass(AdActivity.class).withContext(this.context.getApplicationContext()).withExtra("adapter", InterstitialAdActivityAdapter.class.getName()).fireIntent();
        if (!isSuccess) {
            this.logger.e("Failed to show the interstitial ad because AdActivity could not be found.");
        }
        return isSuccess;
    }

    AdController createAdController(Context context) {
        return this.adControllerFactory.buildAdController(context, AdSize.SIZE_INTERSTITIAL);
    }

    private void setAdController(AdController adController) {
        this.adController = adController;
        adController.setCallback(this.constructAdControlCallback());
    }

    AdControlCallback constructAdControlCallback() {
        return new InterstitialAdControlCallback();
    }

    void handleDismissed() {
        this.getMetricsCollector().stopMetric(Metrics.MetricType.AD_SHOW_DURATION);
        AdControllerFactory.removeCachedAdController();
        isAdShowing.set(false);
        this.isThisAdShowing = false;
        this.callOnAdDismissedOnMainThread();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private void callOnAdLoaded(AdProperties adProperties) {
        this.adListenerExecutor.onAdLoaded(this, adProperties);
    }

    void callOnAdLoadedOnMainThread(final AdProperties adProperties) {
        ThreadUtils.executeOnMainThread(new Runnable(){

            public void run() {
                InterstitialAd.this.callOnAdLoaded(adProperties);
            }
        });
    }

    void callOnAdFailedToLoad(AdError error) {
        this.adListenerExecutor.onAdFailedToLoad(this, error);
    }

    void callOnAdFailedOnMainThread(final AdError error) {
        ThreadUtils.executeOnMainThread(new Runnable(){

            public void run() {
                InterstitialAd.this.callOnAdFailedToLoad(error);
            }
        });
    }

    void callOnAdDismissed() {
        this.adListenerExecutor.onAdDismissed(this);
    }

    void callOnAdDismissedOnMainThread() {
        ThreadUtils.executeOnMainThread(new Runnable(){

            public void run() {
                InterstitialAd.this.callOnAdDismissed();
                InterstitialAd.this.submitAndResetMetrics();
            }
        });
    }

    void callOnAdExpiredOnMainThread() {
        ThreadUtils.executeOnMainThread(new Runnable(){

            public void run() {
                InterstitialAd.this.callOnAdExpired();
            }
        });
    }

    void callOnAdExpired() {
        this.adListenerExecutor.onAdExpired(this);
    }

    void submitAndResetMetrics() {
        if (this.getMetricsCollector() != null && !this.getMetricsCollector().isMetricsCollectorEmpty()) {
            this.setAdditionalMetrics();
            this.getAdController().submitAndResetMetricsIfNecessary(true);
        }
    }

    private void setAdditionalMetrics() {
        this.getMetricsCollector().setAdType(AdProperties.AdType.INTERSTITIAL);
        this.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_IS_INTERSTITIAL);
    }

    class InterstitialAdControlCallback
    implements AdControlCallback {
        private AdProperties adProperties;

        InterstitialAdControlCallback() {
        }

        public void onAdLoaded(AdProperties adProperties) {
            this.adProperties = adProperties;
            InterstitialAd.this.setAdditionalMetrics();
            InterstitialAd.this.getAdController().enableNativeCloseButton(true, RelativePosition.TOP_RIGHT);
            InterstitialAd.this.getAdController().render();
        }

        public void onAdRendered() {
            InterstitialAd.this.callOnAdLoadedOnMainThread(this.adProperties);
        }

        public void onAdFailed(AdError adError) {
            if (AdError.ErrorCode.NETWORK_TIMEOUT.equals((Object)adError.getCode())) {
                InterstitialAd.this.adController = null;
            }
            InterstitialAd.this.callOnAdFailedOnMainThread(adError);
        }

        public void onAdEvent(AdEvent event) {
        }

        public boolean isAdReady(boolean deferredLoad) {
            return InterstitialAd.this.isReadyToLoad();
        }

        public int adClosing() {
            InterstitialAd.this.handleDismissed();
            return 1;
        }

        public void postAdRendered() {
            InterstitialAd.this.getMetricsCollector().startMetric(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME);
        }

        public void onAdExpired() {
            InterstitialAd.this.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_EXPIRED_BEFORE_SHOWING);
            InterstitialAd.this.previousAdExpired.set(true);
            InterstitialAd.this.adController = null;
            InterstitialAd.this.callOnAdExpiredOnMainThread();
        }
    }
}

