/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdLoader;
import com.amazon.device.ads.AdRequest;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StartUpWaiter;
import com.amazon.device.ads.SystemTime;
import com.amazon.device.ads.ThreadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdLoadStarter {
    private static final String LOGTAG = AdLoadStarter.class.getSimpleName();
    private final MobileAdsLogger logger;
    private final AdLoader.AdLoaderFactory adLoaderFactory;
    private final AdvertisingIdentifier advertisingIdentifier;
    private final MobileAdsInfoStore infoStore;
    private final Settings settings;
    private final Configuration configuration;
    private final ThreadUtils.ThreadRunner threadRunner;
    private final SystemTime systemTime;
    private final AdRequest.AdRequestBuilder adRequestBuilder;
    private final PermissionChecker permissionChecker;

    public AdLoadStarter() {
        this(new AdLoader.AdLoaderFactory(), new AdvertisingIdentifier(), ThreadUtils.getThreadRunner(), MobileAdsInfoStore.getInstance(), Settings.getInstance(), Configuration.getInstance(), new MobileAdsLoggerFactory(), new SystemTime(), new AdRequest.AdRequestBuilder(), new PermissionChecker());
    }

    AdLoadStarter(AdLoader.AdLoaderFactory adLoaderFactory, AdvertisingIdentifier advertisingIdentifier, ThreadUtils.ThreadRunner threadRunner, MobileAdsInfoStore infoStore, Settings settings, Configuration configuration, MobileAdsLoggerFactory loggerFactory, SystemTime systemTime, AdRequest.AdRequestBuilder adRequestBuilder, PermissionChecker permissionChecker) {
        this.adLoaderFactory = adLoaderFactory;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.advertisingIdentifier = advertisingIdentifier;
        this.infoStore = infoStore;
        this.settings = settings;
        this.configuration = configuration;
        this.threadRunner = threadRunner;
        this.systemTime = systemTime;
        this.adRequestBuilder = adRequestBuilder;
        this.permissionChecker = permissionChecker;
    }

    public void loadAds(final int timeout, final AdTargetingOptions requestOptions, AdSlot ... adSlots) {
        if (this.isNoRetry(adSlots)) {
            return;
        }
        if (requestOptions != null && requestOptions.isGeoLocationEnabled() && !this.permissionChecker.hasLocationPermission(this.infoStore.getApplicationContext())) {
            this.logger.w("Geolocation for ad targeting has been disabled. To enable geolocation, add at least one of the following permissions to the app manifest: 1. ACCESS_FINE_LOCATION; 2. ACCESS_COARSE_LOCATION.");
        }
        long loadAdStartTime = this.systemTime.nanoTime();
        final ArrayList<AdSlot> requestAdSlots = new ArrayList<AdSlot>();
        for (AdSlot adSlot : adSlots) {
            if (!adSlot.prepareForAdLoad(loadAdStartTime)) continue;
            requestAdSlots.add(adSlot);
        }
        StartUpWaiter waiter = new StartUpWaiter(this.settings, this.configuration){

            protected void startUpReady() {
                AdLoadStarter.this.infoStore.register();
                AdLoadStarter.this.beginFetchAds(timeout, requestOptions, requestAdSlots);
            }

            protected void startUpFailed() {
                AdLoadStarter.this.threadRunner.execute(new Runnable(){

                    public void run() {
                        AdError adError = new AdError(AdError.ErrorCode.NETWORK_ERROR, "The configuration was unable to be loaded");
                        AdLoadStarter.this.failAds(adError, requestAdSlots);
                    }
                }, ThreadUtils.ExecutionStyle.RUN_ASAP, ThreadUtils.ExecutionThread.MAIN_THREAD);
            }
        };
        waiter.start();
    }

    @SuppressLint(value={"UseSparseArrays"})
    private void beginFetchAds(int timeout, AdTargetingOptions requestOptions, List<AdSlot> adSlots) {
        AdvertisingIdentifier.Info advertisingIdentifierInfo = this.advertisingIdentifier.getAdvertisingIdentifierInfo();
        if (!advertisingIdentifierInfo.canDo()) {
            this.failAds(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "An internal request was not made on a background thread."), adSlots);
            return;
        }
        if (requestOptions == null) {
            requestOptions = new AdTargetingOptions();
        }
        AdRequest request = this.adRequestBuilder.withAdTargetingOptions(requestOptions).withAdvertisingIdentifierInfo(advertisingIdentifierInfo).build();
        HashMap<Integer, AdSlot> goodAdSlots = new HashMap<Integer, AdSlot>();
        int slotNumber = 1;
        for (AdSlot slot : adSlots) {
            if (!slot.isValid()) continue;
            slot.setSlotNumber(slotNumber);
            goodAdSlots.put(slotNumber, slot);
            request.putSlot(slot);
            ++slotNumber;
        }
        if (goodAdSlots.size() > 0) {
            AdLoader adLoader = this.adLoaderFactory.createAdLoader(request, goodAdSlots);
            adLoader.setTimeout(timeout);
            adLoader.beginFetchAd();
        }
    }

    private void failAds(AdError adError, List<AdSlot> adSlots) {
        int adFailCount = 0;
        for (AdSlot slot : adSlots) {
            if (slot.getSlotNumber() == -1) continue;
            slot.adFailed(adError);
            ++adFailCount;
        }
        if (adFailCount > 0) {
            this.logger.e("%s; code: %s", new Object[]{adError.getMessage(), adError.getCode()});
        }
    }

    private boolean isNoRetry(AdSlot[] adSlots) {
        int noRetryTtlRemainingMillis = this.infoStore.getNoRetryTtlRemainingMillis();
        if (noRetryTtlRemainingMillis > 0) {
            AdError.ErrorCode errorCode;
            int noRetryTtlRemainingSecs = noRetryTtlRemainingMillis / 1000;
            String errorMessage = "SDK Message: ";
            if (this.infoStore.getIsAppDisabled()) {
                errorMessage = errorMessage + "DISABLED_APP";
                errorCode = AdError.ErrorCode.INTERNAL_ERROR;
            } else {
                errorMessage = errorMessage + "no results. Try again in " + noRetryTtlRemainingSecs + " seconds.";
                errorCode = AdError.ErrorCode.NO_FILL;
            }
            AdError adError = new AdError(errorCode, errorMessage);
            this.failAds(adError, new ArrayList<AdSlot>(Arrays.asList(adSlots)));
            return true;
        }
        return false;
    }
}

