/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.graphics.Rect;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdListenerExecutor;
import com.amazon.device.ads.ExtendedAdListener;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.OnAdExpiredCommand;
import com.amazon.device.ads.OnAdResizedCommand;

class AdListenerExecutorFactory {
    private final MobileAdsLoggerFactory loggerFactory;
    private final AdListenerExecutorConstructor adListenerExecutorConstructor;

    public AdListenerExecutorFactory(MobileAdsLoggerFactory loggerFactory) {
        this(loggerFactory, new AdListenerExecutorConstructor());
    }

    public AdListenerExecutorFactory(MobileAdsLoggerFactory loggerFactory, AdListenerExecutorConstructor adListenerExecutorConstructor) {
        this.loggerFactory = loggerFactory;
        this.adListenerExecutorConstructor = adListenerExecutorConstructor;
    }

    protected MobileAdsLoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public AdListenerExecutor createAdListenerExecutor(AdListener adListener) {
        return this.createAdListenerExecutor(adListener, this.loggerFactory);
    }

    public AdListenerExecutor createAdListenerExecutor(AdListener adListener, MobileAdsLoggerFactory loggerFactory) {
        AdListenerExecutor executor = this.adListenerExecutorConstructor.createAdListenerExecutor(adListener, loggerFactory);
        if (adListener instanceof ExtendedAdListener) {
            this.createAdResizedCommand(executor);
            this.createAdExpiredCommand(executor);
        }
        return executor;
    }

    private void createAdResizedCommand(final AdListenerExecutor adListenerExecutor) {
        adListenerExecutor.setOnAdResizedCommand(new OnAdResizedCommand(){

            public void onAdResized(final Ad ad, final Rect positionOnScreen) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ExtendedAdListener extendedAdListener = (ExtendedAdListener)adListenerExecutor.getAdListener();
                        extendedAdListener.onAdResized(ad, positionOnScreen);
                    }
                };
                adListenerExecutor.execute(runnable);
            }
        });
    }

    private void createAdExpiredCommand(final AdListenerExecutor adListenerExecutor) {
        adListenerExecutor.setOnAdExpiredCommand(new OnAdExpiredCommand(){

            public void onAdExpired(final Ad ad) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ExtendedAdListener extendedAdListener = (ExtendedAdListener)adListenerExecutor.getAdListener();
                        extendedAdListener.onAdExpired(ad);
                    }
                };
                adListenerExecutor.execute(runnable);
            }
        });
    }

    static class AdListenerExecutorConstructor {
        AdListenerExecutorConstructor() {
        }

        public AdListenerExecutor createAdListenerExecutor(AdListener adListener, MobileAdsLoggerFactory loggerFactory) {
            return new AdListenerExecutor(adListener, loggerFactory);
        }
    }
}

