/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.WebView;
import com.amazon.device.ads.AAXCreative;
import com.amazon.device.ads.AdCloser;
import com.amazon.device.ads.AdContainer;
import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.AdControlCallback;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdHtmlPreprocessor;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdSDKBridge;
import com.amazon.device.ads.AdSDKBridgeFactory;
import com.amazon.device.ads.AdSDKBridgeList;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.AdState;
import com.amazon.device.ads.AdTimer;
import com.amazon.device.ads.AdUrlLoader;
import com.amazon.device.ads.AdUtils2;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.AdWebViewClientFactory;
import com.amazon.device.ads.AndroidBuildInfo;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.BridgeSelector;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.ConnectionInfo;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.Destroyable;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.Position;
import com.amazon.device.ads.PreloadCallback;
import com.amazon.device.ads.RelativePosition;
import com.amazon.device.ads.SDKEvent;
import com.amazon.device.ads.SDKEventListener;
import com.amazon.device.ads.Size;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.ViewUtils;
import com.amazon.device.ads.ViewabilityObserver;
import com.amazon.device.ads.ViewabilityObserverFactory;
import com.amazon.device.ads.WebRequest;
import com.amazon.device.ads.WebUtils2;
import java.util.ArrayList;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

class AdController
implements Metrics.MetricsSubmitter {
    private static final String LOGTAG = AdController.class.getSimpleName();
    protected static final String MSG_PREPARE_AD_SHOWING = "An ad is currently showing. Please wait for the user to dismiss the ad before loading an ad.";
    protected static final String MSG_PREPARE_AD_READY_TO_SHOW = "An ad is ready to show. Please call showAd() to show the ad before loading another ad.";
    protected static final String MSG_PREPARE_AD_LOADING = "An ad is currently loading. Please wait for the ad to finish loading and showing before loading another ad.";
    protected static final String MSG_SHOW_AD_EXPIRED = "This ad has expired. Please load another ad.";
    protected static final String MSG_SHOW_AD_ANOTHER_SHOWING = "Another ad is currently showing. Please wait for the AdListener.onAdDismissed callback of the other ad.";
    protected static final String MSG_SHOW_AD_DESTROYED = "The ad cannot be shown because it has been destroyed. Create a new Ad object to load a new ad.";
    protected static final String MSG_SHOW_AD_DISMISSED = "The ad cannot be shown because it has already been displayed to the user. Please call loadAd(AdTargetingOptions) to load a new ad.";
    protected static final String MSG_SHOW_AD_READY_TO_LOAD = "The ad cannot be shown because it has not loaded successfully. Please call loadAd(AdTargetingOptions) to load an ad first.";
    protected static final String MSG_SHOW_AD_LOADING = "The ad cannot be shown because it is still loading. Please wait for the AdListener.onAdLoaded() callback before showing the ad.";
    protected static final String MSG_SHOW_AD_SHOWING = "The ad cannot be shown because it is already displayed on the screen. Please wait for the AdListener.onAdDismissed() callback and then load a new ad.";
    protected final WebUtils2 webUtils;
    private final Context context;
    private final AdSize adSize;
    private final MobileAdsLogger logger;
    private final AdUtils2 adUtils;
    private MetricsCollector metricsCollector;
    private final MobileAdsInfoStore infoStore;
    private final PermissionChecker permissionChecker;
    private final AndroidBuildInfo androidBuildInfo;
    private final AdUrlLoader adUrlLoader;
    private final AdHtmlPreprocessor adHtmlPreprocessor;
    private final AdCloser adCloser;
    private final BridgeSelector bridgeSelector;
    private final AdSDKBridgeList adSdkBridgeList;
    private final AdTimer adTimer;
    private final AdContainer.AdContainerFactory adContainerFactory;
    private final DebugProperties debugProperties;
    private final ViewUtils viewUtils;
    private AdData adData;
    private String slotID;
    private Activity adActivity;
    private int timeout = 20000;
    private AdControlCallback adControlCallback;
    private final ArrayList<SDKEventListener> sdkEventListeners = new ArrayList();
    private AdContainer adContainer;
    private AdControlAccessor adControlAccessor;
    private int adWindowHeight = 0;
    private int adWindowWidth = 0;
    private boolean windowDimensionsSet = false;
    private AdState adState = AdState.READY_TO_LOAD;
    private double scalingMultiplier = 1.0;
    private boolean isPrepared = false;
    private ConnectionInfo connectionInfo;
    private ViewGroup defaultParent = null;
    private final AtomicBoolean isRendering = new AtomicBoolean(false);
    private final AtomicBoolean hasFinishedLoading = new AtomicBoolean(false);
    private boolean disableHardwareAccelerationRequest = false;
    private boolean forceDisableHardwareAcceleration = false;
    private boolean backButtonOverridden = false;
    private boolean isModallyExpanded = false;
    private boolean orientationFailureMetricRecorded = false;
    private final ViewabilityObserver viewabilityObserver;
    private final Configuration configuration;

    public AdController(Context context, AdSize adSize) {
        this(context, adSize, new WebUtils2(), new MetricsCollector(), new MobileAdsLoggerFactory(), new AdUtils2(), new AdContainer.AdContainerFactory(), MobileAdsInfoStore.getInstance(), new PermissionChecker(), new AndroidBuildInfo(), BridgeSelector.getInstance(), new AdSDKBridgeList(), ThreadUtils.getThreadRunner(), new WebRequest.WebRequestFactory(), null, null, null, new AdTimer(), DebugProperties.getInstance(), new ViewabilityObserverFactory(), new ViewUtils(), Configuration.getInstance());
    }

    AdController(Context context, AdSize adSize, ViewabilityObserverFactory viewabilityObserverFactory) {
        this(context, adSize, new WebUtils2(), new MetricsCollector(), new MobileAdsLoggerFactory(), new AdUtils2(), new AdContainer.AdContainerFactory(), MobileAdsInfoStore.getInstance(), new PermissionChecker(), new AndroidBuildInfo(), BridgeSelector.getInstance(), new AdSDKBridgeList(), ThreadUtils.getThreadRunner(), new WebRequest.WebRequestFactory(), null, null, null, new AdTimer(), DebugProperties.getInstance(), viewabilityObserverFactory, new ViewUtils(), Configuration.getInstance());
    }

    AdController(Context context, AdSize adSize, WebUtils2 webUtils, MetricsCollector metricsCollector, MobileAdsLoggerFactory loggerFactory, AdUtils2 adUtils, AdContainer.AdContainerFactory adContainerFactory, MobileAdsInfoStore infoStore, PermissionChecker permissionChecker, AndroidBuildInfo androidBuildInfo, BridgeSelector bridgeSelector, AdSDKBridgeList adSdkBridgeList, ThreadUtils.ThreadRunner threadRunner, WebRequest.WebRequestFactory webRequestFactory, AdHtmlPreprocessor adHtmlPreprocessor, AdUrlLoader adUrlLoader, AdCloser adCloser, AdTimer adTimer, DebugProperties debugProperties, ViewabilityObserverFactory viewabilityObserverFactory, ViewUtils viewUtils, Configuration configuration) {
        this(context, adSize, webUtils, metricsCollector, loggerFactory, adUtils, adContainerFactory, infoStore, permissionChecker, androidBuildInfo, bridgeSelector, adSdkBridgeList, threadRunner, new AdWebViewClientFactory(webUtils, loggerFactory, androidBuildInfo), webRequestFactory, adHtmlPreprocessor, adUrlLoader, adCloser, adTimer, debugProperties, viewabilityObserverFactory, viewUtils, configuration);
    }

    AdController(Context context, AdSize adSize, WebUtils2 webUtils, MetricsCollector metricsCollector, MobileAdsLoggerFactory loggerFactory, AdUtils2 adUtils, AdContainer.AdContainerFactory adContainerFactory, MobileAdsInfoStore infoStore, PermissionChecker permissionChecker, AndroidBuildInfo androidBuildInfo, BridgeSelector bridgeSelector, AdSDKBridgeList adSdkBridgeList, ThreadUtils.ThreadRunner threadRunner, AdWebViewClientFactory adWebViewClientFactory, WebRequest.WebRequestFactory webRequestFactory, AdHtmlPreprocessor adHtmlPreprocessor, AdUrlLoader adUrlLoader, AdCloser adCloser, AdTimer adTimer, DebugProperties debugProperties, ViewabilityObserverFactory viewabilityObserverFactory, ViewUtils viewUtils, Configuration configuration) {
        this.context = context;
        this.adSize = adSize;
        this.webUtils = webUtils;
        this.metricsCollector = metricsCollector;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.adUtils = adUtils;
        this.adContainerFactory = adContainerFactory;
        this.infoStore = infoStore;
        this.permissionChecker = permissionChecker;
        this.androidBuildInfo = androidBuildInfo;
        this.bridgeSelector = bridgeSelector;
        this.adTimer = adTimer;
        this.debugProperties = debugProperties;
        this.adSdkBridgeList = adSdkBridgeList;
        this.viewUtils = viewUtils;
        this.adHtmlPreprocessor = adHtmlPreprocessor != null ? adHtmlPreprocessor : new AdHtmlPreprocessor(bridgeSelector, this.adSdkBridgeList, this.getAdControlAccessor(), loggerFactory, adUtils);
        if (adUrlLoader != null) {
            this.adUrlLoader = adUrlLoader;
        } else {
            AdWebViewClient adWebViewClient = adWebViewClientFactory.createAdWebViewClient(context, this.adSdkBridgeList, this.getAdControlAccessor());
            this.adUrlLoader = new AdUrlLoader(threadRunner, adWebViewClient, webRequestFactory, this.getAdControlAccessor(), webUtils, loggerFactory, infoStore.getDeviceInfo());
        }
        this.adUrlLoader.setAdWebViewClientListener(new AdControllerAdWebViewClientListener());
        this.adCloser = adCloser != null ? adCloser : new AdCloser(this);
        this.viewabilityObserver = viewabilityObserverFactory.buildViewabilityObserver(this);
        this.configuration = configuration;
    }

    AdContainer getAdContainer() {
        if (this.adContainer == null) {
            this.adContainer = this.createAdContainer();
            this.adContainer.disableHardwareAcceleration(this.shouldDisableHardwareAcceleration());
            this.adContainer.setAdWebViewClient(this.adUrlLoader.getAdWebViewClient());
        }
        return this.adContainer;
    }

    AdContainer createAdContainer() {
        return this.adContainerFactory.createAdContainer(this.context, this.adCloser);
    }

    AdControlCallback getAdControlCallback() {
        if (this.adControlCallback == null) {
            this.adControlCallback = new DefaultAdControlCallback();
        }
        return this.adControlCallback;
    }

    void setAdActivity(Activity activity) {
        this.adActivity = activity;
    }

    public void requestDisableHardwareAcceleration(boolean shouldDisable) {
        this.disableHardwareAccelerationRequest = shouldDisable;
        if (this.adContainer != null) {
            this.adContainer.disableHardwareAcceleration(this.shouldDisableHardwareAcceleration());
        }
    }

    private boolean shouldDisableHardwareAcceleration() {
        return this.forceDisableHardwareAcceleration || this.disableHardwareAccelerationRequest;
    }

    public AdControlAccessor getAdControlAccessor() {
        if (this.adControlAccessor == null) {
            this.adControlAccessor = new AdControlAccessor(this);
        }
        return this.adControlAccessor;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public void resetMetricsCollector() {
        this.metricsCollector = new MetricsCollector();
    }

    public String getInstrumentationPixelUrl() {
        if (this.adData != null) {
            return this.adData.getInstrumentationPixelUrl();
        }
        return null;
    }

    public void setAdState(AdState adState) {
        this.logger.d("Changing AdState from %s to %s", new Object[]{this.adState, adState});
        this.adState = adState;
    }

    public AdState getAdState() {
        return this.adState;
    }

    public boolean isVisible() {
        return AdState.SHOWING.equals((Object)this.getAdState()) || AdState.EXPANDED.equals((Object)this.getAdState());
    }

    public boolean isModal() {
        return this.getAdSize().isModal() || AdState.EXPANDED.equals((Object)this.getAdState()) && this.isModallyExpanded;
    }

    public void orientationChangeAttemptedWhenNotAllowed() {
        if (!this.orientationFailureMetricRecorded) {
            this.orientationFailureMetricRecorded = true;
            this.getMetricsCollector().incrementMetric(Metrics.MetricType.SET_ORIENTATION_FAILURE);
        }
    }

    protected Context getContext() {
        if (this.adActivity == null) {
            return this.context;
        }
        return this.adActivity;
    }

    protected Activity getAdActivity() {
        return this.adActivity;
    }

    public boolean getAndResetIsPrepared() {
        boolean isPrepared = this.isPrepared;
        this.isPrepared = false;
        return isPrepared;
    }

    public boolean isValid() {
        return !this.getAdState().equals((Object)AdState.INVALID);
    }

    public AdData getAdData() {
        return this.adData;
    }

    public void setAdData(AdData adData) {
        this.adData = adData;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public AdSize getAdSize() {
        return this.adSize;
    }

    public int getWindowHeight() {
        return this.adWindowHeight;
    }

    public int getWindowWidth() {
        return this.adWindowWidth;
    }

    public void setWindowDimensions(int width, int height) {
        this.adWindowWidth = width;
        this.adWindowHeight = height;
        this.windowDimensionsSet = true;
    }

    void setViewDimensionsToAdDimensions() {
        if (this.adData != null) {
            int height = (int)((double)this.adData.getHeight() * this.getScalingMultiplier() * (double)this.adUtils.getScalingFactorAsFloat());
            if (height <= 0) {
                height = -1;
            }
            if (this.getAdSize().canUpscale()) {
                this.getAdContainer().setViewHeight(height);
            } else {
                int width = (int)((double)this.adData.getWidth() * this.getScalingMultiplier() * (double)this.adUtils.getScalingFactorAsFloat());
                this.getAdContainer().setViewLayoutParams(width, height, this.getAdSize().getGravity());
            }
        }
    }

    public void setViewDimensionsToMatchParent() {
        this.getAdContainer().setViewLayoutParams(-1, -1, 17);
    }

    public boolean areWindowDimensionsSet() {
        return this.windowDimensionsSet;
    }

    public double getScalingMultiplier() {
        return this.scalingMultiplier;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public View getView() {
        return this.getAdContainer();
    }

    public Destroyable getDestroyable() {
        return this.getAdContainer();
    }

    public void stashView() {
        this.getAdContainer().stashView();
    }

    public boolean popView() {
        return this.getAdContainer().popView();
    }

    public int getViewWidth() {
        return this.getAdContainer().getViewWidth();
    }

    public int getViewHeight() {
        return this.getAdContainer().getViewHeight();
    }

    public String getMaxSize() {
        if (!this.getAdSize().isAuto()) {
            return null;
        }
        return AdSize.getAsSizeString(this.getWindowWidth(), this.getWindowHeight());
    }

    public String getScalingMultiplierDescription() {
        if (this.getScalingMultiplier() > 1.0) {
            return "u";
        }
        if (this.getScalingMultiplier() < 1.0 && this.getScalingMultiplier() > 0.0) {
            return "d";
        }
        return "n";
    }

    public void setCallback(AdControlCallback adControlCallback) {
        this.adControlCallback = adControlCallback;
    }

    public void addSDKEventListener(SDKEventListener listener) {
        this.logger.d("Add SDKEventListener %s", listener);
        this.sdkEventListeners.add(listener);
    }

    public void clearSDKEventListeners() {
        this.sdkEventListeners.clear();
    }

    public void resetToReady() {
        if (!this.canBeUsed()) {
            return;
        }
        this.adActivity = null;
        this.isPrepared = false;
        this.adTimer.cancelTimer();
        this.resetMetricsCollector();
        this.orientationFailureMetricRecorded = false;
        this.getAdContainer().destroy();
        this.adSdkBridgeList.clear();
        this.adData = null;
        this.setAdState(AdState.READY_TO_LOAD);
    }

    private void reset() {
        if (!this.canBeUsed()) {
            return;
        }
        this.isPrepared = false;
        this.adTimer.cancelTimer();
        this.resetMetricsCollector();
        this.orientationFailureMetricRecorded = false;
        if (this.adContainer != null) {
            this.adContainer.destroy();
            this.adSdkBridgeList.clear();
            this.adContainer = null;
        }
        this.adData = null;
    }

    public boolean canShowViews() {
        return this.getAdContainer().canShowViews();
    }

    public boolean prepareForAdLoad(long loadAdStartTime, boolean deferredLoad) {
        if (!this.canBeUsed()) {
            this.onRequestError("An ad could not be loaded because the view has been destroyed or was not created properly.");
            return false;
        }
        if (!this.checkDefinedActivities()) {
            String msg = "Ads cannot load unless \"com.amazon.device.ads.AdActivity\" is correctly declared as an activity in AndroidManifest.xml. Consult the online documentation for more info.";
            this.onRequestError("Ads cannot load unless \"com.amazon.device.ads.AdActivity\" is correctly declared as an activity in AndroidManifest.xml. Consult the online documentation for more info.");
            return false;
        }
        if (!this.passesInternetPermissionCheck(this.context)) {
            String msg = "Ads cannot load because the INTERNET permission is missing from the app's manifest.";
            this.onRequestError(msg);
            return false;
        }
        if (!this.isValidAppKey()) {
            String msg = "Can't load an ad because Application Key has not been set. Did you forget to call AdRegistration.setAppKey( ... )?";
            this.onRequestError(msg);
            return false;
        }
        if (!this.getAdContainer().canShowViews()) {
            String msg = "We will be unable to create a WebView for rendering an ad due to an unknown issue with the WebView.";
            Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_FAILED_UNKNOWN_WEBVIEW_ISSUE);
            this.onRequestError(msg);
            return false;
        }
        if (!this.isReadyToLoad(deferredLoad)) {
            boolean failLoad = true;
            if (this.getAdState().equals((Object)AdState.RENDERED)) {
                if (this.isExpired()) {
                    failLoad = false;
                } else {
                    this.logger.e(MSG_PREPARE_AD_READY_TO_SHOW);
                }
            } else if (this.getAdState().equals((Object)AdState.EXPANDED)) {
                this.logger.e("An ad could not be loaded because another ad is currently expanded.");
            } else {
                this.logger.e(MSG_PREPARE_AD_LOADING);
            }
            if (failLoad) {
                return false;
            }
        }
        this.reset();
        this.getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, loadAdStartTime);
        this.getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_FAILURE, loadAdStartTime);
        this.getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_SUCCESS, loadAdStartTime);
        this.getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_LOADAD_TO_FETCH_THREAD_REQUEST_START, loadAdStartTime);
        this.setAdState(AdState.LOADING);
        this.isRendering.set(false);
        this.setHasFinishedLoading(false);
        this.adTimer.restartTimer();
        this.adTimer.scheduleTask(new TimerTask(){

            public void run() {
                AdController.this.onAdTimedOut();
            }
        }, this.getTimeout());
        this.infoStore.getDeviceInfo().populateUserAgentString(this.context);
        this.isPrepared = true;
        return true;
    }

    public void initialize(String slotID) {
        if (!this.canBeUsed()) {
            return;
        }
        this.determineShouldForceDisableHardwareAcceleration();
        if (!this.initializeAdContainer()) {
            return;
        }
        this.calculateScalingMultiplier();
        for (AAXCreative creativeType : this.adData) {
            Set<AdSDKBridgeFactory> bridgeFactories = this.bridgeSelector.getBridgeFactories(creativeType);
            if (bridgeFactories == null) continue;
            for (AdSDKBridgeFactory bridgeFactory : bridgeFactories) {
                this.addAdSDKBridge(bridgeFactory.createAdSDKBridge(this.getAdControlAccessor()));
            }
        }
        this.slotID = slotID;
        this.adLoaded();
    }

    private void addAdSDKBridge(AdSDKBridge adSdkbridge) {
        this.adSdkBridgeList.addBridge(adSdkbridge);
    }

    private void calculateScalingMultiplier() {
        if (!this.isInterstitial()) {
            float scalingDensity = this.infoStore.getDeviceInfo().getScalingFactorAsFloat();
            int adWidth = (int)((float)this.adData.getWidth() * scalingDensity);
            int adHeight = (int)((float)this.adData.getHeight() * scalingDensity);
            this.scalingMultiplier = this.adUtils.calculateScalingMultiplier(adWidth, adHeight, this.getWindowWidth(), this.getWindowHeight());
            int maxWidth = this.getAdSize().getMaxWidth();
            if (maxWidth > 0 && (double)this.adData.getWidth() * this.scalingMultiplier > (double)maxWidth) {
                this.scalingMultiplier = (double)maxWidth / (double)this.adData.getWidth();
            }
            if (!this.getAdSize().canUpscale() && this.scalingMultiplier > 1.0) {
                this.scalingMultiplier = 1.0;
            }
            this.setViewDimensionsToAdDimensions();
        } else {
            this.scalingMultiplier = -1.0;
        }
    }

    private void determineShouldForceDisableHardwareAcceleration() {
        this.forceDisableHardwareAcceleration = (AndroidTargetUtils.isAndroidAPI(this.androidBuildInfo, 14) || AndroidTargetUtils.isAndroidAPI(this.androidBuildInfo, 15)) && this.adData.getCreativeTypes().contains((Object)AAXCreative.REQUIRES_TRANSPARENCY);
    }

    boolean initializeAdContainer() {
        try {
            this.getAdContainer().initialize();
        }
        catch (IllegalStateException e) {
            String message = "An unknown error occurred when attempting to create the web view.";
            this.adFailed(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "An unknown error occurred when attempting to create the web view."));
            this.setAdState(AdState.INVALID);
            this.logger.e("An unknown error occurred when attempting to create the web view.");
            return false;
        }
        return true;
    }

    public void render() {
        if (!this.canBeUsed()) {
            return;
        }
        this.setAdState(AdState.RENDERING);
        long renderStartTime = System.nanoTime();
        this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_RENDER_START, renderStartTime);
        this.getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER, renderStartTime);
        this.isRendering.set(true);
        String html = this.adData.getCreative();
        this.loadHtml(this.configuration.getStringWithDefault(Configuration.ConfigOption.BASE_URL, "http://mads.amazon-adsystem.com/"), html);
    }

    public void preloadHtml(String baseUrl, String html, PreloadCallback callback) {
        this.loadHtml(baseUrl, html, true, callback);
    }

    public void loadHtml(String baseUrl, String html) {
        this.loadHtml(baseUrl, html, false, null);
    }

    public void loadHtml(String baseUrl, String html, boolean shouldPreload, PreloadCallback callback) {
        this.getAdContainer().removePreviousInterfaces();
        this.clearSDKEventListeners();
        html = this.adHtmlPreprocessor.preprocessHtml(html, shouldPreload);
        this.getAdContainer().loadHtml(baseUrl, html, shouldPreload, callback);
    }

    public void preloadUrl(String url, PreloadCallback callback) {
        this.adUrlLoader.loadUrl(url, true, callback);
    }

    public void loadUrl(String url) {
        this.adUrlLoader.loadUrl(url, false, null);
    }

    public void openUrl(String url) {
        this.adUrlLoader.openUrl(url);
    }

    public void setExpanded(boolean isExpanded) {
        if (isExpanded) {
            this.setAdState(AdState.EXPANDED);
        } else {
            this.setAdState(AdState.SHOWING);
        }
    }

    public void injectJavascript(final String javascript, final boolean preload) {
        ThreadUtils.executeOnMainThread(new Runnable(){

            public void run() {
                AdController.this.getAdContainer().injectJavascript(javascript, preload);
            }
        });
    }

    public void destroy() {
        if (!this.canBeUsed()) {
            this.logger.e("The ad cannot be destroyed because it has already been destroyed.");
            return;
        }
        this.closeAd();
        this.adState = AdState.DESTROYED;
        if (this.adContainer != null) {
            this.getAdContainer().destroy();
            this.adSdkBridgeList.clear();
            this.adContainer = null;
        }
        this.isPrepared = false;
        this.metricsCollector = null;
        this.adData = null;
    }

    protected boolean passesInternetPermissionCheck(Context context) {
        return this.permissionChecker.hasInternetPermission(context);
    }

    public void onRequestError(String message) {
        this.logger.e(message);
        this.adFailed(new AdError(AdError.ErrorCode.REQUEST_ERROR, message));
    }

    public boolean isExpired() {
        return this.adData != null && this.adData.isExpired();
    }

    public boolean canBeUsed() {
        return !AdState.DESTROYED.equals((Object)this.getAdState()) && !AdState.INVALID.equals((Object)this.getAdState());
    }

    private boolean isReadyToLoad(boolean deferredLoad) {
        return this.getAdControlCallback().isAdReady(deferredLoad);
    }

    public boolean startAdDrawing() {
        this.adTimer.cancelTimer();
        return AdState.RENDERED.equals((Object)this.getAdState()) && this.canExpireOrDraw(AdState.DRAWING);
    }

    private synchronized boolean canExpireOrDraw(AdState newState) {
        if (AdState.RENDERED.compareTo(this.getAdState()) >= 0) {
            this.setAdState(newState);
            return true;
        }
        return false;
    }

    public void adShown() {
        if (!this.canBeUsed()) {
            return;
        }
        this.getMetricsCollector().stopMetric(Metrics.MetricType.AD_SHOW_LATENCY);
        this.adTimer.cancelTimer();
        if (this.canFireImpressionPixel()) {
            boolean disconnectEnabled = false;
            this.webUtils.executeWebRequestInThread(this.getAdData().getImpressionPixelUrl(), false);
        }
        this.setAdState(AdState.SHOWING);
        if (!this.areWindowDimensionsSet()) {
            this.setWindowDimensions(this.getView().getWidth(), this.getView().getHeight());
        }
        this.fireSDKEvent(new SDKEvent(SDKEvent.SDKEventType.VISIBLE));
        this.viewabilityObserver.fireViewableEvent(false);
    }

    private boolean canFireImpressionPixel() {
        return !this.getAdState().equals((Object)AdState.HIDDEN);
    }

    public void adHidden() {
        this.setAdState(AdState.HIDDEN);
        this.fireSDKEvent(new SDKEvent(SDKEvent.SDKEventType.HIDDEN));
    }

    void onAdTimedOut() {
        if (this.debugProperties.getDebugPropertyAsBoolean("debug.canTimeout", true).booleanValue() && !this.getAndSetHasFinishedLoading(true)) {
            this.adFailedAfterTimerCheck(new AdError(AdError.ErrorCode.NETWORK_TIMEOUT, "Ad Load Timed Out"));
            this.setAdState(AdState.INVALID);
        }
    }

    private void onAdExpired() {
        if (AdState.RENDERED.compareTo(this.getAdState()) >= 0 && this.canExpireOrDraw(AdState.INVALID)) {
            this.logger.d("Ad Has Expired");
            this.callOnAdExpired();
        }
    }

    private void callOnAdExpired() {
        ThreadUtils.scheduleOnMainThread(new Runnable(){

            public void run() {
                AdController.this.getAdControlCallback().onAdExpired();
                AdController.this.submitAndResetMetricsIfNecessary(true);
            }
        });
    }

    public void adFailed(AdError error) {
        if (!this.canBeUsed()) {
            return;
        }
        if (!this.getAndSetHasFinishedLoading(true)) {
            this.adTimer.cancelTimer();
            this.adFailedAfterTimerCheck(error);
            this.setAdState(AdState.READY_TO_LOAD);
        }
    }

    private void adFailedAfterTimerCheck(AdError error) {
        if (this.getMetricsCollector() == null || this.getMetricsCollector().isMetricsCollectorEmpty()) {
            this.adFailedBeforeAdMetricsStart(error);
        } else {
            this.adFailedAfterAdMetricsStart(error);
        }
    }

    private void adLoaded() {
        if (!this.canBeUsed()) {
            return;
        }
        this.setAdState(AdState.LOADED);
        AdProperties adProperties = this.adData.getProperties();
        this.callOnAdLoaded(adProperties);
    }

    void adFailedBeforeAdMetricsStart(AdError error) {
        this.callOnAdFailedToLoad(error, false);
    }

    void adFailedAfterAdMetricsStart(AdError error) {
        this.accumulateAdFailureMetrics(error);
        this.callOnAdFailedToLoad(error, true);
    }

    void accumulateAdFailureMetrics(AdError error) {
        long renderStopTime = System.nanoTime();
        this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, renderStopTime);
        this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_FAILURE, renderStopTime);
        this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_FAILURE, renderStopTime);
        if (error != null && (AdError.ErrorCode.NO_FILL.equals((Object)error.getCode()) || AdError.ErrorCode.NETWORK_ERROR.equals((Object)error.getCode()) || AdError.ErrorCode.NETWORK_TIMEOUT.equals((Object)error.getCode()) || AdError.ErrorCode.INTERNAL_ERROR.equals((Object)error.getCode()))) {
            this.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_LOAD_FAILED);
            if (error.getCode() == AdError.ErrorCode.NETWORK_TIMEOUT) {
                if (this.isRendering.get()) {
                    this.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_LOAD_FAILED_ON_PRERENDERING_TIMEOUT);
                } else {
                    this.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_LOAD_FAILED_ON_AAX_CALL_TIMEOUT);
                }
            }
        }
        this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER_FAILED, renderStopTime);
        if (this.getAdState().equals((Object)AdState.RENDERING)) {
            this.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_RENDERING_FATAL);
        }
        this.setAdditionalMetrics();
    }

    public void adRendered(String url) {
        if (!this.canBeUsed()) {
            return;
        }
        this.logger.d("Ad Rendered");
        if (this.getAdState().equals((Object)AdState.RENDERING)) {
            if (!this.getAndSetHasFinishedLoading(true)) {
                this.isRendering.set(false);
                this.adTimer.cancelTimer();
                this.startExpirationTimer();
                this.setAdState(AdState.RENDERED);
                this.callOnAdRendered();
                long renderStopTime = System.nanoTime();
                if (this.getMetricsCollector() != null) {
                    this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER, renderStopTime);
                    this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, renderStopTime);
                    this.getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_SUCCESS, renderStopTime);
                    this.setAdditionalMetrics();
                    this.submitAndResetMetricsIfNecessary(true);
                }
                this.callPostAdRendered();
            }
        } else {
            this.logger.d("Ad State was not Rendering. It was " + (Object)((Object)this.getAdState()));
        }
        this.fireSDKEvent(new SDKEvent(SDKEvent.SDKEventType.RENDERED).setParameter("url", url));
    }

    private void startExpirationTimer() {
        long timeToExpire = this.getAdData().getTimeToExpire();
        if (timeToExpire > 0L) {
            this.adTimer.restartTimer();
            this.adTimer.scheduleTask(new TimerTask(){

                public void run() {
                    AdController.this.onAdExpired();
                }
            }, timeToExpire);
        }
    }

    void callOnAdFailedToLoad(final AdError error, final boolean shouldSubmitMetrics) {
        ThreadUtils.scheduleOnMainThread(new Runnable(){

            public void run() {
                AdController.this.getAdControlCallback().onAdFailed(error);
                AdController.this.submitAndResetMetricsIfNecessary(shouldSubmitMetrics);
            }
        });
    }

    void callOnAdLoaded(final AdProperties adProperties) {
        ThreadUtils.scheduleOnMainThread(new Runnable(){

            public void run() {
                if (!AdController.this.canBeUsed()) {
                    return;
                }
                AdController.this.getAdControlCallback().onAdLoaded(adProperties);
            }
        });
    }

    void callOnAdRendered() {
        ThreadUtils.scheduleOnMainThread(new Runnable(){

            public void run() {
                if (!AdController.this.canBeUsed()) {
                    return;
                }
                AdController.this.getAdControlCallback().onAdRendered();
            }
        });
    }

    void callPostAdRendered() {
        ThreadUtils.scheduleOnMainThread(new Runnable(){

            public void run() {
                if (!AdController.this.canBeUsed()) {
                    return;
                }
                AdController.this.getAdControlCallback().postAdRendered();
            }
        });
    }

    void callOnAdEvent(final AdEvent adEvent) {
        ThreadUtils.scheduleOnMainThread(new Runnable(){

            public void run() {
                if (!AdController.this.canBeUsed()) {
                    return;
                }
                AdController.this.getAdControlCallback().onAdEvent(adEvent);
            }
        });
    }

    void setHasFinishedLoading(boolean hasFinishedLoading) {
        this.hasFinishedLoading.set(hasFinishedLoading);
    }

    boolean getAndSetHasFinishedLoading(boolean hasFinishedLoading) {
        return this.hasFinishedLoading.getAndSet(hasFinishedLoading);
    }

    public void fireAdEvent(AdEvent event) {
        this.logger.d("Firing AdEvent of type %s", new Object[]{event.getAdEventType()});
        this.callOnAdEvent(event);
    }

    public void fireSDKEvent(SDKEvent event) {
        this.logger.d("Firing SDK Event of type %s", new Object[]{event.getEventType()});
        for (SDKEventListener listener : this.sdkEventListeners) {
            listener.onSDKEvent(event, this.getAdControlAccessor());
        }
    }

    public void fireViewableEvent() {
        this.viewabilityObserver.fireViewableEvent(false);
    }

    public boolean closeAd() {
        return this.adCloser.closeAd();
    }

    public void enableNativeCloseButton(boolean showImage, RelativePosition position) {
        this.getAdContainer().enableNativeCloseButton(showImage, position);
    }

    public void removeNativeCloseButton() {
        this.getAdContainer().removeNativeCloseButton();
    }

    public void showNativeCloseButtonImage(boolean showNativeCloseButtonImage) {
        this.getAdContainer().showNativeCloseButtonImage(showNativeCloseButtonImage);
    }

    protected void setAdditionalMetrics() {
        this.adUtils.setConnectionMetrics(this.getConnectionInfo(), this.getMetricsCollector());
        if (this.getWindowHeight() == 0) {
            this.getMetricsCollector().incrementMetric(Metrics.MetricType.ADLAYOUT_HEIGHT_ZERO);
        }
        this.getMetricsCollector().setMetricString(Metrics.MetricType.VIEWPORT_SCALE, this.getScalingMultiplierDescription());
    }

    public void submitAndResetMetrics() {
        Metrics.getInstance().submitAndResetMetrics(this);
    }

    public void submitAndResetMetricsIfNecessary(boolean shouldSubmitMetrics) {
        if (shouldSubmitMetrics) {
            this.submitAndResetMetrics();
        }
    }

    public void moveViewToViewGroup(ViewGroup newViewGroup, ViewGroup.LayoutParams layoutParams, boolean isModal) {
        ViewGroup currentParent = this.getViewParent();
        if (this.defaultParent == null) {
            this.defaultParent = currentParent;
        }
        if (currentParent != null) {
            currentParent.removeView(this.getView());
        }
        this.setViewDimensionsToMatchParent();
        newViewGroup.addView(this.getView(), layoutParams);
        this.isModallyExpanded = isModal;
        this.setExpanded(true);
        if (this.isModallyExpanded) {
            this.captureBackButton();
        }
    }

    public void captureBackButton() {
        this.getAdContainer().listenForKey(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4 && event.getRepeatCount() == 0) {
                    AdController.this.onBackButtonPress();
                    return true;
                }
                return false;
            }
        });
    }

    boolean onBackButtonPress() {
        if (this.backButtonOverridden) {
            this.fireSDKEvent(new SDKEvent(SDKEvent.SDKEventType.BACK_BUTTON_PRESSED));
            return true;
        }
        this.closeAd();
        return false;
    }

    ViewGroup getViewParent() {
        return (ViewGroup)this.getView().getParent();
    }

    ViewGroup getViewParentIfExpanded() {
        if (this.defaultParent != null && this.defaultParent != this.getView().getParent()) {
            return this.getViewParent();
        }
        return null;
    }

    public void moveViewBackToParent(ViewGroup.LayoutParams params) {
        ViewGroup parent = (ViewGroup)this.getView().getParent();
        if (parent != null) {
            parent.removeView(this.getView());
        }
        this.setViewDimensionsToAdDimensions();
        if (this.defaultParent != null) {
            this.defaultParent.addView(this.getView(), params);
        }
        this.getAdContainer().listenForKey(null);
        this.setExpanded(false);
    }

    boolean checkDefinedActivities() {
        return this.adUtils.checkDefinedActivities(this.getContext().getApplicationContext());
    }

    boolean isValidAppKey() {
        return this.infoStore.getRegistrationInfo().getAppKey() != null;
    }

    Position getAdPosition() {
        int adWidth = this.getViewWidth();
        int adHeight = this.getViewHeight();
        if (adWidth == 0 && adHeight == 0) {
            adWidth = this.getWindowWidth();
            adHeight = this.getWindowHeight();
        }
        int width = this.adUtils.pixelToDeviceIndependentPixel(adWidth);
        int height = this.adUtils.pixelToDeviceIndependentPixel(adHeight);
        int[] onScreen = new int[2];
        this.getAdContainer().getViewLocationOnScreen(onScreen);
        View rootView = this.getRootView();
        if (rootView == null) {
            this.logger.w("Could not find the activity's root view while determining ad position.");
            return null;
        }
        int[] rootViewPos = new int[2];
        rootView.getLocationOnScreen(rootViewPos);
        int xPosition = this.adUtils.pixelToDeviceIndependentPixel(onScreen[0]);
        int yPosition = this.adUtils.pixelToDeviceIndependentPixel(onScreen[1] - rootViewPos[1]);
        return new Position(new Size(width, height), xPosition, yPosition);
    }

    boolean isInterstitial() {
        return AdSize.SizeType.INTERSTITIAL.equals((Object)this.adSize.getSizeType());
    }

    public Size getMaxExpandableSize() {
        View rootView = this.getRootView();
        if (rootView == null) {
            this.logger.w("Could not find the activity's root view while determining max expandable size.");
            return null;
        }
        int widthPixels = rootView.getWidth();
        int heightPixels = rootView.getHeight();
        return new Size(this.adUtils.pixelToDeviceIndependentPixel(widthPixels), this.adUtils.pixelToDeviceIndependentPixel(heightPixels));
    }

    Size getScreenSize() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        int heightPixels = metrics.heightPixels;
        return new Size(this.adUtils.pixelToDeviceIndependentPixel(widthPixels), this.adUtils.pixelToDeviceIndependentPixel(heightPixels));
    }

    void getMetrics(DisplayMetrics metrics) {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
    }

    void addJavascriptInterface(Object jsif, boolean shouldPreload, String interfaceName) {
        this.getAdContainer().addJavascriptInterface(jsif, shouldPreload, interfaceName);
    }

    void reload() {
        this.getAdContainer().reload();
    }

    void putUrlExecutorInAdWebViewClient(String scheme, AdWebViewClient.UrlExecutor executor) {
        this.adUrlLoader.putUrlExecutorInAdWebViewClient(scheme, executor);
    }

    public void overrideBackButton(boolean override) {
        this.backButtonOverridden = override;
    }

    public void setAllowClicks(boolean allowClicks) {
        this.getAdContainer().setAllowClicks(allowClicks);
    }

    public void registerViewabilityInterest() {
        this.viewabilityObserver.registerViewabilityInterest();
    }

    public void deregisterViewabilityInterest() {
        this.viewabilityObserver.deregisterViewabilityInterest();
    }

    public boolean isViewable() {
        return this.viewabilityObserver.isViewable();
    }

    public void addOnGlobalLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        this.adContainer.getViewTreeObserver().addOnGlobalLayoutListener(listener);
    }

    public void removeOnGlobalLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (this.adContainer == null) {
            return;
        }
        this.viewUtils.removeOnGlobalLayoutListener(this.adContainer.getViewTreeObserver(), listener);
    }

    public View getRootView() {
        return this.getAdContainer().getRootView().findViewById(0x1020002);
    }

    public String getSlotID() {
        return this.slotID;
    }

    private class AdControllerAdWebViewClientListener
    implements AdWebViewClient.AdWebViewClientListener {
        private AdControllerAdWebViewClientListener() {
        }

        public void onPageFinished(WebView webView, String url) {
            if (AdController.this.getAdContainer().isCurrentView((View)webView)) {
                AdController.this.adRendered(url);
            }
        }

        public void onPageStarted(WebView view, String url) {
        }

        public void onLoadResource(WebView view, String url) {
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        }
    }

    class DefaultAdControlCallback
    implements AdControlCallback {
        DefaultAdControlCallback() {
        }

        public boolean isAdReady(boolean deferredLoad) {
            AdController.this.logger.d("DefaultAdControlCallback isAdReady called");
            return AdController.this.getAdState().equals((Object)AdState.READY_TO_LOAD) || AdController.this.getAdState().equals((Object)AdState.SHOWING);
        }

        public void onAdLoaded(AdProperties adProperties) {
            AdController.this.logger.d("DefaultAdControlCallback onAdLoaded called");
        }

        public void onAdRendered() {
            AdController.this.logger.d("DefaultAdControlCallback onAdRendered called");
        }

        public void postAdRendered() {
            AdController.this.logger.d("DefaultAdControlCallback postAdRendered called");
        }

        public void onAdFailed(AdError adError) {
            AdController.this.logger.d("DefaultAdControlCallback onAdFailed called");
        }

        public void onAdEvent(AdEvent event) {
            AdController.this.logger.d("DefaultAdControlCallback onAdEvent called");
        }

        public int adClosing() {
            AdController.this.logger.d("DefaultAdControlCallback adClosing called");
            return 1;
        }

        public void onAdExpired() {
            AdController.this.logger.d("DefaultAdControlCallback onAdExpired called");
        }
    }
}

