/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.amazon.device.ads.AdCloser;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.Destroyable;
import com.amazon.device.ads.NativeCloseButton;
import com.amazon.device.ads.PreloadCallback;
import com.amazon.device.ads.RelativePosition;
import com.amazon.device.ads.ViewManager;
import com.amazon.device.ads.ViewManagerFactory;

@SuppressLint(value={"ViewConstructor"})
class AdContainer
extends FrameLayout
implements Destroyable {
    private static final String CONTENT_DESCRIPTION_AD_CONTAINER = "adContainerObject";
    private ViewManager viewManager;
    private final NativeCloseButton nativeCloseButton;
    private boolean disableHardwareAcceleration = false;
    private String baseUrl;
    private String html;
    private boolean shouldPreload;
    private PreloadCallback preloadCallback;
    private boolean allowClicks = true;

    public AdContainer(Context context, AdCloser adCloser) {
        this(context, adCloser, new ViewManagerFactory(), null);
    }

    AdContainer(Context context, AdCloser adCloser, ViewManagerFactory viewManagerFactory, NativeCloseButton nativeCloseButton) {
        super(context);
        this.viewManager = viewManagerFactory.withViewGroup((ViewGroup)this).createViewManager();
        this.setContentDescription(CONTENT_DESCRIPTION_AD_CONTAINER);
        this.nativeCloseButton = nativeCloseButton == null ? new NativeCloseButton((ViewGroup)this, adCloser) : nativeCloseButton;
    }

    public void initialize() throws IllegalStateException {
        this.viewManager.disableHardwareAcceleration(this.disableHardwareAcceleration);
        this.viewManager.initialize();
    }

    public void setAdWebViewClient(AdWebViewClient adWebViewClient) {
        this.viewManager.setWebViewClient(adWebViewClient);
    }

    public void disableHardwareAcceleration(boolean shouldDisable) {
        this.disableHardwareAcceleration = shouldDisable;
        if (this.viewManager != null) {
            this.viewManager.disableHardwareAcceleration(this.disableHardwareAcceleration);
        }
    }

    public void destroy() {
        this.viewManager.destroy();
    }

    public void injectJavascript(String javascript, boolean preload) {
        this.viewManager.loadUrl("javascript:" + javascript, preload, null);
    }

    public void setViewHeight(int height) {
        this.viewManager.setHeight(height);
    }

    public void setViewLayoutParams(int width, int height, int gravity) {
        this.viewManager.setLayoutParams(width, height, gravity);
    }

    public int getViewWidth() {
        return this.viewManager.getWidth();
    }

    public int getViewHeight() {
        return this.viewManager.getHeight();
    }

    public void getViewLocationOnScreen(int[] location) {
        this.viewManager.getLocationOnScreen(location);
    }

    public boolean canShowViews() {
        return this.viewManager.canShowViews();
    }

    public void loadHtml(String baseUrl, String html, boolean shouldPreload, PreloadCallback callback) {
        this.baseUrl = baseUrl;
        this.html = html;
        this.shouldPreload = shouldPreload;
        this.preloadCallback = callback;
        this.viewManager.loadDataWithBaseURL(baseUrl, html, "text/html", "UTF-8", null, shouldPreload, callback);
    }

    public WebView getCurrentAdView() {
        return this.viewManager.getCurrentAdView();
    }

    public void removePreviousInterfaces() {
        this.viewManager.removePreviousInterfaces();
    }

    public void addJavascriptInterface(Object jsif, boolean shouldPreload, String interfaceName) {
        this.viewManager.addJavascriptInterface(jsif, shouldPreload, interfaceName);
    }

    public void reload() {
        this.loadHtml(this.baseUrl, this.html, this.shouldPreload, this.preloadCallback);
    }

    public boolean isCurrentView(View view) {
        return this.viewManager.isCurrentView(view);
    }

    public void stashView() {
        this.viewManager.stashView();
    }

    public boolean popView() {
        return this.viewManager.popView();
    }

    public void enableNativeCloseButton(boolean showImage, RelativePosition position) {
        this.nativeCloseButton.enable(showImage, position);
    }

    public void removeNativeCloseButton() {
        this.nativeCloseButton.remove();
    }

    public void showNativeCloseButtonImage(boolean show) {
        this.nativeCloseButton.showImage(show);
    }

    public void listenForKey(View.OnKeyListener keyListener) {
        this.viewManager.listenForKey(keyListener);
    }

    public void setAllowClicks(boolean allowClicks) {
        this.allowClicks = allowClicks;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return !this.allowClicks;
    }

    static class AdContainerFactory {
        AdContainerFactory() {
        }

        public AdContainer createAdContainer(Context context, AdCloser adCloser) {
            return new AdContainer(context, adCloser);
        }
    }
}

