/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBMetricReport;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DtbConstants;
import com.amazon.device.ads.DtbHttpClient;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbThreadService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public class DTBMetricsProcessor {
    private List<DTBMetricReport> reportQueue;
    private static DTBMetricsProcessor theProcessor;
    static String REPORT_MEDIATION_LATENCY;
    static String REPORT_LOST_BID;
    static String REPORT_LOAD_LATENCY;
    static String REPORT_LOAD_FAILURE;
    static String ALERT_SDK_WRAPPING;
    static String ALERT_SDK_WRAPPING_V2;
    private boolean running;
    private final Object lock = new Object();
    private static String SIMPLE_TAG;

    static DTBMetricsProcessor getInstance() {
        return theProcessor;
    }

    private DTBMetricsProcessor() {
        this.reportQueue = new ArrayList<DTBMetricReport>();
    }

    private boolean isMainThread() {
        return DTBAdUtil.isMainThread();
    }

    void submitExpiredReport(List<DTBMetricReport.BidWrapper> bidWrappers) {
        if (this.isMainThread()) {
            DtbThreadService.getInstance().execute(() -> this.submitExpiredReportImpl(bidWrappers));
        } else {
            this.submitExpiredReportImpl(bidWrappers);
        }
    }

    private void submitExpiredReportImpl(List<DTBMetricReport.BidWrapper> bidWrappers) {
        for (DTBMetricReport.BidWrapper bidWrapper : bidWrappers) {
            DTBMetricReport report = DTBMetricReport.reportWithBidIdAndType(bidWrapper, REPORT_LOST_BID);
            this.addReport(report);
        }
        this.dispenseReport();
    }

    void submitSimpleReportBidId(DTBMetricReport.BidWrapper bidWrapper, String type) {
        DTBMetricReport report = DTBMetricReport.reportWithBidIdAndType(bidWrapper, type);
        this.addReport(report);
        this.dispenseReport();
    }

    void submitErrorReport(String type, Map<String, Object> extra) {
        DTBMetricReport report = DTBMetricReport.reportWithTypeAndExtraProperties(type, extra);
        this.addReport(report);
        this.dispenseReport();
    }

    void submitErrorReport(String type, Map<String, Object> extra, DTBMetricReport.BidWrapper bidWrapper) {
        DTBMetricReport report = DTBMetricReport.reportWithTypeAndExtraProperties(type, extra, bidWrapper);
        this.addReport(report);
        this.dispenseReport();
    }

    void submitLatencyReportBidId(DTBMetricReport.BidWrapper bidWrapper, String type, int millis) {
        DTBMetricReport report = DTBMetricReport.reportWithBidTypeLatency(bidWrapper, type, millis);
        this.addReport(report);
        this.dispenseReport();
    }

    private void dispenseReport() {
        if (this.isMainThread()) {
            DtbThreadService.getInstance().execute(() -> this.dispenseReportImpl());
        } else {
            this.dispenseReportImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispenseReportImpl() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                return;
            }
            this.running = true;
        }
        while (this.reportQueue.size() > 0) {
            DTBMetricReport report = this.reportQueue.get(0);
            try {
                if (!DTBMetricsConfiguration.getInstance().isTypeEnabled(report.getType())) {
                    DtbLog.debug(SIMPLE_TAG, "Report type:" + report.getType() + " is ignored");
                    this.removeFromQueue();
                    continue;
                }
                String url = this.getCompleteURLForPixelsBasedOnReportURL(report);
                DtbLog.debug(SIMPLE_TAG, "Report URL:\n" + url + "\nType:" + report.getType());
                DtbLog.debug(SIMPLE_TAG, "Report:\n" + report);
                DtbHttpClient httpClient = new DtbHttpClient(url);
                httpClient.executeGET(60000);
                this.removeFromQueue();
                DtbLog.debug(SIMPLE_TAG, "Report Submission Success");
            }
            catch (MalformedURLException e) {
                DtbLog.warn("Malformed Exception:" + e.getMessage());
                break;
            }
            catch (IOException ioex) {
                DtbLog.warn("IOException:" + ioex.getMessage());
                DtbLog.debug(SIMPLE_TAG, "Report Submission Failure");
                break;
            }
            catch (RuntimeException | JSONException e) {
                DtbLog.warn("Exception:" + e.getMessage());
                this.removeFromQueue();
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Exception occurred while processing metric report", (Exception)e);
            }
        }
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReport(DTBMetricReport report) {
        List<DTBMetricReport> list = this.reportQueue;
        synchronized (list) {
            this.reportQueue.add(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromQueue() {
        List<DTBMetricReport> list = this.reportQueue;
        synchronized (list) {
            this.reportQueue.remove(0);
        }
    }

    private String getCompleteURLForPixelsBasedOnReportURL(DTBMetricReport report) throws UnsupportedEncodingException {
        String aaxHost = report.getHostname() == null || report.getHostname().trim().length() == 0 ? DtbConstants.AAX_HOSTNAME : report.getHostname();
        String url = report.getBidId() != null && report.getBidId().trim().length() != 0 ? String.format("%s/x/px/%s/%s%s", aaxHost, report.getBidId(), report.toEncodedString(), DTBMetricsProcessor.cacheBusterQueryString()) : String.format("%s/x/px/p/PH/%s%s", aaxHost, report.toEncodedString(), DTBMetricsProcessor.cacheBusterQueryString());
        return url;
    }

    private static String cacheBusterQueryString() {
        if (AdRegistration.isTestMode()) {
            return "?cb=0";
        }
        double v = Math.random();
        int intv = (int)(v * 1.0E7);
        return String.format("?cb=%d", intv);
    }

    static {
        REPORT_MEDIATION_LATENCY = "mediation_latency";
        REPORT_LOST_BID = "lost_bid";
        REPORT_LOAD_LATENCY = "fetch_latency";
        REPORT_LOAD_FAILURE = "fetch_failure";
        ALERT_SDK_WRAPPING = "alert_sdk_wrapping";
        ALERT_SDK_WRAPPING_V2 = "alert_sdk_wrapping_v2";
        SIMPLE_TAG = "DTB_Metrics";
        theProcessor = new DTBMetricsProcessor();
    }
}

