/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;
import com.amazon.aps.ads.ApsAdFormatUtils;
import com.amazon.aps.ads.ApsAdRequest;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsPerfAaxBidEvent;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.AdType;
import com.amazon.device.ads.DTBAdCallback;
import com.amazon.device.ads.DTBAdLoader;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBLoadException;
import com.amazon.device.ads.DTBMetricReport;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.DTBMetricsProcessor;
import com.amazon.device.ads.DtbAdRequestParamsBuilder;
import com.amazon.device.ads.DtbCommonUtils;
import com.amazon.device.ads.DtbDebugProperties;
import com.amazon.device.ads.DtbDeviceDataRetriever;
import com.amazon.device.ads.DtbDeviceRegistration;
import com.amazon.device.ads.DtbHttpClient;
import com.amazon.device.ads.DtbLog;
import com.amazon.device.ads.DtbMetric;
import com.amazon.device.ads.DtbMetrics;
import com.amazon.device.ads.DtbPricePoint;
import com.amazon.device.ads.DtbSharedPreferences;
import com.amazon.device.ads.DtbThreadService;
import com.amazon.device.ads.MRAIDPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DTBAdRequest
implements DTBAdLoader {
    private static final String LOG_TAG = DTBAdRequest.class.getSimpleName();
    private final List<DTBAdSize> adSizes = new ArrayList<DTBAdSize>();
    private final Map<String, String> customTargets = new HashMap<String, String>();
    private DTBAdResponse adResponse;
    private final Map<String, String> sizeSlotUUIDMap = new HashMap<String, String>();
    private DTBAdCallback callback;
    private Context context;
    private volatile AdError adError = null;
    private boolean requestHasBeenUsed = false;
    private boolean submitMetrics = true;
    private static final int DEFAULT_RERESH_DURATION = 60;
    private static final int MIN_REFRESH_DURATION = 20;
    private boolean isAutoRefresh = false;
    private boolean refreshFlag = false;
    private int refreshDuration = 0;
    private final Runnable mRefreshRunnable = () -> this.refreshAd();
    private Handler mHandler;
    private HandlerThread mHandlerThread;
    private String slotGroup = null;
    private static boolean mRaidDefined = false;
    static JSONArray mRaidArray = null;
    private static JSONArray mRaidCustomArray = null;
    private static final String[] MRAID_VALID_VERSIONS = new String[]{"1.0", "2.0", "3.0"};
    private static final long WEEK = 604800000L;
    private static final String AAX_VIDEO_SKIP_AFTER = "skipAfter";
    private static final String AAX_VIDEO_INVENTORY_TYPE = "inventoryType";
    private static final String PJ_KEY = "pj";
    private String correlationId = UUID.randomUUID().toString() + UUID.randomUUID().toString();
    private long startLoadAdTime;
    private String aaxHostname;
    private static Integer reqCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseReqCount() {
        Integer n = reqCount;
        synchronized (n) {
            Integer n2 = reqCount;
            Integer n3 = reqCount = Integer.valueOf(reqCount + 1);
        }
    }

    public DTBAdRequest(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("unable to initialize ad request with null app context");
        }
        try {
            if (!AdRegistration.isInitialized()) {
                DtbLog.warn("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
                return;
            }
            if (AdRegistration.getContext() == null) {
                AdRegistration.setContext(context);
            }
            this.context = context;
            if (!mRaidDefined) {
                this.defineMraid();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to initialize DTBAdRequest class with context argument", e);
        }
    }

    public DTBAdRequest() {
        try {
            if (!AdRegistration.isInitialized()) {
                DtbLog.warn("mDTB was not initialized, please use AdRegistration.getInstance(...) before using other SDK calls");
                return;
            }
            if (this.context == null) {
                this.context = AdRegistration.getContext();
            }
            if (!mRaidDefined) {
                this.defineMraid();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to initialize DTBAdRequest class", e);
        }
    }

    public DTBAdRequest(DTBAdRequest dtbAdRequest) {
        this.adSizes.addAll(dtbAdRequest.adSizes);
        this.customTargets.putAll(dtbAdRequest.customTargets);
        this.sizeSlotUUIDMap.putAll(dtbAdRequest.sizeSlotUUIDMap);
        this.adResponse = dtbAdRequest.adResponse;
        this.callback = dtbAdRequest.callback;
        this.context = dtbAdRequest.context;
        this.adError = dtbAdRequest.adError;
        this.requestHasBeenUsed = dtbAdRequest.requestHasBeenUsed;
        this.submitMetrics = dtbAdRequest.submitMetrics;
        this.isAutoRefresh = dtbAdRequest.isAutoRefresh;
        this.refreshFlag = dtbAdRequest.refreshFlag;
        this.refreshDuration = dtbAdRequest.refreshDuration;
        this.mHandler = dtbAdRequest.mHandler;
        this.mHandlerThread = dtbAdRequest.mHandlerThread;
        this.slotGroup = dtbAdRequest.slotGroup;
    }

    public DTBAdRequest(DTBAdRequest dtbAdRequest, String slotUuid) {
        this.setAdSizes(dtbAdRequest.getAdSizes());
        this.setSlotGroup(dtbAdRequest.getSlotGroupName());
        this.setCustomTargets(dtbAdRequest.getCustomTargets());
    }

    static void resetMraid() {
        mRaidArray = null;
        mRaidDefined = false;
    }

    static void setMRAIDSupportedVersions(String[] versions) {
        if (versions != null && versions.length > 0) {
            mRaidCustomArray = new JSONArray();
            List<String> valid = Arrays.asList(MRAID_VALID_VERSIONS);
            for (String version : versions) {
                if (version == null) {
                    DtbLog.error(LOG_TAG, "null custom version supplied");
                    continue;
                }
                if (!valid.contains(version)) {
                    DtbLog.warn(LOG_TAG, "custom version \"" + version + "\" is not valid");
                }
                mRaidCustomArray.put((Object)version);
            }
        }
        DTBAdRequest.resetMraid();
    }

    protected String[] dfpCandidateList() {
        String[] reply = new String[]{"com.google.android.gms.common.GoogleApiAvailability", "com.google.android.gms.common.GoogleApiAvailabilityLight", "com.google.android.gms.common.GooglePlayServicesUtil", "com.google.android.gms.common.GooglePlayServicesUtilLight"};
        return reply;
    }

    protected void defineMraid() {
        Integer googlePlayIntVersion = null;
        DtbCommonUtils.APIVersion googleVersion = new DtbCommonUtils.APIVersion();
        for (String candidate : this.dfpCandidateList()) {
            if (googlePlayIntVersion != null) break;
            googlePlayIntVersion = DtbCommonUtils.getIntegerFieldValue(candidate, "GOOGLE_PLAY_SERVICES_VERSION_CODE");
        }
        if (googlePlayIntVersion == null) {
            for (char symbol = 'a'; symbol <= 'z' && (googlePlayIntVersion = DtbCommonUtils.getIntegerFieldValue("com.google.android.gms.common.zz" + symbol, "GOOGLE_PLAY_SERVICES_VERSION_CODE")) == null; symbol = (char)(symbol + '\u0001')) {
            }
        }
        if (googlePlayIntVersion != null) {
            int temp = googlePlayIntVersion / 1000;
            googleVersion.minorVersion = temp % 1000 / 100;
            googleVersion.majorVersion = temp / 1000;
            DtbLog.debug("Google DFP major version:" + googleVersion.majorVersion + "minor version:" + googleVersion.minorVersion);
        } else {
            DtbLog.debug("Not able to identify Google DFP version");
        }
        mRaidDefined = true;
        MRAIDPolicy policy = AdRegistration.getMRAIDPolicy();
        switch (policy) {
            case AUTO_DETECT: {
                if (this.isServerless() || googlePlayIntVersion == null) break;
                this.useDFP(googleVersion);
                break;
            }
            case DFP: {
                if (googlePlayIntVersion == null) break;
                this.useDFP(googleVersion);
                break;
            }
            case CUSTOM: {
                mRaidArray = mRaidCustomArray;
                break;
            }
        }
    }

    protected boolean isServerless() {
        String[] classes;
        for (String tmp : classes = AdRegistration.getServerlessMarkers()) {
            try {
                Class<?> clz = Class.forName(tmp);
                mRaidArray = new JSONArray();
                mRaidArray.put((Object)"1.0");
                mRaidArray.put((Object)"2.0");
                mRaidArray.put((Object)"3.0");
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private void useDFP(DtbCommonUtils.APIVersion gVersion) {
        if (gVersion.majorVersion > 0) {
            mRaidArray = new JSONArray();
            mRaidArray.put((Object)"1.0");
            if (gVersion.majorVersion == 7 && gVersion.minorVersion >= 8 || gVersion.majorVersion > 7) {
                mRaidArray.put((Object)"2.0");
            }
            if (gVersion.majorVersion >= 15) {
                mRaidArray.put((Object)"3.0");
            }
        }
    }

    @Override
    public void setSizes(DTBAdSize ... sizes) throws IllegalArgumentException {
        this.adSizes.clear();
        DtbLog.info(LOG_TAG, "Setting " + sizes.length + " AdSize(s) to the ad request.");
        for (DTBAdSize adSize : sizes) {
            if (adSize == null) {
                throw new IllegalArgumentException("DTBAdSize cannot be null.");
            }
            this.adSizes.add(adSize);
        }
    }

    @Override
    public void putCustomTarget(@NonNull String key, @NonNull String value) {
        try {
            this.customTargets.put(key, value);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute putCustomTarget method", e);
        }
    }

    @Override
    public void setSlotGroup(String name) {
        this.slotGroup = name;
    }

    @Override
    public String getSlotGroupName() {
        return this.slotGroup;
    }

    void setAdSizes(List<DTBAdSize> sizes) {
        this.adSizes.clear();
        for (DTBAdSize adSize : sizes) {
            if (adSize == null) continue;
            this.adSizes.add(adSize);
        }
    }

    public List<DTBAdSize> getAdSizes() {
        return this.adSizes;
    }

    Map<String, String> getCustomTargets() {
        return this.customTargets;
    }

    void setCustomTargets(Map<String, String> map) {
        this.customTargets.clear();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.customTargets.put(entry.getKey(), entry.getValue());
        }
    }

    public void setRefreshFlag(boolean refreshFlag) {
        this.refreshFlag = refreshFlag;
    }

    void recycle() {
        this.requestHasBeenUsed = false;
    }

    private void loadAd(DTBAdCallback callback, String slotUUID) throws DTBLoadException {
        DTBAdSize size;
        AdRegistration.SlotGroup group = AdRegistration.getSlotGroup(this.slotGroup);
        if (group != null) {
            size = group.getSizeBySlotUUID(slotUUID);
            if (size == null) {
                throw new DTBLoadException("Slot group does not contain requested slotUUID");
            }
        } else {
            throw new DTBLoadException("Slot group is not found");
        }
        DTBAdSize[] sizes = new DTBAdSize[]{size};
        this.setSizes(sizes);
        this.loadAd(callback);
    }

    private void loadAd(DTBAdCallback callback, int width, int height) throws DTBLoadException {
        this.loadAd(callback, width, height, AdType.DISPLAY);
    }

    private void loadAd(DTBAdCallback callback, int width, int height, AdType type) throws DTBLoadException {
        DTBAdSize size;
        AdRegistration.SlotGroup group = AdRegistration.getSlotGroup(this.slotGroup);
        if (group != null) {
            size = group.getSizeByWidthHeightType(width, height, type);
            if (size == null) {
                throw new DTBLoadException("Slot group does not contain required size of a given type");
            }
        } else {
            throw new DTBLoadException("Slot group is not found");
        }
        DTBAdSize[] sizes = new DTBAdSize[]{size};
        this.setSizes(sizes);
        this.loadAd(callback);
    }

    @Override
    public void loadSmartBanner(DTBAdCallback callback) throws DTBLoadException {
        try {
            this.startLoadAdTime = System.currentTimeMillis();
            boolean isTablet = DtbDeviceDataRetriever.isTablet();
            int width = 320;
            int height = 50;
            if (isTablet) {
                width = 728;
                height = 90;
            }
            this.loadAd(callback, width, height);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute loadSmartBanner method", e);
        }
    }

    @Override
    public void loadAd(DTBAdCallback callback) {
        try {
            this.startLoadAdTime = System.currentTimeMillis();
            this.callback = callback;
            if (this.adSizes.size() <= 0) {
                throw new IllegalArgumentException("Please set at least one ad size in the request.");
            }
            if (this.requestHasBeenUsed) {
                DtbLog.error(LOG_TAG, "This ad request object is already used for loading an ad. Please create a new instance to load the Ad.");
                return;
            }
            this.requestHasBeenUsed = true;
            DtbDeviceRegistration.verifyRegistration();
            for (DTBAdSize adSize : this.adSizes) {
                this.sizeSlotUUIDMap.put(adSize.getWidth() + "x" + adSize.getHeight(), adSize.getSlotUUID());
            }
            try {
                if (this.mHandlerThread == null && this.isAutoRefresh && this.refreshDuration > 0) {
                    this.mHandlerThread = new HandlerThread("DtbHandlerThread");
                    this.mHandlerThread.start();
                    Looper looper = this.mHandlerThread.getLooper();
                    this.mHandler = new Handler(looper);
                }
                this.internalLoadAd();
                this.increaseReqCount();
                ApsMetrics.customEvent("bidCall", String.valueOf(reqCount), null);
            }
            catch (Exception e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Unknown exception occured in DTB ad call.", e);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute loadAd method", e);
        }
    }

    @Override
    public void setAutoRefresh() {
        try {
            this.isAutoRefresh = true;
            this.setRefreshDuration(60);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute setAutoRefresh method", e);
        }
    }

    @Override
    public void setAutoRefresh(int seconds) {
        try {
            this.isAutoRefresh = true;
            this.setRefreshDuration(seconds);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute setAutoRefresh method with seconds argument", e);
        }
    }

    @Override
    public void pauseAutoRefresh() {
        this.isAutoRefresh = false;
        this.refreshFlag = false;
    }

    @Override
    public void resumeAutoRefresh() {
        try {
            this.setAutoRefresh(this.refreshDuration);
            this.refreshAd();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Fail to execute resumeAutoRefresh method", e);
        }
    }

    public int getRefreshDuration() {
        return this.refreshDuration;
    }

    private void setRefreshDuration(int seconds) {
        if (seconds < 20) {
            DtbLog.warn(LOG_TAG, "Defaulting auto refresh duration to 60 seconds.");
            this.refreshDuration = 60;
        } else {
            this.refreshDuration = seconds;
        }
    }

    @Override
    public void stop() {
        try {
            this.stopAutoRefresh();
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quit();
                DtbLog.debug("Stopping DTB auto refresh");
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to execute stop method", e);
        }
    }

    private void internalLoadAd() {
        DtbLog.debug("Loading DTB ad.");
        DtbThreadService.getInstance().execute(() -> {
            DtbLog.info("Fetching DTB ad.");
            try {
                this.loadAdRequest();
                DtbLog.debug("DTB Ad call is complete");
            }
            catch (Exception e) {
                DtbLog.error(LOG_TAG, "Unknown exception in DTB ad call process.");
            }
        });
        DtbLog.debug("Dispatched the loadAd task on a background thread.");
    }

    private void stopAutoRefresh() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.refreshFlag = false;
    }

    private void refreshAd() {
        if (this.isAutoRefresh && this.refreshDuration > 0) {
            Activity activity = null;
            if (this.context instanceof Activity && ((activity = (Activity)this.context).isFinishing() || DtbCommonUtils.isActivityDestroyed(activity))) {
                DtbLog.info("Stopping DTB auto refresh...");
                this.stop();
                return;
            }
            this.refreshFlag = true;
            if (activity != null && !activity.hasWindowFocus()) {
                DtbLog.debug("Skipping DTB auto refresh...activity not in focus");
                this.scheduleAdRefreshIfEnabled();
            } else {
                this.internalLoadAd();
            }
        }
    }

    private void scheduleAdRefreshIfEnabled() {
        if (this.isAutoRefresh && this.refreshDuration > 0) {
            this.stopAutoRefresh();
            if (this.mHandler != null) {
                this.mHandler.postDelayed(this.mRefreshRunnable, (long)this.refreshDuration * 1000L);
            }
        }
    }

    private void addPrivacyParameters(Map<String, Object> params) {
        if (this.context != null) {
            this.addGDPRParametersFromPreferences(params, PreferenceManager.getDefaultSharedPreferences((Context)this.context));
            HashMap<String, Object> regulatoryParams = DtbCommonUtils.addGPPParametersFromPreferences(PreferenceManager.getDefaultSharedPreferences((Context)this.context));
            if (!DtbCommonUtils.isNullOrEmpty(regulatoryParams)) {
                try {
                    params.put("regs", DtbCommonUtils.getParamsAsJson(regulatoryParams));
                }
                catch (JSONException e) {
                    APSAnalytics.logEvent(APSEventSeverity.ERROR, APSEventType.EXCEPTION, "Fail to get global privacy platform params", (Exception)((Object)e));
                }
            }
        }
    }

    protected void addGDPRParametersFromPreferences(Map<String, Object> params, SharedPreferences preferences) {
        JSONObject gdprDetails;
        block16: {
            String IABGDPRApplies_TCFv1 = preferences.getString("IABConsent_SubjectToGDPR", null);
            Object IABGDPRApplies_TCFv2 = preferences.contains("IABTCF_gdprApplies") ? preferences.getAll().get("IABTCF_gdprApplies") : null;
            String IABConsentString_TCFv1 = preferences.getString("IABConsent_ConsentString", null);
            String IABConsentString_TCFv2 = preferences.getString("IABTCF_TCString", null);
            String nonIABConsentString = AdRegistration.getEncodedNonIABString();
            gdprDetails = null;
            try {
                if (IABConsentString_TCFv2 != null || IABConsentString_TCFv1 != null) {
                    gdprDetails = new JSONObject();
                    if (IABConsentString_TCFv2 != null) {
                        gdprDetails.put("c", (Object)IABConsentString_TCFv2);
                    } else if (IABConsentString_TCFv1 != null) {
                        gdprDetails.put("c", (Object)IABConsentString_TCFv1);
                    }
                } else if (nonIABConsentString != null) {
                    gdprDetails = new JSONObject();
                    gdprDetails.put("c", (Object)nonIABConsentString);
                }
                if (IABGDPRApplies_TCFv1 == null && IABGDPRApplies_TCFv2 == null) break block16;
                if (gdprDetails == null) {
                    gdprDetails = new JSONObject();
                }
                if (IABGDPRApplies_TCFv2 != null) {
                    try {
                        if (IABGDPRApplies_TCFv2 instanceof Integer && ((Integer)IABGDPRApplies_TCFv2 == 1 || (Integer)IABGDPRApplies_TCFv2 == 0)) {
                            gdprDetails.put("e", IABGDPRApplies_TCFv2);
                            break block16;
                        }
                        if (IABGDPRApplies_TCFv2 instanceof String && ((String)IABGDPRApplies_TCFv2).equals("1") || ((String)IABGDPRApplies_TCFv2).equals("0")) {
                            gdprDetails.put("e", IABGDPRApplies_TCFv2);
                            break block16;
                        }
                        DtbLog.info("IABTCF_gdprApplies should be a 1 or 0 as per IAB guideline");
                    }
                    catch (ClassCastException ex) {
                        DtbLog.info("IABTCF_gdprApplies should be a number as per IAB guideline");
                    }
                    break block16;
                }
                if (IABGDPRApplies_TCFv1 != null) {
                    gdprDetails.put("e", (Object)IABGDPRApplies_TCFv1);
                }
            }
            catch (JSONException ex) {
                DtbLog.error("INVALID JSON formed for GDPR clause");
                return;
            }
        }
        if (gdprDetails != null && gdprDetails.length() != 0) {
            params.put("gdpr", gdprDetails);
        }
    }

    protected void addLegoFlag(Map<String, Object> params, boolean isFeatureEnabled) {
        if (!(this instanceof ApsAdRequest) || !isFeatureEnabled) {
            return;
        }
        try {
            JSONObject pj = params.containsKey(PJ_KEY) ? (JSONObject)params.get(PJ_KEY) : new JSONObject();
            pj.put("api", (Object)"aps");
            params.put(PJ_KEY, pj);
        }
        catch (RuntimeException | JSONException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error setting the isLego flag in ad request", (Exception)e);
        }
    }

    private String getAdSize(JSONObject aaxResponse, List<DTBAdSize> adSizes) {
        try {
            Iterator<DTBAdSize> iterator;
            if (aaxResponse.has("sz") && !DtbCommonUtils.isNullOrEmpty(aaxResponse.getString("sz"))) {
                return aaxResponse.getString("sz");
            }
            StringBuilder errorInfo = new StringBuilder("Invalid sz params from AAX Bid Response.");
            errorInfo.append(String.format("BidId = %s", this.adResponse.getBidId()));
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, errorInfo.toString());
            if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("enable_default_ad_size_to_bid_request") && (iterator = adSizes.iterator()).hasNext()) {
                DTBAdSize adSize = iterator.next();
                if (adSize.isInterstitialAd()) {
                    return "9999x9999";
                }
                return adSize.getWidth() + "x" + adSize.getHeight();
            }
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Failed to get ad size passed from bid Request", e);
        }
        return "0x0";
    }

    private void loadAdRequest() {
        DtbMetrics metrics;
        block28: {
            String errorMessage;
            if (this.isAutoRefresh) {
                for (DTBAdSize size : this.adSizes) {
                    if (size.getDTBAdType() != AdType.INTERSTITIAL && size.getDTBAdType() != AdType.VIDEO) continue;
                    this.isAutoRefresh = false;
                    this.refreshFlag = false;
                    DtbLog.warn("Autorefresh could not be used for interstitial or video");
                    break;
                }
            }
            metrics = new DtbMetrics();
            DtbAdRequestParamsBuilder paramsBuilder = new DtbAdRequestParamsBuilder();
            HashMap<String, Object> params = paramsBuilder.getParams(this.context, this.adSizes, this.customTargets, this.refreshFlag);
            this.addPrivacyParameters(params);
            this.addMraidParameters(params);
            this.addLegoFlag(params, DTBMetricsConfiguration.getInstance().isFeatureEnabled("enable_aps_bid_flag"));
            this.aaxHostname = DtbDebugProperties.getAaxHostName(DtbSharedPreferences.getInstance().getAaxHostname());
            String aaxVideoHostname = null;
            for (DTBAdSize dtbAdSize : this.adSizes) {
                if (!AdType.VIDEO.equals((Object)dtbAdSize.getDTBAdType()) || DtbCommonUtils.isNullOrEmpty(aaxVideoHostname = DtbSharedPreferences.getInstance().getAaxVideoHostName())) continue;
                this.aaxHostname = DtbDebugProperties.getAaxVideoHostName(aaxVideoHostname);
            }
            try {
                StringBuilder urlBuilder = new StringBuilder(this.aaxHostname + "/e/msdk/ads");
                if (DtbDebugProperties.getEncodedUrlParams().length() > 0) {
                    urlBuilder.append('?').append(DtbDebugProperties.getEncodedUrlParams());
                }
                DtbHttpClient client = new DtbHttpClient(urlBuilder.toString());
                client.setUseSecure(DtbDebugProperties.getIsSecure(true));
                client.addHeader("Accept", "application/json");
                client.addHeader("Content-Type", "application/json");
                client.setParams(params);
                this.onRequestFormed(params);
                metrics.startTimer(DtbMetric.AAX_BID_TIME);
                client.executePOST(DtbSharedPreferences.getInstance().getBidTimeout());
                DtbLog.debug("Ad call completed.");
                if (DtbCommonUtils.isNullOrEmpty(client.getResponse())) {
                    DtbLog.debug("No response from Ad call.");
                    this.adError = this.createAdError(AdError.ErrorCode.INTERNAL_ERROR, "Response is null.");
                    throw new Exception("Response is null");
                }
                metrics.stopTimer(DtbMetric.AAX_BID_TIME);
                JSONObject jsonPayload = (JSONObject)new JSONTokener(client.getResponse()).nextValue();
                if (jsonPayload != null) {
                    DtbLog.debug("Bid Response:" + jsonPayload);
                }
                if (jsonPayload != null && client.getResponseCode() == 200) {
                    if (jsonPayload.has("instrPixelURL")) {
                        String temp = jsonPayload.getString("instrPixelURL");
                        metrics.setInstPxlUrl(temp);
                    }
                    if (jsonPayload.has("errorCode") && jsonPayload.getString("errorCode").equals("200") && jsonPayload.has("ads")) {
                        JSONObject ads = jsonPayload.getJSONObject("ads");
                        this.adResponse = new DTBAdResponse();
                        this.adResponse.setAdLoader(DtbCommonUtils.createAutoRefreshAdLoader(this));
                        this.adResponse.setHostName(this.aaxHostname);
                        if (ads.length() > 0) {
                            Iterator keys = ads.keys();
                            while (keys.hasNext()) {
                                String pp = (String)keys.next();
                                JSONObject priceObject = ads.getJSONObject(pp);
                                this.adResponse.setBidId(priceObject.getString("b"));
                                if (priceObject.has("v") && priceObject.getBoolean("v")) {
                                    Object skipAfterDuration;
                                    this.adResponse.setVideo(true);
                                    if (priceObject.has(AAX_VIDEO_SKIP_AFTER) && (skipAfterDuration = priceObject.opt(AAX_VIDEO_SKIP_AFTER)) instanceof Integer) {
                                        this.adResponse.setVideoSkipAfterDurationInSeconds((Integer)skipAfterDuration);
                                    }
                                    if (priceObject.has(AAX_VIDEO_INVENTORY_TYPE)) {
                                        this.adResponse.setVideoInventoryType(priceObject.getString(AAX_VIDEO_INVENTORY_TYPE));
                                    }
                                }
                                if (priceObject.has("kvp")) {
                                    try {
                                        this.adResponse.setKvpDictionary(priceObject.getJSONObject("kvp"));
                                    }
                                    catch (JSONException e) {
                                        DtbLog.debug("Malformed kvp value from ad response: " + e.getMessage());
                                    }
                                }
                                String size = this.getAdSize(priceObject, this.adSizes);
                                if (priceObject.has("i")) {
                                    this.adResponse.setImpressionUrl(priceObject.getString("i"));
                                }
                                if (priceObject.has("crid")) {
                                    this.adResponse.setCrid(priceObject.getString("crid"));
                                }
                                AdType type = AdType.DISPLAY;
                                if ("9999x9999".equals(size)) {
                                    type = AdType.INTERSTITIAL;
                                } else if (this.adResponse.isVideo()) {
                                    type = AdType.VIDEO;
                                }
                                DtbPricePoint pricePoint = new DtbPricePoint(pp, size, this.sizeSlotUUIDMap.get(size), type);
                                this.adResponse.putPricePoint(pricePoint);
                            }
                            this.adError = this.createAdError(AdError.ErrorCode.NO_ERROR, "Ad loaded successfully.");
                            DtbLog.debug("Ad call response successfully processed.");
                            break block28;
                        }
                        DtbLog.debug("No pricepoint returned from ad server");
                        metrics.incrementMetric(DtbMetric.AAX_PUNTED);
                        this.adError = this.createAdError(AdError.ErrorCode.NO_FILL, "No pricepoint returned from ad server.");
                        break block28;
                    }
                    if (jsonPayload.has("errorCode") && jsonPayload.getString("errorCode").equals("400")) {
                        DtbLog.debug("Ad Server punted due to invalid request.");
                        this.adError = this.createAdError(AdError.ErrorCode.REQUEST_ERROR, "Invalid request passed to AdServer.");
                    } else {
                        DtbLog.debug("No ad returned from ad server");
                        this.adError = this.createAdError(AdError.ErrorCode.NO_FILL, "No Ad returned by AdServer.");
                    }
                    metrics.incrementMetric(DtbMetric.AAX_PUNTED);
                    break block28;
                }
                DtbLog.debug("Ad call did not complete successfully.");
                this.adError = this.createAdError(AdError.ErrorCode.NETWORK_ERROR, "Ad call did not complete successfully.");
                metrics.incrementMetric(DtbMetric.AAX_NETWORK_FAILURE);
            }
            catch (JSONException e) {
                errorMessage = "Malformed response from ad call. ";
                DtbLog.debug(errorMessage + e.getMessage());
                this.adError = this.createAdError(AdError.ErrorCode.INTERNAL_ERROR, errorMessage);
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, errorMessage, (Exception)((Object)e));
            }
            catch (Exception e) {
                errorMessage = "Internal error occurred in ad call. ";
                DtbLog.debug(errorMessage + e.getMessage());
                this.adError = this.createAdError(AdError.ErrorCode.INTERNAL_ERROR, errorMessage);
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, errorMessage, e);
            }
        }
        if (this.adError == null) {
            DtbLog.debug("UNEXPECTED ERROR in ad call !!");
        }
        this.triggerCallBack(metrics);
    }

    private AdError createAdError(AdError.ErrorCode code, String msg) {
        AdError adError = new AdError(code, msg);
        DTBAdRequest adLoader = DtbCommonUtils.createAutoRefreshAdLoader(this);
        adError.setAdLoader(adLoader);
        return adError;
    }

    private void triggerCallBack(DtbMetrics metrics) {
        this.scheduleAdRefreshIfEnabled();
        DtbLog.info(LOG_TAG, "Forwarding the error handling to view on main thread.");
        DtbThreadService.executeOnMainThread(() -> this.executeCallback(metrics));
        if (this.submitMetrics) {
            DtbMetrics.Submitter.INSTANCE.submitMetrics(metrics);
        }
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    private String getMediationName() {
        if (AdRegistration.getCustomDictionary().containsKey("mediationName")) {
            return AdRegistration.getCustomDictionary().get("mediationName");
        }
        return null;
    }

    private void sendBidEvent(long endTimestamp) {
        try {
            ApsMetricsPerfAaxBidEvent bidEvent;
            ApsMetricsPerfEventModelBuilder builder = new ApsMetricsPerfEventModelBuilder();
            builder.withCorrelationId(this.getCorrelationId());
            String bidId = null;
            builder.withMediationName(this.getMediationName());
            if (this.adError != null && this.adError.getCode() == AdError.ErrorCode.NO_ERROR) {
                DTBAdSize adSize = this.adResponse.getDTBAds().get(0);
                bidEvent = new ApsMetricsPerfAaxBidEvent(ApsMetricsResult.Success, this.aaxHostname);
                ApsAdFormat adFormat = ApsAdFormatUtils.getAdFormat(adSize.getDTBAdType(), adSize.getHeight(), adSize.getWidth());
                if (adFormat != null) {
                    builder.withAdFormat(adFormat.toString());
                }
                bidId = this.adResponse.getBidId();
                builder.withVideoFlag(this.adResponse.isVideo());
            } else {
                bidEvent = new ApsMetricsPerfAaxBidEvent(ApsMetricsResult.Failure, this.aaxHostname);
            }
            bidEvent.setRefreshFlag(this.isAutoRefresh);
            bidEvent.setStartTime(this.startLoadAdTime);
            bidEvent.setEndTime(endTimestamp);
            builder.withEvent(bidEvent);
            ApsMetrics.adEvent(bidId, builder);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in sending the bid event in ad request", e);
        }
    }

    private void executeCallback(DtbMetrics metrics) {
        long endTimestamp = System.currentTimeMillis();
        if (this.callback != null) {
            if (this.adError != null && this.adError.getCode() == AdError.ErrorCode.NO_ERROR) {
                WrapperReport report;
                DtbLog.debug("Invoking onSuccess() callback for pricepoints: [" + this.adResponse.getDefaultPricePoints() + "]");
                this.callback.onSuccess(this.adResponse);
                DtbLog.debug("Performing SDK wrapping detection. Will submit a report if needed.");
                if (this.wrapperDetectionNeeded() && (report = this.detectWrapper(this.callback)) != null) {
                    double percentage = (float)DTBMetricsConfiguration.getClientConfigVal("wrapping_pixel", DTBMetricsConfiguration.WRAPPING_PIXEL_DEFAULT_VALUE, "sample_rates").intValue() / 100.0f;
                    if (Math.random() <= percentage) {
                        HashMap<String, Object> extra = new HashMap<String, Object>();
                        extra.put("expected_package", report.expectedPackage);
                        extra.put("wrapper_package", report.wrapperPackage);
                        String hostname = DtbCommonUtils.getHostNameFromUrl(metrics.getInstPxlUrl());
                        DTBMetricsProcessor.getInstance().submitErrorReport("alert_sdk_wrapping_v2", extra, DTBMetricReport.addBid(null, hostname));
                    }
                }
            } else {
                DtbLog.debug("Invoking onFailure() callback with errorCode: " + (Object)((Object)this.adError.getCode()) + "[" + this.adError.getMessage() + "]");
                this.callback.onFailure(this.adError);
            }
        } else {
            DtbLog.error("No callback -DTBAdCallback- provided to loadAd() to handle success or failure.");
        }
        this.sendBidEvent(endTimestamp);
    }

    private void addMraidParameters(Map<String, Object> params) {
        if (mRaidArray != null && mRaidArray.length() > 0) {
            params.put("mraid", mRaidArray);
        }
    }

    private WrapperReport detectWrapper(Object obj) {
        String objPackage;
        WrapperReport report = null;
        Context context = AdRegistration.getContext().getApplicationContext();
        try {
            objPackage = obj.getClass().getPackage().getName();
        }
        catch (Exception e) {
            return null;
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        String appPackage = applicationInfo.packageName;
        StringTokenizer objTokenizer = new StringTokenizer(objPackage, ".");
        StringTokenizer appTokenizer = new StringTokenizer(appPackage, ".");
        if (objTokenizer.countTokens() >= 2 && appTokenizer.countTokens() >= 2) {
            for (int k = 0; k < 2; ++k) {
                String appToken;
                String objToken = objTokenizer.nextToken();
                if (objToken.equals(appToken = appTokenizer.nextToken())) continue;
                report = new WrapperReport();
                report.expectedPackage = objPackage;
                report.wrapperPackage = appPackage;
                break;
            }
        } else {
            report = new WrapperReport();
            report.expectedPackage = appPackage;
            report.wrapperPackage = objPackage;
        }
        return report;
    }

    private boolean wrapperDetectionNeeded() {
        DtbSharedPreferences dsp = DtbSharedPreferences.getInstance();
        Long last = dsp.getWrapperDetectionLastPing();
        boolean reply = false;
        long now = new Date().getTime();
        if (last != null) {
            if (now - last > 604800000L) {
                reply = true;
            }
        } else {
            reply = true;
        }
        if (reply) {
            dsp.saveWrapperDetectionLastPing(now);
        }
        return reply;
    }

    protected void onRequestFormed(HashMap<String, Object> params) {
    }

    class WrapperReport {
        String wrapperPackage;
        String expectedPackage;

        WrapperReport() {
        }
    }
}

