/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.shared;

import android.content.Context;
import android.util.Log;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.ApsMetrics;
import com.amazon.aps.shared.analytics.APSEvent;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.util.APSNetworkManager;
import com.amazon.aps.shared.util.APSSharedUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class APSAnalytics {
    public static final String DEFAULT_SDK_VERSION = "1.0";
    public static final String OS_NAME = "Android";
    public static final String TAG = "APSAnalytics";
    private static String VERSION = "1.0";
    private static final String DEFAULT_API_KEY = "e9026ffd475a1a3691e6b2ce637a9b92aab1073ebf53a67c5f2583be8a804ecb";
    private static final String HTTP_URL = "https://prod.cm.publishers.advertising.a2z.com/logrecord/putlog";
    public static final String GAMMA_HTTP_URL = "https://gamma.cm.publishers.advertising.a2z.com/logrecord/putlog";
    public static final String BETA_HTTP_URL = "https://api.beta.sdklogger.publishers.advertising.a2z.com/logrecord/putlog";
    private static final int SAMPLING_LOWER_LIMIT = 0;
    private static final int SAMPLING_UPPER_LIMIT = 100;
    private static final int DEFAULT_SAMPLING_RATE = 1;
    private static final int ADDITIONAL_DETAILS_MAP_LIMIT = 20;
    private static final int ADDITIONAL_VALUE_SIZE_LIMIT = 100;
    private static Context context;
    private static String adapterVersion;
    private static boolean isSamplingAllowed;
    private static String apiKey;
    private static String url;
    private static Map<String, String> additionalDetailsMap;
    private static String additionalDetails;

    public static void init(Context context) {
        APSAnalytics.init(context, 1, DEFAULT_API_KEY);
    }

    public static void init(Context context, int samplingRate, String apiKey) {
        APSAnalytics.context = context;
        APSAnalytics.setApiKey(apiKey);
        APSAnalytics.setSamplingRate(samplingRate);
        APSAnalytics.setHttpUrl(HTTP_URL);
        additionalDetails = "";
        adapterVersion = null;
        additionalDetailsMap = new HashMap<String, String>();
    }

    public static void setApiKey(String apiKey) {
        APSAnalytics.apiKey = APSAnalytics.getDefaultIfEmptyString(apiKey, DEFAULT_API_KEY);
    }

    public static void setHttpUrl(String httpUrl) {
        url = APSAnalytics.getDefaultIfEmptyString(httpUrl, HTTP_URL);
    }

    public static String getHttpUrl() {
        return url;
    }

    public static String getApiKey() {
        return apiKey;
    }

    public static void setSamplingRate(int samplingRate) {
        if (0 > samplingRate || samplingRate > 100) {
            Log.e((String)TAG, (String)"Invalid sampling rate - setting the default one");
            samplingRate = 1;
        }
        try {
            Random random = new Random();
            int rate = random.nextInt(100) + 1;
            isSamplingAllowed = rate <= samplingRate;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Unable to set the sampling rate", (Throwable)e);
        }
    }

    public static void logEvent(APSEventSeverity severity, APSEventType eventType, String errorDetails, Exception e) {
        try {
            ApsLog.e(TAG, errorDetails + e);
            if (APSAnalytics.isInitialized()) {
                APSEvent apsEvent = new APSEvent(context, severity, eventType.name()).setExceptionDetails(e).setErrorDetails(errorDetails).build();
                APSAnalytics.processEvent(apsEvent);
                ApsMetrics.crashEvent(severity.name(), errorDetails != null ? errorDetails : e.getMessage(), null);
            } else {
                Log.d((String)TAG, (String)"Analytics not initialized, and ignoring the event");
            }
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)"Error in processing the event: ", (Throwable)ex);
        }
    }

    public static void logEvent(APSEventSeverity severity, APSEventType eventType, Exception e) {
        APSAnalytics.logEvent(severity, eventType, null, e);
    }

    public static void logEvent(APSEventSeverity severity, APSEventType eventType, String errorDetails) {
        APSAnalytics.logEvent(severity, eventType, errorDetails, null);
    }

    private static void processEvent(APSEvent event) {
        if (event.getEventSeverity() == APSEventSeverity.FATAL) {
            APSAnalytics.processCriticalEvent(event);
        }
    }

    public static boolean isIsSamplingAllowed() {
        return isSamplingAllowed;
    }

    public static boolean isInitialized() {
        return context != null && isSamplingAllowed;
    }

    private static void processCriticalEvent(APSEvent event) {
        APSNetworkManager.getInstance(context).sendRemoteLog(event);
    }

    public static String getDefaultIfEmptyString(String str, String defaultStr) {
        return str == null || str.trim().isEmpty() ? defaultStr : str;
    }

    public static void addAdditionalDetails(String key, String value) {
        try {
            if (additionalDetailsMap == null) {
                additionalDetailsMap = new HashMap<String, String>();
            }
            if (additionalDetailsMap.size() >= 20) {
                Log.e((String)TAG, (String)"Ignoring adding the details as the dictionary size limit exceeded");
            } else if (!APSSharedUtil.isNullOrEmpty(key) && key.length() <= 100 && !APSSharedUtil.isNullOrEmpty(value) && value.length() <= 100) {
                additionalDetailsMap.put(key, value);
            }
            APSAnalytics.storeAdditionalDetailsString();
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)"Error in executing addAdditionalDetails method: ", (Throwable)ex);
        }
    }

    public static void removeAdditionalDetails(String key) {
        try {
            additionalDetailsMap.remove(key);
            APSAnalytics.storeAdditionalDetailsString();
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)"Error in executing removeAdditionalDetails method: ", (Throwable)ex);
        }
    }

    public static String getAdditionalDetails() {
        return additionalDetails;
    }

    private static void storeAdditionalDetailsString() {
        int count = additionalDetailsMap.size();
        additionalDetails = "";
        if (count > 0) {
            for (Map.Entry<String, String> entry : additionalDetailsMap.entrySet()) {
                additionalDetails = additionalDetails.concat(String.format("%s = %s;", entry.getKey(), entry.getValue()));
            }
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getAdapterVersion() {
        return adapterVersion;
    }

    public static void setAdapterVersion(String adapterVersion) {
        if (!APSSharedUtil.isNullOrEmpty(adapterVersion)) {
            APSAnalytics.adapterVersion = adapterVersion;
        }
    }

    public static void setVersion(String sdkVersion) {
        if (sdkVersion != null && !sdkVersion.trim().isEmpty()) {
            VERSION = sdkVersion.trim();
        }
    }

    static {
        isSamplingAllowed = false;
    }
}

