/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aps.ads;

import com.amazon.aps.ads.ApsAdRequest;
import com.amazon.aps.ads.model.ApsAdFormat;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdSize;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBMetricsConfiguration;
import com.amazon.device.ads.SDKUtilities;
import java.lang.ref.WeakReference;

public class ApsAd
extends DTBAdResponse {
    private static final String REWARDED_INVENTORY_TYPE = "MOBILE_APP_REWARDED";
    private static final String INTERSTITIAL_VIDEO_INVENTORY_TYPE = "MOBILE_INTERSTITIAL";
    private static final String INSTREAM_VIDEO_INVENTORY_TYPE = "MOBILE_VIDEO";
    private ApsAdRequest apsAdRequest;
    private WeakReference<DTBAdView> dtbAdViewWeakReference;
    private ApsAdFormat apsAdFormatFromRequest;
    private String slotUuid;

    public ApsAd(DTBAdResponse dtbAdResponse, ApsAdFormat apsAdFormat) {
        super(dtbAdResponse);
        this.apsAdFormatFromRequest = apsAdFormat;
        this.setSlotUuid(dtbAdResponse);
    }

    public ApsAdRequest getApsAdRequest() {
        if (this.apsAdRequest == null && this.refreshLoader != null) {
            this.setApsAdRequest(new ApsAdRequest(this.refreshLoader, this.getSlotUuid(), this.apsAdFormatFromRequest));
        }
        return this.apsAdRequest;
    }

    public String getBidInfo() {
        return SDKUtilities.getBidInfo(this);
    }

    public String getPricePoint() {
        String pricePoint = null;
        try {
            pricePoint = SDKUtilities.getPricePoint(this);
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error getting the price point from ApsAd", e);
        }
        return pricePoint;
    }

    public String getSlotUuid() {
        return this.slotUuid;
    }

    public ApsAdFormat getApsAdFormat() {
        if (DTBMetricsConfiguration.getInstance().isFeatureEnabled("ad_format_from_bid_response")) {
            int height = -1;
            int width = -1;
            try {
                if (this.isVideo()) {
                    if (REWARDED_INVENTORY_TYPE.equalsIgnoreCase(this.videoInventoryType)) {
                        return ApsAdFormat.REWARDED_VIDEO;
                    }
                    if (INSTREAM_VIDEO_INVENTORY_TYPE.equalsIgnoreCase(this.videoInventoryType)) {
                        return ApsAdFormat.INSTREAM_VIDEO;
                    }
                    return ApsAdFormat.INTERSTITIAL;
                }
                width = this.getWidthFromAax();
                height = this.getHeightFromAax();
                if (height == 50 && width == 320) {
                    return ApsAdFormat.BANNER;
                }
                if (height == 250 && width == 300) {
                    return ApsAdFormat.MREC;
                }
                if (height == 90 && width == 728) {
                    return ApsAdFormat.LEADERBOARD;
                }
                if (height == 9999 && width == 9999) {
                    return ApsAdFormat.INTERSTITIAL;
                }
            }
            catch (RuntimeException e) {
                APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in parsing the ad format in ApsAd - getApsAdFormat", e);
            }
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.LOG, "Invalid ad format received from the AAX in ApsAd - getApsAdFormat:" + width + ":" + height);
        }
        return this.apsAdFormatFromRequest;
    }

    void setSlotUuid(DTBAdResponse adResponse) {
        try {
            DTBAdSize dtbAdSize = adResponse.getDTBAds().get(0);
            this.slotUuid = dtbAdSize.getSlotUUID();
        }
        catch (Exception e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error in setting up slot id in ApsAd", e);
        }
    }

    int getHeightFromAax() {
        try {
            return this.getDTBAds().get(0).getHeight();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error getting the height from ApsAd", e);
            return -1;
        }
    }

    int getWidthFromAax() {
        int width;
        try {
            width = this.getDTBAds().get(0).getWidth();
        }
        catch (RuntimeException e) {
            width = -1;
            APSAnalytics.logEvent(APSEventSeverity.FATAL, APSEventType.EXCEPTION, "Error getting the width from ApsAd", e);
        }
        return width;
    }

    void setApsAdRequest(ApsAdRequest apsAdRequest) {
        this.apsAdRequest = apsAdRequest;
    }

    @Override
    public ApsAdRequest getAdLoader() {
        return this.getApsAdRequest();
    }

    void setAdView(DTBAdView dtbAdView) {
        this.dtbAdViewWeakReference = new WeakReference<DTBAdView>(dtbAdView);
    }

    public void setSlotUuid(String slotUuid) {
        this.slotUuid = slotUuid;
    }

    public DTBAdView getAdView() {
        if (this.dtbAdViewWeakReference == null) {
            return null;
        }
        return (DTBAdView)this.dtbAdViewWeakReference.get();
    }
}

