/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.admob_adapter;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.amazon.admob_adapter.APSAdMobAdapterUtil;
import com.amazon.admob_adapter.APSAdMobUtil;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdInterstitial;
import com.amazon.device.ads.DTBAdInterstitialListener;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBCacheData;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitial;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import java.util.UUID;

public class APSAdMobCustomInterstitialEvent
implements CustomEventInterstitial,
DTBAdInterstitialListener {
    private static final String LOGTAG = APSAdMobCustomInterstitialEvent.class.getSimpleName();
    private final ApsMetricsPerfEventModelBuilder metricsBuilder = new ApsMetricsPerfEventModelBuilder();
    private String correlationId = null;
    private CustomEventInterstitialListener customEventListener;
    private DTBAdInterstitial interstitial;
    private APSAdMobUtil apsAdMobUtil;
    private static InterstitialAd adMobInterstitial;

    public void requestInterstitialAd(Context context, CustomEventInterstitialListener listener, String serverParameter, MediationAdRequest mediationAdRequest, Bundle customEventExtras) {
        try {
            this.apsAdMobUtil = new APSAdMobUtil();
            this.correlationId = UUID.randomUUID().toString();
            this.metricsBuilder.withAdapterStartTime(System.currentTimeMillis());
            APSAdMobAdapterUtil.setupMetricsAndRemoteLogs();
            if (customEventExtras != null && customEventExtras.containsKey("amazon_custom_event_adapter_version") && customEventExtras.getString("amazon_custom_event_adapter_version", "1.0").equals("2.0")) {
                String requestId = customEventExtras.getString("amazon_custom_event_request_id");
                DTBCacheData dtbCacheData = AdRegistration.getAdMobCache((String)requestId);
                this.customEventListener = listener;
                if (dtbCacheData != null) {
                    if (dtbCacheData.isBidRequestFailed()) {
                        APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
                        ApsLog.e((String)LOGTAG, (String)"Fail to load custom interstitial ad in requestInterstitialAd in APSAdMobCustomInterstitialSingleEvent class because previous bid requests failure");
                        listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in requestInterstitialAd in APSAdMobCustomInterstitialSingleEvent class because previous bid requests failure", "com.amazon.device.ads"));
                        return;
                    }
                    DTBAdResponse currentAdResponse = dtbCacheData.getAdResponse();
                    if (currentAdResponse != null) {
                        Bundle renderingBundle = currentAdResponse.getRenderingBundle();
                        this.apsAdMobUtil.renderAPSInterstitialAds(context, listener, serverParameter, renderingBundle, requestId, this, this.metricsBuilder, this.correlationId);
                        return;
                    }
                }
                this.apsAdMobUtil.loadInterstitialAd(context, listener, customEventExtras, serverParameter, this, this.metricsBuilder, this.correlationId);
            } else if (DTBAdUtil.validateAdMobCustomEvent((String)serverParameter, (Bundle)customEventExtras)) {
                this.customEventListener = listener;
                this.interstitial = new DTBAdInterstitial(context, (DTBAdInterstitialListener)this);
                this.interstitial.fetchAd(customEventExtras);
            } else {
                APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
                listener.onAdFailedToLoad(new AdError(3, "Fail to load custom interstitial ad in requestInterstitialAd method", "com.amazon.device.ads"));
            }
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Success, this.metricsBuilder, this.correlationId);
        }
        catch (RuntimeException e) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute requestInterstitialAd method during runtime", (Exception)e);
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom interstitial ad in requestInterstitialAd method", "com.amazon.device.ads"));
        }
    }

    private DTBAdInterstitial getInterstitial() {
        if (this.interstitial == null) {
            return this.apsAdMobUtil.getInterstitial();
        }
        return this.interstitial;
    }

    public void showInterstitial() {
        try {
            if (this.getInterstitial() != null) {
                this.getInterstitial().show();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute showInterstitial method during runtime in APSAdMobCustomInterstitialEvent class", (Exception)e);
        }
    }

    public void onAdClosed(View view) {
        try {
            FullScreenContentCallback fullScreenContentCallback;
            if (this.customEventListener != null) {
                this.customEventListener.onAdClosed();
                return;
            }
            if (adMobInterstitial != null && (fullScreenContentCallback = adMobInterstitial.getFullScreenContentCallback()) != null) {
                fullScreenContentCallback.onAdDismissedFullScreenContent();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdClosed method during runtime in APSAdMobCustomInterstitialEvent class", (Exception)e);
        }
    }

    public void onAdOpen(View view) {
        try {
            FullScreenContentCallback fullScreenContentCallback;
            if (this.customEventListener != null) {
                this.customEventListener.onAdOpened();
                return;
            }
            if (adMobInterstitial != null && (fullScreenContentCallback = adMobInterstitial.getFullScreenContentCallback()) != null) {
                fullScreenContentCallback.onAdShowedFullScreenContent();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdOpen method during runtime in APSAdMobCustomInterstitialEvent class", (Exception)e);
        }
    }

    public void onImpressionFired(View v) {
    }

    public void onAdFailed(View v) {
        try {
            if (this.customEventListener != null) {
                this.customEventListener.onAdFailedToLoad(new AdError(3, "Custom interstitial ad failed to load", "com.amazon.device.ads"));
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdFailed method during runtime in APSAdMobCustomInterstitialEvent class", (Exception)e);
        }
    }

    public void onAdClicked(View view) {
        try {
            if (this.customEventListener != null) {
                this.customEventListener.onAdClicked();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdClicked method during runtime in APSAdMobCustomInterstitialEvent class", (Exception)e);
        }
    }

    public void onAdLoaded(View view) {
        try {
            if (this.customEventListener != null) {
                this.customEventListener.onAdLoaded();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdLoaded method during runtime in APSAdMobCustomInterstitialEvent class", (Exception)e);
        }
    }

    public void onDestroy() {
        try {
            if (this.customEventListener != null) {
                this.customEventListener.onAdClosed();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onDestroy method during runtime in APSAdMobCustomInterstitialEvent class", (Exception)e);
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    @Deprecated
    public static void setAdMobInterstitial(InterstitialAd interstitialAd) {
        adMobInterstitial = interstitialAd;
    }

    @Deprecated
    public void onAdLeftApplication(View view) {
    }
}

