/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.admob_adapter;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.amazon.admob_adapter.APSAdMobAdapterUtil;
import com.amazon.admob_adapter.APSAdMobUtil;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdBannerListener;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBAdView;
import com.amazon.device.ads.DTBCacheData;
import com.amazon.device.ads.DTBExpectedSizeProvider;
import com.amazon.device.ads.DtbCommonUtils;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventBanner;
import com.google.android.gms.ads.mediation.customevent.CustomEventBannerListener;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class APSAdMobCustomBannerEvent
implements CustomEventBanner,
DTBAdBannerListener,
DTBExpectedSizeProvider {
    private static final String LOGTAG = APSAdMobCustomBannerEvent.class.getSimpleName();
    private CustomEventBannerListener customEventListener;
    private AdSize size;
    private int expectedWidth = 0;
    private int expectedHeight = 0;
    static Set<String> autoRefreshRequestIds = new HashSet<String>();
    private String correlationId = null;
    public static final String ADAPTER_VERSION_PREFIX = "admob-";
    private final ApsMetricsPerfEventModelBuilder metricsBuilder = new ApsMetricsPerfEventModelBuilder();

    public void setExpectedHeight(int height) {
        this.expectedHeight = height;
    }

    public void setExpectedWidth(int width) {
        this.expectedWidth = width;
    }

    public int getExpectedHeight() {
        return this.expectedHeight;
    }

    public int getExpectedWidth() {
        return this.expectedWidth;
    }

    public void requestBannerAd(Context context, CustomEventBannerListener listener, String serverParameter, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle customEventExtras) {
        try {
            APSAdMobUtil apsAdMobUtil = new APSAdMobUtil();
            this.metricsBuilder.withAdapterStartTime(System.currentTimeMillis());
            this.correlationId = UUID.randomUUID().toString();
            APSAdMobAdapterUtil.setupMetricsAndRemoteLogs();
            if (customEventExtras != null && customEventExtras.containsKey("amazon_custom_event_adapter_version") && customEventExtras.getString("amazon_custom_event_adapter_version", "1.0").equals("2.0")) {
                String requestId = customEventExtras.getString("amazon_custom_event_request_id");
                DTBCacheData dtbCacheData = AdRegistration.getAdMobCache((String)requestId);
                this.customEventListener = listener;
                this.size = adSize;
                if (dtbCacheData != null) {
                    if (dtbCacheData.isBidRequestFailed()) {
                        APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
                        ApsLog.e((String)LOGTAG, (String)"Fail to load custom banner ad in requestBannerAd because previous bid requests failure");
                        listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in requestBannerAd because previous bid requests failure", "com.amazon.device.ads"));
                        return;
                    }
                    DTBAdResponse currentAdResponse = dtbCacheData.getAdResponse();
                    if (currentAdResponse != null) {
                        String slotGroup = customEventExtras.getString("amazon_custom_event_slot_group");
                        Bundle renderingBundle = currentAdResponse.getRenderingBundle(!DtbCommonUtils.isNullOrEmpty((String)slotGroup));
                        apsAdMobUtil.renderAPSBannerAds(context, listener, adSize, serverParameter, renderingBundle, requestId, this, this.metricsBuilder, this.correlationId);
                        return;
                    }
                }
                apsAdMobUtil.loadBannerAd(context, listener, adSize, customEventExtras, serverParameter, autoRefreshRequestIds, this, this.metricsBuilder, this.correlationId);
            } else {
                if (customEventExtras != null && DTBAdUtil.validateAdMobCustomEvent((String)serverParameter, (Bundle)(customEventExtras = DTBAdUtil.getBidFromFetchManager((Bundle)customEventExtras)))) {
                    this.customEventListener = listener;
                    this.size = adSize;
                    DTBAdView adView = new DTBAdView(context, (DTBAdBannerListener)this);
                    adView.fetchAd(customEventExtras);
                    APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Success, this.metricsBuilder, this.correlationId);
                    return;
                }
                APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
                listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in requestBannerAd", "com.amazon.device.ads"));
            }
        }
        catch (RuntimeException e) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, this.metricsBuilder, this.correlationId);
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute requestBannerAd method during runtime in APSAdMobCustomBannerEvent class", (Exception)e);
            listener.onAdFailedToLoad(new AdError(3, "Fail to load custom banner ad in requestBannerAd", "com.amazon.device.ads"));
        }
    }

    public void onAdLoaded(View adView) {
        try {
            ViewGroup viewToAdd = DTBAdUtil.getAdViewWrapper((View)adView, (int)this.size.getWidth(), (int)this.size.getHeight(), (int)this.expectedWidth, (int)this.expectedHeight);
            if (this.customEventListener != null) {
                this.customEventListener.onAdLoaded((View)viewToAdd);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdLoaded method during runtime", (Exception)e);
        }
    }

    public void onAdClicked(View view) {
        try {
            AdView adView;
            AdListener adListener;
            View v = DTBAdUtil.findAncestorOfType((View)view, AdView.class);
            if (v != null && (adListener = (adView = (AdView)v).getAdListener()) != null) {
                adListener.onAdClicked();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdClicked method during runtime", (Exception)e);
        }
    }

    public void onAdClosed(View view) {
        try {
            AdView adView;
            AdListener adListener;
            View v = DTBAdUtil.findAncestorOfType((View)view, AdView.class);
            if (v != null && (adListener = (adView = (AdView)v).getAdListener()) != null) {
                adListener.onAdClosed();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdClosed method during runtime", (Exception)e);
        }
    }

    public void onAdOpen(View view) {
        try {
            AdView adView;
            AdListener adListener;
            View v = DTBAdUtil.findAncestorOfType((View)view, AdView.class);
            if (v != null && (adListener = (adView = (AdView)v).getAdListener()) != null) {
                adListener.onAdOpened();
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdOpen method during runtime", (Exception)e);
        }
    }

    public void onImpressionFired(View view) {
    }

    public void onAdFailed(View v) {
        try {
            if (this.customEventListener != null) {
                this.customEventListener.onAdFailedToLoad(new AdError(3, "Custom banner ad failed to load", "com.amazon.device.ads"));
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdFailed method during runtime", (Exception)e);
        }
    }

    public void onDestroy() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    @Deprecated
    public void onAdLeftApplication(View view) {
    }
}

