/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.admob_adapter;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.amazon.admob_adapter.APSAdMobUtil;
import com.amazon.admob_adapter.CustomEventListenerAdapter;
import com.amazon.aps.ads.ApsLog;
import com.amazon.aps.shared.APSAnalytics;
import com.amazon.aps.shared.analytics.APSEventSeverity;
import com.amazon.aps.shared.analytics.APSEventType;
import com.amazon.aps.shared.metrics.ApsMetricsPerfEventModelBuilder;
import com.amazon.aps.shared.metrics.model.ApsMetricsResult;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.DTBAdBannerListener;
import com.amazon.device.ads.DTBAdResponse;
import com.amazon.device.ads.DTBAdUtil;
import com.amazon.device.ads.DTBCacheData;
import com.amazon.device.ads.DTBExpectedSizeProvider;
import com.amazon.device.ads.DtbCommonUtils;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import java.util.HashSet;
import java.util.Set;

class APSAdMobBannerCustomEventLoader
implements MediationBannerAd,
DTBAdBannerListener,
DTBExpectedSizeProvider {
    private static final String LOGTAG = APSAdMobBannerCustomEventLoader.class.getSimpleName();
    private AdSize size;
    private int expectedWidth = 0;
    private int expectedHeight = 0;
    static Set<String> autoRefreshRequestIds = new HashSet<String>();
    private final MediationBannerAdConfiguration mediationBannerAdConfiguration;
    private MediationBannerAdCallback bannerAdCallback;
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback;
    private ViewGroup viewToAd;

    APSAdMobBannerCustomEventLoader(MediationBannerAdConfiguration mediationBannerAdConfiguration, MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback) {
        this.mediationBannerAdConfiguration = mediationBannerAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void setExpectedHeight(int height) {
        this.expectedHeight = height;
    }

    public void setExpectedWidth(int width) {
        this.expectedWidth = width;
    }

    public int getExpectedHeight() {
        return this.expectedHeight;
    }

    public int getExpectedWidth() {
        return this.expectedWidth;
    }

    void loadAd(ApsMetricsPerfEventModelBuilder metricsBuilder, String correlationId) {
        APSAdMobUtil apsAdMobUtil = new APSAdMobUtil();
        try {
            CustomEventListenerAdapter customEventListenerAdapter = new CustomEventListenerAdapter(this.mediationAdLoadCallback);
            Bundle customEventExtras = this.mediationBannerAdConfiguration.getMediationExtras();
            this.size = this.mediationBannerAdConfiguration.getAdSize();
            Context context = this.mediationBannerAdConfiguration.getContext();
            String serverParameter = null;
            if (this.mediationBannerAdConfiguration.getServerParameters() != null) {
                serverParameter = this.mediationBannerAdConfiguration.getServerParameters().getString("parameter");
            }
            if (customEventExtras.containsKey("amazon_custom_event_adapter_version") && customEventExtras.getString("amazon_custom_event_adapter_version", "1.0").equals("2.0")) {
                String requestId = customEventExtras.getString("amazon_custom_event_request_id");
                DTBCacheData dtbCacheData = AdRegistration.getAdMobCache((String)requestId);
                if (dtbCacheData != null) {
                    if (dtbCacheData.isBidRequestFailed()) {
                        APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
                        ApsLog.e((String)LOGTAG, (String)"Fail to load custom banner ad in loadAd because previous bid requests failure");
                        this.mediationAdLoadCallback.onFailure(new AdError(3, "Fail to load custom banner ad in loadAd because previous bid requests failure", "com.amazon.device.ads"));
                        return;
                    }
                    DTBAdResponse currentAdResponse = dtbCacheData.getAdResponse();
                    if (currentAdResponse != null) {
                        String slotGroup = customEventExtras.getString("amazon_custom_event_slot_group");
                        Bundle renderingBundle = currentAdResponse.getRenderingBundle(!DtbCommonUtils.isNullOrEmpty((String)slotGroup));
                        apsAdMobUtil.renderAPSBannerAds(context, customEventListenerAdapter, this.size, serverParameter, renderingBundle, requestId, this, metricsBuilder, correlationId);
                        return;
                    }
                }
                apsAdMobUtil.loadBannerAd(context, customEventListenerAdapter, this.size, customEventExtras, serverParameter, autoRefreshRequestIds, this, metricsBuilder, correlationId);
            } else {
                APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
                APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.WARN, (APSEventType)APSEventType.LOG, (String)"Please upgrade to APS API since we don't support migration through DTB API");
                this.mediationAdLoadCallback.onFailure(new AdError(3, "Please upgrade to APS API since we don't support migration through DTB API", "com.amazon.device.ads"));
            }
        }
        catch (RuntimeException e) {
            APSAdMobUtil.captureAdapterEndEvent(ApsMetricsResult.Failure, metricsBuilder, correlationId);
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute loadAd method during runtime in APSAdMobBannerCustomEventLoader class", (Exception)e);
            this.mediationAdLoadCallback.onFailure(new AdError(3, "Fail to load custom banner ad in loadAd", "com.amazon.device.ads"));
        }
    }

    public void onAdLoaded(View adView) {
        try {
            this.viewToAd = DTBAdUtil.getAdViewWrapper((View)adView, (int)this.size.getWidth(), (int)this.size.getHeight(), (int)this.expectedWidth, (int)this.expectedHeight);
            if (this.mediationAdLoadCallback != null) {
                this.bannerAdCallback = (MediationBannerAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdLoaded method during runtime in APSAdMobBannerCustomEventLoader class", (Exception)e);
        }
    }

    public void onAdFailed(View view) {
        try {
            if (this.mediationAdLoadCallback != null) {
                this.mediationAdLoadCallback.onFailure(new AdError(3, "Custom banner ad failed to load", "com.amazon.device.ads"));
            }
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdFailed method during runtime in APSAdMobBannerCustomEventLoader class", (Exception)e);
        }
    }

    public void onAdClicked(View view) {
        try {
            this.bannerAdCallback.reportAdClicked();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdClicked method during runtime in APSAdMobBannerCustomEventLoader class", (Exception)e);
        }
    }

    @Deprecated
    public void onAdLeftApplication(View view) {
    }

    public void onAdOpen(View view) {
        try {
            this.bannerAdCallback.onAdOpened();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdOpen method during runtime in APSAdMobBannerCustomEventLoader class", (Exception)e);
        }
    }

    public void onAdClosed(View view) {
        try {
            this.bannerAdCallback.onAdClosed();
        }
        catch (RuntimeException e) {
            APSAnalytics.logEvent((APSEventSeverity)APSEventSeverity.FATAL, (APSEventType)APSEventType.EXCEPTION, (String)"Fail to execute onAdClosed method during runtime in APSAdMobBannerCustomEventLoader class", (Exception)e);
        }
    }

    public void onImpressionFired(View view) {
    }

    @NonNull
    public View getView() {
        return this.viewToAd;
    }
}

