/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.util.impl;

import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.request.UnmarshalledRequest;
import com.amazon.ask.request.impl.BaseUnmarshalledRequest;
import com.amazon.ask.util.JsonUnmarshaller;
import com.amazon.ask.util.impl.ObjectMapperFactory;
import com.amazon.ask.util.impl.UnmarshallUtils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class NamespaceEnabledJacksonJsonUnmarshaller<Type>
implements JsonUnmarshaller<Type> {
    private static final ObjectMapper MAPPER = ObjectMapperFactory.getMapper();
    private final Class<Type> outputType;
    private final Map<String, Class> validTypes;

    protected NamespaceEnabledJacksonJsonUnmarshaller(Class<Type> outputType, Map<String, Class> validTypes) {
        this.outputType = outputType;
        this.validTypes = validTypes;
    }

    public static <Output> NamespaceEnabledJacksonJsonUnmarshaller<Output> withTypeBinding(Class<Output> outputType, Map<String, Class> validTypes) {
        return new NamespaceEnabledJacksonJsonUnmarshaller<Output>(outputType, validTypes);
    }

    @Override
    public Optional<UnmarshalledRequest<Type>> unmarshall(byte[] in) {
        try {
            JsonNode root = MAPPER.readTree(in);
            Optional<String> namespaceDiscriminator = UnmarshallUtils.getNamespaceDiscriminator(root);
            if (!namespaceDiscriminator.isPresent() || !this.validTypes.containsKey(namespaceDiscriminator.get())) {
                return Optional.empty();
            }
            Class targetType = this.validTypes.get(namespaceDiscriminator.get());
            BaseUnmarshalledRequest<Object> unmarshalledRequest = new BaseUnmarshalledRequest<Object>(MAPPER.treeToValue((TreeNode)root, targetType), root);
            return Optional.of(unmarshalledRequest);
        }
        catch (IOException e) {
            throw new AskSdkException("Deserialization error", e);
        }
    }
}

