/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.impl;

import com.amazon.ask.AlexaSkill;
import com.amazon.ask.request.SkillRequest;
import com.amazon.ask.request.UnmarshalledRequest;
import com.amazon.ask.response.SkillResponse;
import com.amazon.ask.response.impl.BaseSkillResponse;
import com.amazon.ask.util.JsonMarshaller;
import com.amazon.ask.util.JsonUnmarshaller;
import com.amazon.ask.util.ValidationUtils;
import java.util.Optional;

public abstract class AbstractSkill<Request, Response>
implements AlexaSkill<Request, Response> {
    protected final JsonUnmarshaller<Request> unmarshaller;
    protected final JsonMarshaller<Response> marshaller;

    protected AbstractSkill(JsonUnmarshaller<Request> unmarshaller, JsonMarshaller<Response> marshaller) {
        this.unmarshaller = ValidationUtils.assertNotNull(unmarshaller, "unmarshaller");
        this.marshaller = ValidationUtils.assertNotNull(marshaller, "marshaller");
    }

    @Override
    public SkillResponse<Response> execute(SkillRequest request, Object context) {
        Optional<UnmarshalledRequest<Request>> deserializedRequest = this.unmarshaller.unmarshall(request.getRawRequest());
        if (!deserializedRequest.isPresent()) {
            return null;
        }
        Response response = this.invoke(deserializedRequest.get(), context);
        return new BaseSkillResponse<Response>(this.marshaller, response);
    }

    protected abstract Response invoke(UnmarshalledRequest<Request> var1, Object var2);
}

