/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.builder.impl;

import com.amazon.ask.builder.GenericSkillConfiguration;
import com.amazon.ask.request.exception.mapper.GenericExceptionMapper;
import com.amazon.ask.request.handler.adapter.GenericHandlerAdapter;
import com.amazon.ask.request.interceptor.GenericRequestInterceptor;
import com.amazon.ask.request.interceptor.GenericResponseInterceptor;
import com.amazon.ask.request.mapper.GenericRequestMapper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSkillConfiguration<Input, Output>
implements GenericSkillConfiguration<Input, Output> {
    protected final List<GenericRequestMapper<Input, Output>> requestMappers;
    protected final List<GenericHandlerAdapter<Input, Output>> handlerAdapters;
    protected final List<GenericRequestInterceptor<Input>> requestInterceptors;
    protected final List<GenericResponseInterceptor<Input, Output>> responseInterceptors;
    protected final GenericExceptionMapper<Input, Output> exceptionMapper;

    protected AbstractSkillConfiguration(List<GenericRequestMapper<Input, Output>> requestMappers, List<GenericHandlerAdapter<Input, Output>> handlerAdapters, List<GenericRequestInterceptor<Input>> requestInterceptors, List<GenericResponseInterceptor<Input, Output>> responseInterceptors, GenericExceptionMapper<Input, Output> exceptionMapper) {
        this.requestMappers = requestMappers;
        this.handlerAdapters = handlerAdapters;
        this.requestInterceptors = requestInterceptors;
        this.responseInterceptors = responseInterceptors;
        this.exceptionMapper = exceptionMapper;
    }

    @Override
    public List<GenericRequestMapper<Input, Output>> getRequestMappers() {
        return this.requestMappers;
    }

    @Override
    public List<GenericHandlerAdapter<Input, Output>> getHandlerAdapters() {
        return this.handlerAdapters;
    }

    @Override
    public List<GenericRequestInterceptor<Input>> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    @Override
    public List<GenericResponseInterceptor<Input, Output>> getResponseInterceptors() {
        return this.responseInterceptors;
    }

    @Override
    public GenericExceptionMapper<Input, Output> getExceptionMapper() {
        return this.exceptionMapper;
    }

    public static abstract class Builder<Input, Output, Self extends Builder> {
        protected List<GenericRequestMapper<Input, Output>> requestMappers;
        protected List<GenericHandlerAdapter<Input, Output>> handlerAdapters;
        protected List<GenericRequestInterceptor<Input>> requestInterceptors;
        protected List<GenericResponseInterceptor<Input, Output>> responseInterceptors;
        protected GenericExceptionMapper<Input, Output> exceptionMapper;

        protected Builder() {
        }

        public Self addRequestMapper(GenericRequestMapper<Input, Output> requestMapper) {
            if (this.requestMappers == null) {
                this.requestMappers = new ArrayList<GenericRequestMapper<Input, Output>>();
            }
            this.requestMappers.add(requestMapper);
            return (Self)this;
        }

        public Self withRequestMappers(List<GenericRequestMapper<Input, Output>> requestMappers) {
            this.requestMappers = requestMappers;
            return (Self)this;
        }

        public List<GenericRequestMapper<Input, Output>> getRequestMappers() {
            return this.requestMappers;
        }

        public Self addHandlerAdapter(GenericHandlerAdapter<Input, Output> handlerAdapter) {
            if (this.handlerAdapters == null) {
                this.handlerAdapters = new ArrayList<GenericHandlerAdapter<Input, Output>>();
            }
            this.handlerAdapters.add(handlerAdapter);
            return (Self)this;
        }

        public Self withHandlerAdapters(List<GenericHandlerAdapter<Input, Output>> handlerAdapters) {
            this.handlerAdapters = handlerAdapters;
            return (Self)this;
        }

        public List<GenericHandlerAdapter<Input, Output>> getHandlerAdapters() {
            return this.handlerAdapters;
        }

        public Self addRequestInterceptor(GenericRequestInterceptor<Input> requestInterceptor) {
            if (this.requestInterceptors == null) {
                this.requestInterceptors = new ArrayList<GenericRequestInterceptor<Input>>();
            }
            this.requestInterceptors.add(requestInterceptor);
            return (Self)this;
        }

        public Self withRequestInterceptors(List<GenericRequestInterceptor<Input>> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
            return (Self)this;
        }

        public List<GenericRequestInterceptor<Input>> getRequestInterceptors() {
            return this.requestInterceptors;
        }

        public Self addResponseInterceptor(GenericResponseInterceptor<Input, Output> responseInterceptor) {
            if (this.responseInterceptors == null) {
                this.responseInterceptors = new ArrayList<GenericResponseInterceptor<Input, Output>>();
            }
            this.responseInterceptors.add(responseInterceptor);
            return (Self)this;
        }

        public Self withResponseInterceptors(List<GenericResponseInterceptor<Input, Output>> responseInterceptors) {
            this.responseInterceptors = responseInterceptors;
            return (Self)this;
        }

        public List<GenericResponseInterceptor<Input, Output>> getResponseInterceptors() {
            return this.responseInterceptors;
        }

        public Self withExceptionMapper(GenericExceptionMapper<Input, Output> exceptionMapper) {
            this.exceptionMapper = exceptionMapper;
            return (Self)this;
        }

        public abstract GenericSkillConfiguration<Input, Output> build();
    }
}

