/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow.prompter;

import com.amashchenko.maven.plugin.gitflow.prompter.GitFlowPrompter;
import com.amashchenko.maven.plugin.gitflow.prompter.PromptValidation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Named
@Singleton
public class ConsolePrompter
implements GitFlowPrompter {
    private static final String LS = System.getProperty("line.separator");
    private final Prompter prompter;

    @Inject
    public ConsolePrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    @Override
    public String prompt(String[] choices, String defaultChoice, String preMessage, String postMessage) throws MojoFailureException {
        ArrayList<String> numberedList = new ArrayList<String>();
        String defChoice = null;
        StringBuilder str = new StringBuilder(preMessage).append(LS);
        for (int i = 0; i < choices.length; ++i) {
            str.append(i + 1).append(". ").append(choices[i]).append(LS);
            numberedList.add(String.valueOf(i + 1));
            if (!choices[i].equals(defaultChoice)) continue;
            defChoice = String.valueOf(i + 1);
        }
        str.append(postMessage);
        String response = null;
        try {
            while (StringUtils.isBlank(response)) {
                if (defaultChoice == null || defChoice == null) {
                    response = this.prompter.prompt(str.toString(), numberedList);
                    continue;
                }
                response = this.prompter.prompt(str.toString(), numberedList, defChoice);
            }
        }
        catch (PrompterException e) {
            throw new MojoFailureException("prompter error", (Throwable)e);
        }
        String result = null;
        if (response != null) {
            int num = Integer.parseInt(response);
            result = choices[num - 1];
        }
        return result;
    }

    @Override
    public String prompt(String message, PromptValidation<String> validation) throws MojoFailureException, CommandLineException {
        String response = null;
        try {
            while (response == null) {
                response = this.prompter.prompt(message);
                if (validation.valid(response)) continue;
                response = null;
            }
        }
        catch (PrompterException e) {
            throw new MojoFailureException("prompter error", (Throwable)e);
        }
        return response;
    }

    @Override
    public String prompt(String message, List<String> choices) throws MojoFailureException {
        String response = null;
        try {
            response = this.prompter.prompt(message, choices);
        }
        catch (PrompterException e) {
            throw new MojoFailureException("prompter error", (Throwable)e);
        }
        return response;
    }
}

