/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import android.opengl.Matrix;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.interfaces.IMapConfig;
import com.autonavi.base.amap.mapcore.FPoint;
import com.autonavi.base.amap.mapcore.Rectangle;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.concurrent.atomic.AtomicInteger;

@JBindingInclude
public class MapConfig
implements IMapConfig,
Cloneable {
    public static final int MSG_AUTH_FAILURE = 2;
    public static final int MSG_CAMERAUPDATE_CHANGE = 10;
    public static final int MSG_CAMERAUPDATE_FINISH = 11;
    public static final int MSG_ZOOMVIEW_CHANGESTATE = 12;
    public static final int MSG_COMPASSVIEW_CHANGESTATE = 13;
    public static final int MSG_CALLBACK_ONTOUCHEVENT = 14;
    public static final int MSG_CALLBACK_SCREENSHOT = 15;
    public static final int MSG_CALLBACK_MAPLOADED = 16;
    public static final int MSG_TILEOVERLAY_REFRESH = 17;
    public static final int MSG_INFOWINDOW_UPDATE = 18;
    public static final int MSG_ACTION_ONMAPCLICK = 19;
    public static final int MSG_ACTION_ONBASEPOICLICK = 20;
    public static final float MAX_ZOOM = 20.0f;
    public static final float MAX_ZOOM_INDOOR = 20.0f;
    public static final float MIN_ZOOM = 3.0f;
    public float maxZoomLevel = 20.0f;
    public float minZoomLevel = 3.0f;
    private String mCustomStylePath;
    private String mCustomStyleID;
    private FPoint[] mapRect = null;
    @JBindingInclude
    private Rectangle geoRectangle = new Rectangle();
    private boolean isIndoorEnable = false;
    private boolean isBuildingEnable = true;
    private boolean isMapTextEnable = true;
    private boolean isTrafficEnabled = false;
    private boolean isCustomStyleEnabled = false;
    @JBindingInclude
    private double sX = 2.21010267E8;
    @JBindingInclude
    private double sY = 1.01697799E8;
    private DPoint mapGeoCenter = new DPoint(this.sX, this.sY);
    @JBindingInclude
    private float sZ = 10.0f;
    @JBindingInclude
    private float sC = 0.0f;
    @JBindingInclude
    private float sR = 0.0f;
    @JBindingInclude
    private int mapWidth;
    @JBindingInclude
    private int mapHeight;
    private static final int TILE_SIZE_POW = 8;
    private static final int GEO_POINT_ZOOM = 20;
    MapConfig lastMapconfig = null;
    private boolean isCenterChanged = false;
    private boolean isZoomChanged = false;
    private boolean isTiltChanged = false;
    private boolean isBearingChanged = false;
    private boolean isNeedUpdateZoomControllerState = false;
    private boolean isNeedUpdateMapRectNextFrame = false;
    private boolean isSetLimitZoomLevel;
    private IPoint[] limitIPoints;
    private LatLngBounds limitLatLngBounds;
    private int mMapStyleMode = 0;
    private int mMapStyleTime = 0;
    private int mMapStyleState = 0;
    private int anchorX = 0;
    private String mMapLanguage = "zh_cn";
    private boolean isHideLogoEnable = false;
    private boolean isWorldMapEnable = false;
    private boolean isTouchPoiEnable = true;
    private int abroadState = 1;
    private boolean isAbroadEnable = false;
    private boolean isTerrainEnable = false;
    @JBindingInclude
    float[] viewMatrix = new float[16];
    @JBindingInclude
    float[] projectionMatrix = new float[16];
    @JBindingInclude
    float[] mvpMatrix = new float[16];
    @JBindingInclude
    private int[] tilsIDs = new int[100];
    private float skyHeight;
    private boolean mapEnable = true;
    private int anchorY = 0;
    @JBindingInclude
    private float mapPerPixelUnitLength;
    private String customTextureResourcePath;
    private boolean isProFunctionAuthEnable = true;
    private boolean isUseProFunction = false;
    private int customBackgroundColor = -1;
    private float mapZoomScale = 1.0f;
    private AtomicInteger changedCounter = new AtomicInteger(0);
    private volatile double changeRatio = 1.0;
    private volatile double changeGridRatio = 1.0;
    public static final int DEFAULT_RATIO = 1;
    private int gridX = 0;
    private int gridY = 0;

    public int getAnchorY() {
        return this.anchorY;
    }

    public void setAnchorY(int n2) {
        this.anchorY = n2;
    }

    public int getAnchorX() {
        return this.anchorX;
    }

    public void setAnchorX(int n2) {
        this.anchorX = n2;
    }

    public MapConfig(boolean bl2) {
        if (bl2) {
            this.lastMapconfig = new MapConfig(false);
            this.lastMapconfig.setGridXY(0, 0);
            this.lastMapconfig.setSX(0.0);
            this.lastMapconfig.setSY(0.0);
            this.lastMapconfig.setSZ(0.0f);
            this.lastMapconfig.setSC(0.0f);
            this.lastMapconfig.setSR(0.0f);
        }
    }

    public int getChangedCounter() {
        return this.changedCounter.get();
    }

    public void resetChangedCounter() {
        this.changedCounter.set(0);
    }

    public void addChangedCounter() {
        this.changedCounter.incrementAndGet();
    }

    public boolean isMapStateChange() {
        boolean bl2 = false;
        if (this.lastMapconfig != null) {
            double d2 = this.lastMapconfig.getSX();
            double d3 = this.lastMapconfig.getSY();
            float f2 = this.lastMapconfig.getSZ();
            float f3 = this.lastMapconfig.getSC();
            float f4 = this.lastMapconfig.getSR();
            this.isCenterChanged = d2 != this.sX;
            this.isCenterChanged = d3 != this.sY ? true : this.isCenterChanged;
            boolean bl3 = this.isZoomChanged = f2 != this.sZ;
            if (this.isZoomChanged) {
                this.isNeedUpdateZoomControllerState = f2 <= this.minZoomLevel || this.sZ <= this.minZoomLevel || f2 >= this.maxZoomLevel || this.sZ >= this.maxZoomLevel;
            }
            this.isTiltChanged = f3 != this.sC;
            this.isBearingChanged = f4 != this.sR;
            bl2 = this.isCenterChanged || this.isZoomChanged || this.isTiltChanged || this.isBearingChanged || this.isNeedUpdateMapRectNextFrame;
            if (bl2) {
                this.isNeedUpdateMapRectNextFrame = false;
                int n2 = (int)this.sZ;
                int n3 = (int)this.sX >> 20 - n2 + 8;
                n2 = (int)this.sY >> 20 - n2 + 8;
                this.setGridXY(n3, n2);
                this.changeRatio();
            }
        }
        if (this.sC >= 45.0f && this.skyHeight == 0.0f) {
            return true;
        }
        return bl2;
    }

    protected void setGridXY(int n2, int n3) {
        if (this.lastMapconfig != null) {
            this.lastMapconfig.setGridXY(this.gridX, this.gridY);
        }
        this.gridX = n2;
        this.gridY = n3;
    }

    protected int getGridX() {
        return this.gridX;
    }

    protected int getGridY() {
        return this.gridY;
    }

    public double getChangeRatio() {
        return this.changeRatio;
    }

    public double getChangeGridRatio() {
        return this.changeGridRatio;
    }

    private void changeRatio() {
        double d2 = this.lastMapconfig.getSX();
        double d3 = this.lastMapconfig.getSY();
        float f2 = this.lastMapconfig.getSZ();
        float f3 = this.lastMapconfig.getSC();
        float f4 = this.lastMapconfig.getSR();
        this.changeRatio = Math.abs(this.sX - d2) + Math.abs(this.sY - d3);
        this.changeRatio = this.changeRatio == 0.0 ? 1.0 : this.changeRatio * 2.0;
        this.changeRatio *= f2 == this.sZ ? 1.0 : (double)Math.abs(f2 - this.sZ);
        float f5 = f3 == this.sC ? 1.0f : Math.abs(f3 - this.sC);
        float f6 = f4 == this.sR ? 1.0f : Math.abs(f4 - this.sR);
        this.changeRatio *= (double)f5;
        this.changeRatio *= (double)f6;
        this.changeGridRatio = Math.abs(this.lastMapconfig.getGridX() - this.gridX) + (this.lastMapconfig.getGridY() - this.gridY);
        this.changeGridRatio = this.changeGridRatio == 0.0 ? 1.0 : this.changeGridRatio * 2.0;
        this.changeGridRatio *= (double)f5;
        this.changeGridRatio *= (double)f6;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" sX: ");
        stringBuilder.append(this.sX);
        stringBuilder.append(" sY: ");
        stringBuilder.append(this.sY);
        stringBuilder.append(" sZ: ");
        stringBuilder.append(this.sZ);
        stringBuilder.append(" sC: ");
        stringBuilder.append(this.sC);
        stringBuilder.append(" sR: ");
        stringBuilder.append(this.sR);
        stringBuilder.append(" skyHeight: ");
        stringBuilder.append(this.skyHeight);
        return stringBuilder.toString();
    }

    public boolean isZoomChanged() {
        return this.isZoomChanged;
    }

    public boolean isTiltChanged() {
        return this.isTiltChanged;
    }

    public boolean isBearingChanged() {
        return this.isBearingChanged;
    }

    public boolean isIndoorEnable() {
        return this.isIndoorEnable;
    }

    public void setIndoorEnable(boolean bl2) {
        this.isIndoorEnable = bl2;
    }

    public boolean isBuildingEnable() {
        return this.isBuildingEnable;
    }

    public void setBuildingEnable(boolean bl2) {
        this.isBuildingEnable = bl2;
    }

    public boolean isMapTextEnable() {
        return this.isMapTextEnable;
    }

    public void setMapTextEnable(boolean bl2) {
        this.isMapTextEnable = bl2;
    }

    public boolean isTrafficEnabled() {
        return this.isTrafficEnabled;
    }

    public void setTrafficEnabled(boolean bl2) {
        this.isTrafficEnabled = bl2;
    }

    public boolean isNeedUpdateZoomControllerState() {
        return this.isNeedUpdateZoomControllerState;
    }

    public double getSX() {
        return this.sX;
    }

    public void setSX(double d2) {
        if (this.lastMapconfig != null) {
            this.lastMapconfig.setSX(this.sX);
        }
        this.mapGeoCenter.x = this.sX = d2;
    }

    public double getSY() {
        return this.sY;
    }

    public void setSY(double d2) {
        if (this.lastMapconfig != null) {
            this.lastMapconfig.setSY(this.sY);
        }
        this.mapGeoCenter.x = this.sY = d2;
    }

    public DPoint getMapGeoCenter() {
        return this.mapGeoCenter;
    }

    public float getSZ() {
        return this.sZ;
    }

    public void setSZ(float f2) {
        if (this.lastMapconfig != null) {
            this.lastMapconfig.setSZ(this.sZ);
        }
        this.sZ = f2;
    }

    public float getSC() {
        return this.sC;
    }

    public void setSC(float f2) {
        if (this.lastMapconfig != null) {
            this.lastMapconfig.setSC(this.sC);
        }
        this.sC = f2;
    }

    public float getSR() {
        return this.sR;
    }

    public void setSR(float f2) {
        if (this.lastMapconfig != null) {
            this.lastMapconfig.setSR(this.sR);
        }
        this.sR = f2;
    }

    public FPoint[] getMapRect() {
        return this.mapRect;
    }

    public void setMapRect(FPoint[] fPointArray) {
        if (this.lastMapconfig != null) {
            this.lastMapconfig.setMapRect(fPointArray);
        }
        this.mapRect = fPointArray;
    }

    public Rectangle getGeoRectangle() {
        return this.geoRectangle;
    }

    public void setMaxZoomLevel(float f2) {
        if (f2 > 20.0f) {
            f2 = 20.0f;
        }
        if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        if (f2 < this.getMinZoomLevel()) {
            f2 = this.getMinZoomLevel();
        }
        this.isSetLimitZoomLevel = true;
        this.maxZoomLevel = f2;
    }

    public void setMinZoomLevel(float f2) {
        if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        if (f2 > 20.0f) {
            f2 = 20.0f;
        }
        if (f2 > this.getMaxZoomLevel()) {
            f2 = this.getMaxZoomLevel();
        }
        this.isSetLimitZoomLevel = true;
        this.minZoomLevel = f2;
    }

    public float getMaxZoomLevel() {
        return this.maxZoomLevel;
    }

    public float getMinZoomLevel() {
        return this.minZoomLevel;
    }

    public IPoint[] getLimitIPoints() {
        return this.limitIPoints;
    }

    public void setLimitIPoints(IPoint[] iPointArray) {
        this.limitIPoints = iPointArray;
    }

    public boolean isSetLimitZoomLevel() {
        return this.isSetLimitZoomLevel;
    }

    public LatLngBounds getLimitLatLngBounds() {
        return this.limitLatLngBounds;
    }

    public void setLimitLatLngBounds(LatLngBounds latLngBounds) {
        this.limitLatLngBounds = latLngBounds;
        if (latLngBounds == null) {
            this.resetMinMaxZoomPreference();
        }
    }

    public void resetMinMaxZoomPreference() {
        this.minZoomLevel = 3.0f;
        this.maxZoomLevel = 20.0f;
        this.isSetLimitZoomLevel = false;
    }

    public void updateMapRectNextFrame(boolean bl2) {
        this.isNeedUpdateMapRectNextFrame = bl2;
    }

    public void setMapPerPixelUnitLength(float f2) {
        this.mapPerPixelUnitLength = f2;
    }

    public float getMapPerPixelUnitLength() {
        return this.mapPerPixelUnitLength;
    }

    public void setCustomStylePath(String string2) {
        this.mCustomStylePath = string2;
    }

    public String getCustomStylePath() {
        return this.mCustomStylePath;
    }

    public String getCustomStyleID() {
        return this.mCustomStyleID;
    }

    public void setCustomStyleID(String string2) {
        this.mCustomStyleID = string2;
    }

    public void setCustomStyleEnable(boolean bl2) {
        this.isCustomStyleEnabled = bl2;
    }

    public boolean isCustomStyleEnable() {
        return this.isCustomStyleEnabled;
    }

    public int getMapStyleTime() {
        return this.mMapStyleTime;
    }

    public void setMapStyleTime(int n2) {
        this.mMapStyleTime = n2;
    }

    public int getMapStyleMode() {
        return this.mMapStyleMode;
    }

    public void setMapStyleMode(int n2) {
        this.mMapStyleMode = n2;
    }

    public int getMapStyleState() {
        return this.mMapStyleState;
    }

    public void setMapStyleState(int n2) {
        this.mMapStyleState = n2;
    }

    public void setCustomTextureResourcePath(String string2) {
        this.customTextureResourcePath = string2;
    }

    public String getCustomTextureResourcePath() {
        return this.customTextureResourcePath;
    }

    public boolean isProFunctionAuthEnable() {
        return this.isProFunctionAuthEnable;
    }

    public void setProFunctionAuthEnable(boolean bl2) {
        this.isProFunctionAuthEnable = bl2;
    }

    public boolean isUseProFunction() {
        return this.isUseProFunction;
    }

    public void setUseProFunction(boolean bl2) {
        this.isUseProFunction = bl2;
    }

    public void setCustomBackgroundColor(int n2) {
        this.customBackgroundColor = n2;
    }

    public int getCustomBackgroundColor() {
        return this.customBackgroundColor;
    }

    public void setMapZoomScale(float f2) {
        this.mapZoomScale = f2;
    }

    public float getMapZoomScale() {
        return this.mapZoomScale;
    }

    public void setMapWidth(int n2) {
        this.mapWidth = n2;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapHeight(int n2) {
        this.mapHeight = n2;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapLanguage(String string2) {
        this.mMapLanguage = string2;
    }

    public String getMapLanguage() {
        return this.mMapLanguage;
    }

    public void setHideLogoEnble(boolean bl2) {
        this.isHideLogoEnable = bl2;
    }

    public boolean isHideLogoEnable() {
        return this.isHideLogoEnable;
    }

    public void setWorldMapEnable(boolean bl2) {
        this.isWorldMapEnable = bl2;
    }

    public boolean isWorldMapEnable() {
        return this.isWorldMapEnable;
    }

    public float getSkyHeight() {
        return this.skyHeight;
    }

    public void setSkyHeight(float f2) {
        this.skyHeight = f2;
    }

    public float[] getViewMatrix() {
        return this.viewMatrix;
    }

    public float[] getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public float[] getMvpMatrix() {
        return this.mvpMatrix;
    }

    public void updateFinalMatrix() {
        Matrix.multiplyMM((float[])this.mvpMatrix, (int)0, (float[])this.projectionMatrix, (int)0, (float[])this.viewMatrix, (int)0);
    }

    public int[] getCurTileIds() {
        return this.tilsIDs;
    }

    public boolean isTouchPoiEnable() {
        return this.isTouchPoiEnable;
    }

    public void setTouchPoiEnable(boolean bl2) {
        this.isTouchPoiEnable = bl2;
    }

    public boolean isMapEnable() {
        return this.mapEnable;
    }

    public void setMapEnable(boolean bl2) {
        this.mapEnable = bl2;
    }

    public int getAbroadState() {
        return this.abroadState;
    }

    public void setAbroadState(int n2) {
        this.abroadState = n2;
    }

    public boolean isAbroadEnable() {
        return this.isAbroadEnable;
    }

    public void setAbroadEnable(boolean bl2) {
        this.isAbroadEnable = bl2;
    }

    public boolean isTerrainEnable() {
        return this.isTerrainEnable;
    }

    public void setTerrainEnable(boolean bl2) {
        this.isTerrainEnable = bl2;
    }
}

