/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.gloverlay;

import android.content.Context;
import android.graphics.Bitmap;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import com.autonavi.base.ae.gmap.gloverlay.GLOverlay;
import com.autonavi.base.amap.api.mapcore.IAMapDelegate;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMapOverlay<T extends GLOverlay, E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected T mGLOverlay;
    protected Vector<E> mItemList = null;
    protected Context mContext;
    protected IAMapDelegate mMapView;
    protected int mEngineID = 1;
    protected int mLastFocusedIndex;

    protected abstract void iniGLOverlay();

    public abstract void addItem(E var1);

    public abstract void resumeMarker(Bitmap var1);

    public BaseMapOverlay(int n2, Context context, IAMap iAMap) {
        this.mEngineID = n2;
        this.mContext = context;
        try {
            this.mMapView = (IAMapDelegate)iAMap;
        }
        catch (Throwable throwable) {}
        this.mItemList = new Vector();
        this.iniGLOverlay();
    }

    public T getGLOverlay() {
        return this.mGLOverlay;
    }

    public abstract void setVisible(boolean var1);

    public boolean isVisible() {
        if (this.mGLOverlay != null) {
            return ((GLOverlay)this.mGLOverlay).isVisible();
        }
        return false;
    }

    public void setClickable(boolean bl2) {
        if (this.mGLOverlay != null) {
            ((GLOverlay)this.mGLOverlay).setClickable(bl2);
        }
    }

    public boolean isClickable() {
        if (this.mGLOverlay != null) {
            return ((GLOverlay)this.mGLOverlay).isClickable();
        }
        return false;
    }

    public int getSize() {
        return this.mItemList.size();
    }

    public boolean clear() {
        try {
            this.mItemList.clear();
            this.clearFocus();
            if (this.mGLOverlay != null) {
                ((GLOverlay)this.mGLOverlay).removeAll();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean removeAll() {
        return this.clear();
    }

    public void clearFocus() {
        this.mLastFocusedIndex = -1;
        ((GLOverlay)this.mGLOverlay).clearFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final E getItem(int n2) {
        try {
            Vector<E> vector = this.mItemList;
            synchronized (vector) {
                if (n2 < 0 || n2 > this.mItemList.size() - 1) {
                    return null;
                }
                return this.mItemList.get(n2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void removeItem(int n2) {
        try {
            if (n2 < 0 || n2 > this.mItemList.size() - 1) {
                return;
            }
            if (n2 == this.mLastFocusedIndex) {
                this.mLastFocusedIndex = -1;
                this.clearFocus();
            }
            this.mItemList.remove(n2);
            if (this.mGLOverlay != null) {
                ((GLOverlay)this.mGLOverlay).removeItem(n2);
            }
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(E e2) {
        if (e2 == null) {
            return;
        }
        try {
            Vector<E> vector = this.mItemList;
            synchronized (vector) {
                int n2 = this.mItemList.indexOf(e2);
                this.removeItem(n2);
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    public List<E> getItems() {
        return this.mItemList;
    }

    public void releaseInstance() {
        if (this.getGLOverlay() != null) {
            if (this.mMapView != null && this.mMapView.isMaploaded()) {
                this.mMapView.removeEngineGLOverlay(this);
            }
            ((GLOverlay)this.getGLOverlay()).releaseInstance();
            this.mGLOverlay = null;
        }
    }
}

