/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

public final class Pools {
    private Pools() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SynchronizedPool<T>
    extends SimplePool<T> {
        private final Object mLock = new Object();

        public SynchronizedPool(int n2) {
            super(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T acquire() {
            Object object = this.mLock;
            synchronized (object) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release(T t2) {
            Object object = this.mLock;
            synchronized (object) {
                return super.release(t2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimplePool<T>
    implements Pool<T> {
        private final Object[] mPool;
        private int mPoolSize;

        public SimplePool(int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[n2];
        }

        @Override
        public T acquire() {
            if (this.mPoolSize > 0) {
                int n2 = this.mPoolSize - 1;
                Object object = this.mPool[n2];
                this.mPool[n2] = null;
                --this.mPoolSize;
                return (T)object;
            }
            return null;
        }

        @Override
        public boolean release(T t2) {
            if (this.isInPool(t2)) {
                throw new IllegalStateException("Already in the pool!");
            }
            if (this.mPoolSize < this.mPool.length) {
                this.mPool[this.mPoolSize] = t2;
                ++this.mPoolSize;
                return true;
            }
            return false;
        }

        @Override
        public void destory() {
            for (int i2 = 0; i2 < this.mPool.length; ++i2) {
                this.mPool[i2] = null;
            }
        }

        private boolean isInPool(T t2) {
            for (int i2 = 0; i2 < this.mPoolSize; ++i2) {
                if (this.mPool[i2] != t2) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Pool<T> {
        public T acquire();

        public boolean release(T var1);

        public void destory();
    }
}

