/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.utils.overlay;

import android.os.Parcelable;
import com.amap.api.mapcore.util.dk;
import com.amap.api.mapcore.util.ii;
import com.amap.api.mapcore.util.ij;
import com.amap.api.maps.AMap;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.BasePointOverlay;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.MapProjection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingPointOverlay {
    private AMap mAMap;
    private long duration = 10000L;
    private long mStepDuration = 20L;
    private LinkedList<LatLng> points = new LinkedList();
    private LinkedList<Double> eachDistance = new LinkedList();
    private double totalDistance = 0.0;
    private double remainDistance = 0.0;
    private ii mThreadPools;
    private Object mLock = new Object();
    private BasePointOverlay baseOverlay = null;
    private int index = 0;
    private boolean useDefaultDescriptor = false;
    AtomicBoolean exitFlag = new AtomicBoolean(false);
    private MoveListener moveListener;
    private a STATUS = a.a;
    private long pauseMillis;
    private long mAnimationBeginTime = System.currentTimeMillis();

    public MovingPointOverlay(AMap aMap, BasePointOverlay basePointOverlay) {
        if (aMap == null || basePointOverlay == null) {
            return;
        }
        this.mAMap = aMap;
        this.mThreadPools = dk.a("AMapMoveSmoothThread");
        this.baseOverlay = basePointOverlay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(List<LatLng> object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            try {
                if (object == null || object.size() < 2) {
                    return;
                }
                this.stopMove();
                this.points.clear();
                object = object.iterator();
                while (object.hasNext()) {
                    LatLng latLng = (LatLng)object.next();
                    if (latLng == null) continue;
                    this.points.add(latLng);
                }
                this.eachDistance.clear();
                this.totalDistance = 0.0;
                for (int i2 = 0; i2 < this.points.size() - 1; ++i2) {
                    double d2 = AMapUtils.calculateLineDistance(this.points.get(i2), this.points.get(i2 + 1));
                    this.eachDistance.add(d2);
                    this.totalDistance += d2;
                }
                this.remainDistance = this.totalDistance;
                LatLng latLng = this.points.get(0);
                this.baseOverlay.setPosition(latLng);
                this.reset();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return;
        }
    }

    private void reset() {
        try {
            if (this.STATUS == a.c || this.STATUS == a.d) {
                this.exitFlag.set(true);
                this.mThreadPools.a(this.mStepDuration + 20L, TimeUnit.MILLISECONDS);
                this.baseOverlay.setAnimation(null);
                this.STATUS = a.a;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void resetIndex() {
        this.index = 0;
    }

    public void setTotalDuration(int n2) {
        this.duration = n2 * 1000;
    }

    public void startSmoothMove() {
        if (this.STATUS == a.d) {
            this.STATUS = a.c;
            long l2 = System.currentTimeMillis() - this.pauseMillis;
            this.mAnimationBeginTime += l2;
            return;
        }
        if (this.STATUS == a.a || this.STATUS == a.e) {
            if (this.points.size() <= 0) {
                return;
            }
            this.index = 0;
            try {
                this.mThreadPools.a(new b(0));
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private IPoint getCurPosition(long l2) {
        if (l2 > this.duration) {
            this.exitFlag.set(true);
            IPoint iPoint = new IPoint();
            this.index = this.points.size() - 1;
            LatLng latLng = this.points.get(this.index);
            --this.index;
            this.index = Math.max(this.index, 0);
            this.remainDistance = 0.0;
            MapProjection.lonlat2Geo(latLng.longitude, latLng.latitude, iPoint);
            if (this.moveListener != null) {
                this.moveListener.move(this.remainDistance);
            }
            return iPoint;
        }
        double d2 = (double)l2 * this.totalDistance / (double)this.duration;
        this.remainDistance = this.totalDistance - d2;
        int n2 = 0;
        double d3 = 1.0;
        for (int i2 = 0; i2 < this.eachDistance.size(); ++i2) {
            double d4 = this.eachDistance.get(i2);
            if (d2 > d4) {
                d2 -= d4;
                continue;
            }
            if (d4 > 0.0) {
                d3 = d2 / d4;
            }
            n2 = i2;
            break;
        }
        if (n2 != this.index && this.moveListener != null) {
            this.moveListener.move(this.remainDistance);
        }
        this.index = n2;
        Parcelable parcelable = this.points.get(n2);
        LatLng latLng = this.points.get(n2 + 1);
        IPoint iPoint = new IPoint();
        MapProjection.lonlat2Geo(parcelable.longitude, parcelable.latitude, iPoint);
        IPoint iPoint2 = new IPoint();
        MapProjection.lonlat2Geo(latLng.longitude, latLng.latitude, iPoint2);
        int n3 = iPoint2.x - iPoint.x;
        int n4 = iPoint2.y - iPoint.y;
        if (AMapUtils.calculateLineDistance(parcelable, latLng) > 1.0f) {
            float f2 = this.getRotate(iPoint, iPoint2);
            if (this.mAMap != null && (parcelable = this.mAMap.getCameraPosition()) != null) {
                this.baseOverlay.setRotateAngle(360.0f - f2 + ((CameraPosition)parcelable).bearing);
            }
        }
        return new IPoint((int)((double)iPoint.x + (double)n3 * d3), (int)((double)iPoint.y + (double)n4 * d3));
    }

    private float getRotate(IPoint iPoint, IPoint iPoint2) {
        if (iPoint == null || iPoint2 == null) {
            return 0.0f;
        }
        double d2 = iPoint2.y;
        double d3 = iPoint.y;
        double d4 = iPoint.x;
        return (float)(Math.atan2((double)iPoint2.x - d4, d3 - d2) / Math.PI * 180.0);
    }

    public void stopMove() {
        if (this.STATUS == a.c) {
            this.STATUS = a.d;
            this.pauseMillis = System.currentTimeMillis();
        }
    }

    public BasePointOverlay getObject() {
        return this.baseOverlay;
    }

    public LatLng getPosition() {
        if (this.baseOverlay != null) {
            return this.baseOverlay.getPosition();
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.removeMarker();
            this.mThreadPools.c();
            Object object = this.mLock;
            synchronized (object) {
                this.points.clear();
                this.eachDistance.clear();
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void removeMarker() {
        try {
            this.reset();
            if (this.baseOverlay != null) {
                this.baseOverlay.remove();
                this.baseOverlay = null;
            }
            this.points.clear();
            this.eachDistance.clear();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setPosition(LatLng latLng) {
        try {
            if (this.baseOverlay != null) {
                this.baseOverlay.setPosition(latLng);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setRotate(float f2) {
        try {
            CameraPosition cameraPosition;
            if (this.baseOverlay != null && this.mAMap != null && (cameraPosition = this.mAMap.getCameraPosition()) != null) {
                this.baseOverlay.setRotateAngle(360.0f - f2 + cameraPosition.bearing);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.baseOverlay != null) {
                this.baseOverlay.setVisible(bl2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setMoveListener(MoveListener moveListener) {
        this.moveListener = moveListener;
    }

    private final class b
    extends ij {
        private b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void runTask() {
            try {
                MovingPointOverlay.this.mAnimationBeginTime = System.currentTimeMillis();
                MovingPointOverlay.this.STATUS = com.amap.api.maps.utils.overlay.MovingPointOverlay$a.b;
                MovingPointOverlay.this.exitFlag.set(false);
                while (!MovingPointOverlay.this.exitFlag.get() && MovingPointOverlay.this.index <= MovingPointOverlay.this.points.size() - 1) {
                    Object object = MovingPointOverlay.this.mLock;
                    synchronized (object) {
                        if (MovingPointOverlay.this.exitFlag.get()) {
                            return;
                        }
                        if (MovingPointOverlay.this.STATUS != com.amap.api.maps.utils.overlay.MovingPointOverlay$a.d) {
                            long l2 = System.currentTimeMillis() - MovingPointOverlay.this.mAnimationBeginTime;
                            IPoint iPoint = MovingPointOverlay.this.getCurPosition(l2);
                            MovingPointOverlay.this.baseOverlay.setGeoPoint(iPoint);
                            MovingPointOverlay.this.STATUS = com.amap.api.maps.utils.overlay.MovingPointOverlay$a.c;
                        }
                    }
                    Thread.sleep(MovingPointOverlay.this.mStepDuration);
                }
                MovingPointOverlay.this.STATUS = com.amap.api.maps.utils.overlay.MovingPointOverlay$a.e;
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
        }

        /* synthetic */ b(byte by2) {
            this();
        }
    }

    public static interface MoveListener {
        public void move(double var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum a {
        a,
        b,
        c,
        d,
        e;

    }
}

