/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBindingInclude
public class GL3DModelOptions
extends BaseOptions {
    @JBindingInclude
    private float rotate;
    @JBindingInclude
    private LatLng latLng;
    private List<Float> vertextList = new ArrayList<Float>();
    private List<Float> textrueList = new ArrayList<Float>();
    @JBindingInclude
    private boolean isModeltUpdate = false;
    @JBindingInclude
    private String modelData;
    @JBindingInclude
    private BitmapDescriptor bitmapDescriptor;
    @JBindingInclude
    private int fixedLength = 50;
    @JBindingInclude
    private boolean visibile = true;
    @JBindingInclude
    private String title;
    @JBindingInclude
    private String snippet;

    public GL3DModelOptions() {
        this.type = "GL3DModelOptions";
    }

    public GL3DModelOptions textureDrawable(BitmapDescriptor bitmapDescriptor) {
        this.bitmapDescriptor = bitmapDescriptor;
        return this;
    }

    public GL3DModelOptions vertexData(String string2) {
        if (string2 != null && string2.length() > 0) {
            this.modelData = string2;
            this.isModeltUpdate = true;
        }
        return this;
    }

    public GL3DModelOptions vertexData(List<Float> object, List<Float> list) {
        this.vertextList = object;
        this.textrueList = list;
        object = new StringBuilder();
        if (this.vertextList != null) {
            for (int i2 = 0; i2 < this.vertextList.size() - 3; i2 += 3) {
                ((StringBuilder)object).append("v ");
                ((StringBuilder)object).append(this.vertextList.get(i2)).append(" ");
                ((StringBuilder)object).append(this.vertextList.get(i2 + 1)).append(" ");
                ((StringBuilder)object).append(this.vertextList.get(i2 + 2));
                ((StringBuilder)object).append("\n");
            }
        }
        if (this.textrueList != null) {
            for (int i3 = 0; i3 < this.textrueList.size() - 2; i3 += 2) {
                ((StringBuilder)object).append("vt ");
                ((StringBuilder)object).append(this.textrueList.get(i3)).append(" ");
                ((StringBuilder)object).append(1.0f - this.textrueList.get(i3 + 1).floatValue());
                ((StringBuilder)object).append("\n");
            }
        }
        this.vertexData(((StringBuilder)object).toString());
        return this;
    }

    public GL3DModelOptions position(LatLng latLng) {
        this.latLng = latLng;
        return this;
    }

    public GL3DModelOptions angle(float f2) {
        this.rotate = f2;
        return this;
    }

    public List<Float> getVertext() {
        return this.vertextList;
    }

    public List<Float> getTextrue() {
        return this.textrueList;
    }

    public float getAngle() {
        return this.rotate;
    }

    public LatLng getLatLng() {
        return this.latLng;
    }

    public BitmapDescriptor getBitmapDescriptor() {
        return this.bitmapDescriptor;
    }

    public GL3DModelOptions setModelFixedLength(int n2) {
        this.fixedLength = n2;
        return this;
    }

    public int getModelFixedLength() {
        return this.fixedLength;
    }

    public GL3DModelOptions setVisible(boolean bl2) {
        this.visibile = bl2;
        return this;
    }

    public boolean isVisible() {
        return this.visibile;
    }

    public GL3DModelOptions title(String string2) {
        this.title = string2;
        return this;
    }

    public GL3DModelOptions snippet(String string2) {
        this.snippet = string2;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSnippet() {
        return this.snippet;
    }
}

