/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.amap.api.col.3l.dx;
import com.amap.api.col.3l.dy;
import com.amap.api.col.3l.dz;
import com.amap.api.col.3l.ha;
import com.amap.api.maps.MapsInitializer;
import com.autonavi.base.amap.mapcore.tools.GLFileUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String TAG = "FileUtil";
    private static final int BUFFER = 1024;
    private static final String FILE_PATH_ENTRY_BACK = "..";
    private static final String FILE_PATH_ENTRY_SEPARATOR1 = "\\";
    private static final String FILE_PATH_ENTRY_SEPARATOR2 = "%";

    public static boolean deleteFile(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isFile()) {
                    if (fileArray[i2].delete()) continue;
                    return false;
                }
                if (!FileUtil.deleteFile(fileArray[i2])) {
                    return false;
                }
                fileArray[i2].delete();
            }
        }
        file.delete();
        return true;
    }

    public static String getMapBaseStorage(Context context) {
        Object object;
        String string2;
        if (context == null) {
            return null;
        }
        int n2 = Build.VERSION.SDK_INT;
        String string3 = "map_base_path";
        if (n2 > 18) {
            string3 = "map_base_path_v44";
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("base_path", 0);
        if (MapsInitializer.sdcardDir != null && MapsInitializer.sdcardDir.trim().length() > 0) {
            string2 = MapsInitializer.sdcardDir + File.separatorChar;
        } else {
            string2 = sharedPreferences.getString(string3, "");
            object = FileUtil.getExternalStroragePath(context);
            if (string2 != null && !string2.contains((CharSequence)object)) {
                string2 = null;
            }
        }
        if (string2 != null && string2.length() > 2) {
            object = new File(string2);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (((File)object).isDirectory()) {
                if (FileUtil.checkCanWrite((File)object)) {
                    return string2;
                }
                string2 = context.getCacheDir().toString() + "/amap/";
                if (string2 != null && string2.length() > 2) {
                    object = new File(string2);
                    if (!((File)object).exists()) {
                        ((File)object).mkdir();
                    }
                    if (((File)object).isDirectory()) {
                        return string2;
                    }
                }
            }
        }
        if ((string2 = FileUtil.getExternalStroragePath(context) + "/amap/") != null && string2.length() > 2) {
            object = new File(string2);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (((File)object).isDirectory() && ((File)object).canWrite()) {
                context = sharedPreferences.edit();
                context.putString(string3, string2);
                context.commit();
                FileUtil.createNoMediaFileIfNotExist(string2);
                return string2;
            }
        }
        if ((string2 = context.getCacheDir().toString() + "/amap/") != null && string2.length() > 2) {
            object = new File(string2);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (((File)object).isDirectory()) {
                return string2;
            }
        }
        return string2;
    }

    public static boolean checkCanWrite(File file) {
        if (file == null) {
            return false;
        }
        if (!file.canWrite()) {
            return false;
        }
        file = new File(file, "amap.tmp");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getExternalStroragePath(Context context) {
        if (context != null) {
            return context.getExternalFilesDir("").getAbsolutePath() + File.separatorChar;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDatasToFile(String object, byte[] byArray) {
        FileOutputStream fileOutputStream;
        ReentrantReadWriteLock.WriteLock writeLock;
        block9: {
            block8: {
                writeLock = new ReentrantReadWriteLock().writeLock();
                writeLock.lock();
                fileOutputStream = null;
                try {
                    if (byArray == null || byArray.length == 0) {
                        writeLock.unlock();
                        break block8;
                    }
                    if (((File)(object = new File((String)object))).exists()) {
                        ((File)object).delete();
                    }
                    ((File)object).createNewFile();
                    fileOutputStream = new FileOutputStream((File)object);
                    ((OutputStream)fileOutputStream).write(byArray);
                    fileOutputStream.flush();
                    writeLock.unlock();
                    break block9;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            FileUtil.safelyCloseFile(null);
            return;
        }
        FileUtil.safelyCloseFile(fileOutputStream);
        return;
        finally {
            writeLock.unlock();
            FileUtil.safelyCloseFile(fileOutputStream);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] readFileContents(String object) {
        ByteArrayOutputStream byteArrayOutputStream;
        FileInputStream fileInputStream;
        block6: {
            fileInputStream = null;
            byteArrayOutputStream = null;
            object = new File((String)object);
            if (((File)object).exists()) break block6;
            FileUtil.safelyCloseFile(null);
            FileUtil.safelyCloseFile(null);
            return null;
        }
        try {
            int n2;
            fileInputStream = new FileInputStream((File)object);
            object = new byte[1024];
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = fileInputStream.read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n2);
            }
            object = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                ha.b(throwable, TAG, "readFileContents");
                dx.a((Throwable)object);
                dz.b(dy.f, "read file from disk failed " + ((Throwable)object).getMessage());
            }
            catch (Throwable throwable2) {
                FileUtil.safelyCloseFile(byteArrayOutputStream);
                FileUtil.safelyCloseFile(fileInputStream);
                throw throwable2;
            }
            FileUtil.safelyCloseFile(byteArrayOutputStream);
            FileUtil.safelyCloseFile(fileInputStream);
            return null;
        }
        FileUtil.safelyCloseFile(byteArrayOutputStream);
        FileUtil.safelyCloseFile(fileInputStream);
        return object;
    }

    public static void saveFileContents(String object, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            object = new File((String)object);
            fileOutputStream = new FileOutputStream((File)object);
            fileOutputStream.write(byArray);
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                ha.b(throwable, TAG, "saveFileContents");
                dx.a((Throwable)object);
                dz.b(dy.f, "save file from disk failed " + ((Throwable)object).getMessage());
            }
            catch (Throwable throwable2) {
                FileUtil.safelyCloseFile(fileOutputStream);
                throw throwable2;
            }
            FileUtil.safelyCloseFile(fileOutputStream);
            return;
        }
        FileUtil.safelyCloseFile(fileOutputStream);
        return;
    }

    public static void createNoMediaFileIfNotExist(String string2) {
    }

    public static byte[] readFileContentsFromAssetsByPreName(Context context, String string2, String string3) {
        if (context == null || string2 == null || string3 == null) {
            return null;
        }
        String[] stringArray = context.getAssets();
        try {
            stringArray = stringArray.list(string2);
            if (stringArray == null) {
                return null;
            }
            for (String string4 : stringArray) {
                if (string4 == null || !string4.contains(string3)) continue;
                return FileUtil.readFileContentsFromAssets(context, string2 + "/" + string4);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static byte[] readFileContentsFromAssets(Context context, String object) {
        Object object2;
        int n2;
        InputStream inputStream;
        block8: {
            context = context.getAssets();
            inputStream = null;
            inputStream = context.open((String)object);
            n2 = inputStream.available();
            if (n2 != 0) break block8;
            FileUtil.safelyCloseFile(inputStream);
            return null;
        }
        try {
            object = new byte[n2];
            for (int i2 = 0; i2 < n2; i2 += inputStream.read((byte[])object, i2, n2 - i2)) {
            }
            object2 = object;
        }
        catch (IOException iOException) {
            dz.b(dy.f, "read file from assets failed " + iOException.getMessage());
            FileUtil.safelyCloseFile(inputStream);
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            dz.b(dy.f, "read file from assets failed " + outOfMemoryError.getMessage());
            {
                catch (Throwable throwable) {
                    FileUtil.safelyCloseFile(inputStream);
                    throw throwable;
                }
            }
            FileUtil.safelyCloseFile(inputStream);
            return null;
        }
        FileUtil.safelyCloseFile(inputStream);
        return object2;
    }

    public static String getName(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = FileUtil.indexOfLastSeparator(string2);
        return string2.substring(n2 + 1);
    }

    public static int indexOfLastSeparator(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n2 = string2.lastIndexOf(47);
        int n3 = string2.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static boolean isSafeEntryName(String string2) {
        return !string2.contains(FILE_PATH_ENTRY_BACK) && !string2.contains(FILE_PATH_ENTRY_SEPARATOR1) && !string2.contains(FILE_PATH_ENTRY_SEPARATOR2);
    }

    public static byte[] compress(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string2.getBytes(string3));
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                Log.e((String)"gzip compress error.", (String)iOException.getMessage());
            }
            catch (Throwable throwable) {
                FileUtil.safelyCloseFile(gZIPOutputStream);
                throw throwable;
            }
            FileUtil.safelyCloseFile(gZIPOutputStream);
        }
        FileUtil.safelyCloseFile(gZIPOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] compress(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                Log.e((String)"gzip compress error.", (String)iOException.getMessage());
            }
            catch (Throwable throwable) {
                FileUtil.safelyCloseFile(gZIPOutputStream);
                throw throwable;
            }
            FileUtil.safelyCloseFile(gZIPOutputStream);
        }
        FileUtil.safelyCloseFile(gZIPOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String uncompressToString(byte[] byArray) {
        return FileUtil.uncompressToString(byArray, "UTF-8");
    }

    public static String uncompressToString(byte[] object, String string2) {
        if (object == null || ((byte[])object).length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            inputStream = FileUtil.getZipInputStream(object);
            if (inputStream != null) {
                int n2;
                object = new byte[256];
                while ((n2 = inputStream.read((byte[])object)) >= 0) {
                    byteArrayOutputStream.write((byte[])object, 0, n2);
                }
                object = byteArrayOutputStream.toString(string2);
                return object;
            }
        }
        catch (IOException iOException) {
            Log.e((String)"gzip compress error.", (String)iOException.getMessage());
        }
        finally {
            FileUtil.safelyCloseFile(inputStream);
        }
        return null;
    }

    private static InputStream getZipInputStream(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (FileUtil.isGzip(byArray)) {
            return new GZIPInputStream(byteArrayInputStream);
        }
        return new ZipInputStream(byteArrayInputStream);
    }

    private static void safelyCloseFile(InputStream inputStream) {
        try {
            if (inputStream != null) {
                if (inputStream instanceof ZipInputStream) {
                    ((ZipInputStream)inputStream).closeEntry();
                }
                inputStream.close();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private static void safelyCloseFile(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private static byte[] readByteByStream(InputStream object) throws IOException {
        if (object == null) {
            return null;
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            object = byteArrayOutputStream.toByteArray();
            return object;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            FileUtil.safelyCloseFile(byteArrayOutputStream);
        }
    }

    public static Map<String, byte[]> uncompressToByteWithKeys(byte[] object, String[] stringArray) {
        HashMap<String, byte[]> hashMap;
        block16: {
            hashMap = new HashMap<String, byte[]>();
            if (object == null || ((byte[])object).length == 0) {
                return hashMap;
            }
            InputStream inputStream = null;
            try {
                Object object2;
                inputStream = FileUtil.getZipInputStream((byte[])object);
                if (!(inputStream instanceof ZipInputStream)) break block16;
                object = (ZipInputStream)inputStream;
                while ((object2 = ((ZipInputStream)object).getNextEntry()) != null) {
                    block18: {
                        if (!((ZipEntry)object2).isDirectory()) {
                            block17: {
                                object2 = ((ZipEntry)object2).getName();
                                if (FileUtil.isSafeEntryName((String)object2)) break block17;
                                Log.e((String)"gzip compress error.", (String)"gzip name contains ../ ".concat(String.valueOf(object2)));
                                return null;
                            }
                            try {
                                Object[] objectArray;
                                if (stringArray == null) {
                                    byte[] byArray = FileUtil.readByteByStream((InputStream)object);
                                    objectArray = byArray;
                                    if (byArray != null) {
                                        hashMap.put((String)object2, (byte[])objectArray);
                                    }
                                    break block18;
                                }
                                objectArray = stringArray;
                                int n2 = stringArray.length;
                                for (int i2 = 0; i2 < n2; ++i2) {
                                    String string2 = objectArray[i2];
                                    if (!((String)object2).equals(string2)) continue;
                                    byte[] byArray = FileUtil.readByteByStream((InputStream)object);
                                    object2 = byArray;
                                    if (byArray != null) {
                                        hashMap.put(string2, (byte[])object2);
                                    }
                                    break;
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                    ((ZipInputStream)object).closeEntry();
                }
            }
            catch (Throwable throwable) {
                Log.e((String)"gzip compress error.", (String)throwable.getMessage());
            }
            finally {
                FileUtil.safelyCloseFile(inputStream);
            }
        }
        return hashMap;
    }

    public static Pair<String, byte[]> uncompressToByte(byte[] object) {
        if (object == null || ((byte[])object).length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        String string2 = "";
        try {
            inputStream = FileUtil.getZipInputStream(object);
            if (inputStream instanceof ZipInputStream && !FileUtil.isSafeEntryName(string2 = ((ZipInputStream)inputStream).getNextEntry().getName())) {
                Log.e((String)"gzip compress error.", (String)"gzip name contains ../ ".concat(String.valueOf(string2)));
                return null;
            }
            if (inputStream != null) {
                int n2;
                object = new byte[256];
                while ((n2 = inputStream.read((byte[])object)) >= 0) {
                    byteArrayOutputStream.write((byte[])object, 0, n2);
                }
                object = new Pair((Object)string2, (Object)byteArrayOutputStream.toByteArray());
                return object;
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"gzip compress error.", (String)throwable.getMessage());
        }
        finally {
            FileUtil.safelyCloseFile(inputStream);
        }
        return null;
    }

    public static byte[] uncompress(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            inputStream = FileUtil.getZipInputStream(byArray);
            if (inputStream != null) {
                int n2;
                byArray = new byte[256];
                while ((n2 = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"gzip compress error.", (String)throwable.getMessage());
        }
        finally {
            FileUtil.safelyCloseFile(inputStream);
        }
        return null;
    }

    public static byte[] uncompressToByteArray(byte[] object) {
        if (object == null || ((byte[])object).length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object = new ByteArrayInputStream((byte[])object);
        GZIPInputStream gZIPInputStream = null;
        try {
            int n2;
            gZIPInputStream = new GZIPInputStream((InputStream)object);
            byte[] byArray = new byte[256];
            while ((n2 = gZIPInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            dx.a(throwable);
            throwable2.printStackTrace();
        }
        finally {
            GLFileUtil.closeQuietly(byteArrayOutputStream);
            GLFileUtil.closeQuietly((Closeable)object);
            GLFileUtil.closeQuietly(gZIPInputStream);
        }
        return null;
    }

    public static boolean isGzip(byte[] byArray) {
        return (byArray[0] << 8 | byArray[1] & 0xFF) == 8075;
    }

    public static void decompress(InputStream inputStream, String string2) throws Exception {
        FileUtil.decompress(inputStream, string2, 0L, null);
    }

    private static void decompress(InputStream inputStream, String string2, long l2, ZipCompressProgressListener zipCompressProgressListener) throws Exception {
        inputStream = new CheckedInputStream(inputStream, new CRC32());
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        FileUtil.decompress(null, new File(string2), zipInputStream, l2, zipCompressProgressListener, null);
        zipInputStream.close();
        ((FilterInputStream)inputStream).close();
    }

    private static void decompress(File file, File file2, ZipInputStream zipInputStream, long l2, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        ZipEntry zipEntry;
        int n2 = 0;
        boolean bl2 = false;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                zipInputStream.closeEntry();
                return;
            }
            Object object = zipEntry.getName();
            if (TextUtils.isEmpty((CharSequence)object) || !FileUtil.isSafeEntryName((String)object)) {
                bl2 = true;
                break;
            }
            object = file2.getPath() + File.separator + (String)object;
            object = new File((String)object);
            FileUtil.fileProber((File)object);
            if (zipEntry.isDirectory()) {
                ((File)object).mkdirs();
            } else {
                int n3 = FileUtil.decompressFile((File)object, zipInputStream, n2, l2, zipCompressProgressListener, unZipFileBrake);
                n2 += n3;
            }
            zipInputStream.closeEntry();
        }
        if (bl2) {
            try {
                if (file != null) {
                    file.delete();
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static void fileProber(File file) {
        if (!(file = file.getParentFile()).exists()) {
            FileUtil.fileProber(file);
            file.mkdir();
        }
    }

    private static int decompressFile(File object, ZipInputStream zipInputStream, long l2, long l3, ZipCompressProgressListener zipCompressProgressListener, UnZipFileBrake unZipFileBrake) throws Exception {
        int n2;
        int n3 = 0;
        object = new BufferedOutputStream(new FileOutputStream((File)object));
        byte[] byArray = new byte[1024];
        while ((n2 = zipInputStream.read(byArray, 0, 1024)) != -1) {
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) {
                ((FilterOutputStream)object).close();
                return n3;
            }
            ((BufferedOutputStream)object).write(byArray, 0, n2);
            n3 += n2;
            if (l3 <= 0L || zipCompressProgressListener == null) continue;
            long l4 = (l2 + (long)n3) * 100L / l3;
            if (unZipFileBrake != null && unZipFileBrake.mIsAborted) continue;
            zipCompressProgressListener.onFinishProgress(l4);
        }
        ((FilterOutputStream)object).close();
        return n3;
    }

    public static class UnZipFileBrake {
        public boolean mIsAborted = false;
    }

    public static interface ZipCompressProgressListener {
        public void onFinishProgress(long var1);
    }
}

