/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.content.Context;
import com.amap.api.col.3l.am;
import com.amap.api.col.3l.dq;
import com.amap.api.col.3l.du;
import com.amap.api.col.3l.ha;
import com.amap.api.maps.model.LatLng;

public class CoordinateConverter {
    private static final String TAG = "CoordinateConverter";
    private Context ctx;
    private CoordType coordType = null;
    private LatLng sourceLatLng = null;

    public CoordinateConverter(Context context) {
        this.ctx = context;
    }

    public CoordinateConverter from(CoordType coordType) {
        this.coordType = coordType;
        return this;
    }

    public CoordinateConverter coord(LatLng latLng) {
        this.sourceLatLng = latLng;
        return this;
    }

    public LatLng convert() {
        if (this.coordType == null) {
            return null;
        }
        if (this.sourceLatLng == null) {
            return null;
        }
        LatLng latLng = null;
        try {
            String string2 = "";
            switch (this.coordType) {
                case BAIDU: {
                    latLng = am.a(this.sourceLatLng);
                    string2 = "baidu";
                    break;
                }
                case MAPBAR: {
                    latLng = am.b(this.ctx, this.sourceLatLng);
                    string2 = "mapbar";
                    break;
                }
                case MAPABC: {
                    string2 = "mapabc";
                    latLng = this.sourceLatLng;
                    break;
                }
                case SOSOMAP: {
                    string2 = "sosomap";
                    latLng = this.sourceLatLng;
                    break;
                }
                case ALIYUN: {
                    string2 = "aliyun";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GOOGLE: {
                    string2 = "google";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GPS: {
                    string2 = "gps";
                    latLng = am.a(this.ctx, this.sourceLatLng);
                }
            }
            du.a(this.ctx, string2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            ha.b(throwable2, TAG, "convert");
            latLng = this.sourceLatLng;
        }
        return latLng;
    }

    public static boolean isAMapDataAvailable(double d2, double d3) {
        return dq.a(d2, d3);
    }

    public static enum CoordType {
        BAIDU,
        MAPBAR,
        GPS,
        MAPABC,
        SOSOMAP,
        ALIYUN,
        GOOGLE;

    }
}

