/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.PixelUtils;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Random;

public class NoiseFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 1970783813893879484L;
    private int amount = 25;
    private boolean gaussian = false;
    private boolean monochrome = false;
    private Random randomNumbers = new Random();

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setGaussian(boolean gaussian) {
        this.gaussian = gaussian;
    }

    public boolean getGaussian() {
        return this.gaussian;
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    public boolean getMonochrome() {
        return this.monochrome;
    }

    private int random(int x) {
        if ((x += (int)((this.gaussian ? this.randomNumbers.nextGaussian() : (double)(2.0f * this.randomNumbers.nextFloat() - 1.0f)) * (double)this.amount)) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        return x;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int a = rgb & 0xFF000000;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        if (this.monochrome) {
            int n = (int)((this.gaussian ? this.randomNumbers.nextGaussian() : (double)(2.0f * this.randomNumbers.nextFloat() - 1.0f)) * (double)this.amount);
            r = PixelUtils.clamp(r + n);
            g = PixelUtils.clamp(g + n);
            b = PixelUtils.clamp(b + n);
        } else {
            r = this.random(r);
            g = this.random(g);
            b = this.random(b);
        }
        return a | r << 16 | g << 8 | b;
    }

    public String toString() {
        return "Stylize/Add Noise...";
    }
}

