/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.BinaryFilter;

public class LifeFilter
extends BinaryFilter {
    @Override
    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int[] outPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                boolean r = false;
                boolean g = false;
                boolean b = false;
                int pixel = this.inPixels[y * width + x];
                int a = pixel & 0xFF000000;
                int neighbours = 0;
                for (int row = -1; row <= 1; ++row) {
                    int iy = y + row;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int col = -1; col <= 1; ++col) {
                        int rgb;
                        int ix = x + col;
                        if (row == 0 && col == 0 || 0 > ix || ix >= width || !this.blackFunction.isBlack(rgb = this.inPixels[ioffset + ix])) continue;
                        ++neighbours;
                    }
                }
                if (this.blackFunction.isBlack(pixel)) {
                    outPixels[index++] = neighbours == 2 || neighbours == 3 ? pixel : -1;
                    continue;
                }
                outPixels[index++] = neighbours == 3 ? -16777216 : pixel;
            }
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Binary/Life";
    }
}

