/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.UnixFileSystem;
import com.alkacon.simapi.CmykJpegReader.Win32FileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

abstract class FileSystem {
    FileSystem() {
    }

    abstract long getFreeSpace(File var1);

    abstract long getTotalSpace(File var1);

    abstract String getName();

    static BufferedReader exec(String[] pArgs) throws IOException {
        Process cmd = Runtime.getRuntime().exec(pArgs);
        return new BufferedReader(new InputStreamReader(cmd.getInputStream()));
    }

    static FileSystem get() {
        String os = System.getProperty("os.name");
        if ((os = os.toLowerCase()).contains("windows")) {
            return new Win32FileSystem();
        }
        if (os.contains("linux") || os.contains("sun os") || os.contains("sunos") || os.contains("solaris") || os.contains("mpe/ix") || os.contains("hp-ux") || os.contains("aix") || os.contains("freebsd") || os.contains("irix") || os.contains("digital unix") || os.contains("unix") || os.contains("mac os x")) {
            return new UnixFileSystem();
        }
        return new UnknownFileSystem(os);
    }

    private static class UnknownFileSystem
    extends FileSystem {
        private final String osName;

        UnknownFileSystem(String pOSName) {
            this.osName = pOSName;
        }

        @Override
        long getFreeSpace(File pPath) {
            return 0L;
        }

        @Override
        long getTotalSpace(File pPath) {
            return 0L;
        }

        @Override
        String getName() {
            return "Unknown (" + this.osName + ")";
        }
    }
}

