/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.lease.Lease;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseManager;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseRenewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseRenewer<T extends Lease>
implements ILeaseRenewer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseRenewer.class);
    private final ILeaseManager<T> leaseManager;
    private final String workerIdentifier;
    private final long leaseDurationMillis;
    private final ConcurrentNavigableMap<String, T> ownedLeases = new ConcurrentSkipListMap<String, T>();
    private final ExecutorService executorService;

    public LeaseRenewer(ILeaseManager<T> leaseManager, String workerIdentifier, long leaseDurationMillis, ExecutorService executorService) {
        this.leaseManager = leaseManager;
        this.workerIdentifier = workerIdentifier;
        this.leaseDurationMillis = leaseDurationMillis;
        this.executorService = executorService;
    }

    @Override
    public void renewLeases() throws StreamClientException, DependencyException {
        LOG.debug("Start renew leases.");
        this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LeaseRenewer.this.findStealer();
                return null;
            }
        });
        for (final Lease lease : this.ownedLeases.descendingMap().values()) {
            this.executorService.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return LeaseRenewer.this.renewLease(lease, false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findStealer() throws StreamClientException, DependencyException {
        LOG.debug("Start find stealer.");
        List<T> newList = this.leaseManager.listLeases();
        for (Lease lease : newList) {
            String leaseKey = lease.getLeaseKey();
            Lease ownedLease = (Lease)this.ownedLeases.get(leaseKey);
            if (ownedLease == null) continue;
            Lease lease2 = ownedLease;
            synchronized (lease2) {
                if (ownedLease.getLeaseStealer().isEmpty() && !lease.getLeaseStealer().isEmpty() && lease.getLeaseCounter() == ownedLease.getLeaseCounter()) {
                    LOG.info("Stealer found. LeaseKey: {}, Stealer: {}.", (Object)lease.getLeaseKey(), (Object)lease.getLeaseStealer());
                    ownedLease.setLeaseStealer(lease.getLeaseStealer());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renewLease(T lease, boolean renewEvenIfExpired) throws StreamClientException, DependencyException {
        LOG.debug("Start renew lease: {}", lease);
        long now = System.currentTimeMillis();
        boolean renewedLease = false;
        T t = lease;
        synchronized (t) {
            if (renewEvenIfExpired || !((Lease)lease).isExpired(this.leaseDurationMillis, now)) {
                renewedLease = this.leaseManager.renewLease(lease);
                if (!renewedLease) {
                    LOG.info("Lease renew failed: {}.", lease);
                }
            } else {
                LOG.info("Lease is expired: {}, now: {}.", lease, (Object)now);
            }
        }
        if (renewedLease) {
            LOG.debug("Renew lease, Lease: {}.", lease);
            ((Lease)lease).setLastCounterIncrementMillis(System.currentTimeMillis());
        } else {
            LOG.error("Lease is lost, Lease: {}.", lease);
            this.ownedLeases.remove(((Lease)lease).getLeaseKey());
        }
        return renewedLease;
    }

    @Override
    public Map<String, T> getCurrentlyHeldLeases() {
        HashMap result = new HashMap();
        long now = System.currentTimeMillis();
        for (Map.Entry entry : this.ownedLeases.entrySet()) {
            Lease lease = (Lease)entry.getValue();
            if (lease == null || lease.isExpired(this.leaseDurationMillis, now)) continue;
            Object copy = lease.copy();
            result.put(((Lease)copy).getLeaseKey(), copy);
        }
        return result;
    }

    @Override
    public T getCurrentlyHeldLease(String leaseKey) {
        Lease lease = (Lease)this.ownedLeases.get(leaseKey);
        long now = System.currentTimeMillis();
        if (lease == null || lease.isExpired(this.leaseDurationMillis, now)) {
            return null;
        }
        return lease.copy();
    }

    @Override
    public void addLeasesToRenew(Collection<T> newLeases) {
        for (Lease lease : newLeases) {
            Object copy = lease.copy();
            ((Lease)copy).setLeaseIdentifier(UUID.randomUUID().toString());
            LOG.info("New lease added: {}", copy);
            this.ownedLeases.put(((Lease)copy).getLeaseKey(), copy);
        }
    }

    @Override
    public void clearCurrentlyHeldLeases() {
        this.ownedLeases.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLease(T lease, String leaseIdentifier) throws StreamClientException, DependencyException {
        LOG.debug("Start update lease. Lease: {}, LeaseIdentifier: {}.", lease, (Object)leaseIdentifier);
        String leaseKey = ((Lease)lease).getLeaseKey();
        Lease ownedLease = (Lease)this.ownedLeases.get(leaseKey);
        LOG.debug("Owned lease to update: {}.", (Object)ownedLease);
        if (ownedLease == null) {
            return false;
        }
        if (!ownedLease.getLeaseIdentifier().equals(leaseIdentifier)) {
            LOG.error("Try update lease but identifier mismatch. OwnedLease: {}, LeaseToUpdate: {}.", (Object)ownedLease, lease);
            return false;
        }
        Lease lease2 = ownedLease;
        synchronized (lease2) {
            ownedLease.update(lease);
            boolean updatedLease = this.leaseManager.updateLease(ownedLease);
            if (updatedLease) {
                ownedLease.setLastCounterIncrementMillis(System.currentTimeMillis());
            } else {
                LOG.info("UpdateLease: lease is lost. Lease: {}", lease);
                this.ownedLeases.remove(leaseKey, ownedLease);
            }
            return updatedLease;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transferLease(String leaseKey, String leaseIdentifier) throws StreamClientException, DependencyException {
        LOG.debug("Start transfer lease. LeaseKey: {}, LeaseIdentifier: {}.", (Object)leaseKey, (Object)leaseIdentifier);
        Lease ownedLease = (Lease)this.ownedLeases.get(leaseKey);
        if (ownedLease == null) {
            return false;
        }
        if (!ownedLease.getLeaseIdentifier().equals(leaseIdentifier)) {
            LOG.error("Try transfer lease but identifier mismatch. OwnedLease: {}, LeaseIdentifier: {}.", (Object)ownedLease, (Object)leaseIdentifier);
            return false;
        }
        Lease lease = ownedLease;
        synchronized (lease) {
            if (this.ownedLeases.remove(ownedLease.getLeaseKey(), ownedLease)) {
                LOG.info("Lease is removed from owned leases map and start to transfer. Lease: {}.", (Object)ownedLease);
                return this.leaseManager.transferLease(ownedLease);
            }
            return false;
        }
    }

    @Override
    public void initialize() throws StreamClientException, DependencyException {
        List<T> leases = this.leaseManager.listLeases();
        ArrayList<Lease> myLeases = new ArrayList<Lease>();
        for (Lease lease : leases) {
            if (!this.workerIdentifier.equals(lease.getLeaseOwner())) continue;
            LOG.info("Found a lease owned by this worker. Lease: {}, Worker: {}.", (Object)lease, (Object)this.workerIdentifier);
            if (!this.renewLease(lease, true)) continue;
            LOG.info("Successfully take lease: {}.", (Object)lease);
            myLeases.add(lease);
        }
        this.addLeasesToRenew(myLeases);
    }
}

