/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.lease.AbstractLeaseSerializer;
import com.aliyun.openservices.ots.internal.streamclient.lease.Lease;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseManager;
import com.aliyun.openservices.ots.internal.streamclient.model.IRetryStrategy;
import com.aliyun.openservices.ots.internal.streamclient.model.RetryingCallableDecorator;
import com.aliyun.openservices.ots.internal.streamclient.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseManager<T extends Lease>
implements ILeaseManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseManager.class);
    private static final String OBJECT_ALREADY_EXIST = "OTSObjectAlreadyExist";
    private static final String TABLE_NOT_READY = "OTSTableNotReady";
    private static final String OTS_PARTITION_UNAVAILABLE = "OTSPartitionUnavailable";
    private static final String OTS_CONDITION_CHECK_FAIL = "OTSConditionCheckFail";
    private final SyncClientInterface ots;
    private final String tableName;
    private final AbstractLeaseSerializer<T> serializer;
    private final IRetryStrategy retryStrategy;
    private final long checkTableReadyIntervalMillis;

    public LeaseManager(SyncClientInterface ots, String tableName, AbstractLeaseSerializer<T> serializer, IRetryStrategy retryStrategy, long checkTableReadyIntervalMillis) {
        this.ots = ots;
        this.tableName = tableName;
        this.serializer = serializer;
        this.retryStrategy = retryStrategy;
        this.checkTableReadyIntervalMillis = checkTableReadyIntervalMillis;
    }

    @Override
    public boolean createLeaseTableIfNotExists(int readCU, int writeCU, int ttl) throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<Boolean>(IRetryStrategy.RetryableAction.LEASE_ACTION_CREATE_TABLE_IF_NOT_EXISTS, this.retryStrategy, this.createLeaseTableIfNotExistsCallable(readCU, writeCU, ttl)).call();
    }

    @Override
    public boolean waitUntilTableReady(long maxWaitTimeMillis) throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<Boolean>(IRetryStrategy.RetryableAction.LEASE_ACTION_WAIT_UNTIL_TABLE_READY, this.retryStrategy, this.waitUntilTableReadyCallable(maxWaitTimeMillis)).call();
    }

    @Override
    public List<T> listLeases() throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<List<T>>(IRetryStrategy.RetryableAction.LEASE_ACTION_LIST_LEASES, this.retryStrategy, this.listLeasesCallable()).call();
    }

    @Override
    public void createLease(T lease) throws StreamClientException, DependencyException {
        new RetryingCallableDecorator<Void>(IRetryStrategy.RetryableAction.LEASE_ACTION_CREATE_LEASE, this.retryStrategy, this.createLeaseCallable(lease)).call();
    }

    @Override
    public T getLease(String leaseKey) throws StreamClientException, DependencyException {
        return (T)((Lease)new RetryingCallableDecorator<T>(IRetryStrategy.RetryableAction.LEASE_ACTION_GET_LEASE, this.retryStrategy, this.getLeaseCallable(leaseKey)).call());
    }

    @Override
    public boolean renewLease(T lease) throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<Boolean>(IRetryStrategy.RetryableAction.LEASE_ACTION_RENEW_LEASE, this.retryStrategy, this.renewLeaseCallable(lease)).call();
    }

    @Override
    public boolean takeLease(T lease, String owner) throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<Boolean>(IRetryStrategy.RetryableAction.LEASE_ACTION_TAKE_LEASE, this.retryStrategy, this.takeLeaseCallable(lease, owner)).call();
    }

    @Override
    public boolean stealLease(T lease, String stealer) throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<Boolean>(IRetryStrategy.RetryableAction.LEASE_ACTION_STEAL_LEASE, this.retryStrategy, this.stealLeaseCallable(lease, stealer)).call();
    }

    @Override
    public boolean transferLease(T lease) throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<Boolean>(IRetryStrategy.RetryableAction.LEASE_ACTION_TRANSFER_LEASE, this.retryStrategy, this.transferLeaseCallable(lease)).call();
    }

    @Override
    public void deleteLease(String leaseKey) throws StreamClientException, DependencyException {
        new RetryingCallableDecorator<Void>(IRetryStrategy.RetryableAction.LEASE_ACTION_DELETE_LEASE, this.retryStrategy, this.deleteLeaseCallable(leaseKey)).call();
    }

    @Override
    public boolean updateLease(T lease) throws StreamClientException, DependencyException {
        return new RetryingCallableDecorator<Boolean>(IRetryStrategy.RetryableAction.LEASE_ACTION_UPDATE_LEASE, this.retryStrategy, this.updateLeaseCallable(lease)).call();
    }

    private Callable<Boolean> createLeaseTableIfNotExistsCallable(final int readCU, final int writeCU, final int ttl) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ListTableResponse listTableResult = LeaseManager.this.ots.listTable();
                if (listTableResult.getTableNames().contains(LeaseManager.this.tableName)) {
                    return false;
                }
                boolean tableNotExist = true;
                try {
                    LeaseManager.this.ots.createTable(LeaseManager.this.serializer.getCreateTableRequest(readCU, writeCU, ttl));
                }
                catch (TableStoreException ex) {
                    if (ex.getErrorCode().equals(LeaseManager.OBJECT_ALREADY_EXIST)) {
                        tableNotExist = false;
                    }
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
                return tableNotExist;
            }
        };
    }

    public Callable<Boolean> waitUntilTableReadyCallable(final long maxWaitTimeMillis) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTime < maxWaitTimeMillis) {
                    String leaseKeyToGet = "NotExistLease";
                    GetRowRequest getRowRequest = LeaseManager.this.serializer.getGetRowRequest(leaseKeyToGet);
                    try {
                        LeaseManager.this.ots.getRow(getRowRequest);
                        return true;
                    }
                    catch (TableStoreException ex) {
                        if (!ex.getErrorCode().equals(LeaseManager.OTS_PARTITION_UNAVAILABLE) && !ex.getErrorCode().equals(LeaseManager.TABLE_NOT_READY)) {
                            throw new DependencyException(ex.getMessage(), ex);
                        }
                    }
                    catch (ClientException ex) {
                        throw new DependencyException(ex.getMessage(), ex);
                    }
                    TimeUtils.sleepMillis(LeaseManager.this.checkTableReadyIntervalMillis);
                }
                return false;
            }
        };
    }

    public Callable<List<T>> listLeasesCallable() {
        return new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                try {
                    Iterator iterator = LeaseManager.this.ots.createRangeIterator(LeaseManager.this.serializer.getRangeIteratorParameter());
                    ArrayList list = new ArrayList();
                    while (iterator.hasNext()) {
                        Object lease = LeaseManager.this.serializer.fromOTSRow((Row)iterator.next());
                        if (lease == null) continue;
                        list.add(lease);
                    }
                    return list;
                }
                catch (TableStoreException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<Void> createLeaseCallable(final T lease) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    PutRowRequest putRowRequest = LeaseManager.this.serializer.getPutRowRequest(lease);
                    LeaseManager.this.ots.putRow(putRowRequest);
                    return null;
                }
                catch (TableStoreException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<T> getLeaseCallable(final String leaseKey) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    GetRowRequest getRowRequest = LeaseManager.this.serializer.getGetRowRequest(leaseKey);
                    Row row = LeaseManager.this.ots.getRow(getRowRequest).getRow();
                    if (row == null) {
                        return null;
                    }
                    return LeaseManager.this.serializer.fromOTSRow(row);
                }
                catch (TableStoreException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<Boolean> renewLeaseCallable(final T lease) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    UpdateRowRequest updateRowRequest = LeaseManager.this.serializer.getUpdateRowRequestForRenew(lease);
                    LeaseManager.this.ots.updateRow(updateRowRequest);
                    lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
                    return true;
                }
                catch (TableStoreException ex) {
                    if (ex.getErrorCode().equals(LeaseManager.OTS_CONDITION_CHECK_FAIL)) {
                        return false;
                    }
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<Boolean> takeLeaseCallable(final T lease, final String owner) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    UpdateRowRequest updateRowRequest = LeaseManager.this.serializer.getUpdateRowRequestForTake(lease, owner);
                    LeaseManager.this.ots.updateRow(updateRowRequest);
                    lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
                    lease.setLeaseOwner(owner);
                    lease.setLeaseStealer("");
                    return true;
                }
                catch (TableStoreException ex) {
                    if (ex.getErrorCode().equals(LeaseManager.OTS_CONDITION_CHECK_FAIL)) {
                        return false;
                    }
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<Boolean> stealLeaseCallable(final T lease, final String stealer) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    UpdateRowRequest updateRowRequest = LeaseManager.this.serializer.getUpdateRowRequestForSteal(lease, stealer);
                    LeaseManager.this.ots.updateRow(updateRowRequest);
                    lease.setLeaseStealer(stealer);
                    return true;
                }
                catch (TableStoreException ex) {
                    if (ex.getErrorCode().equals(LeaseManager.OTS_CONDITION_CHECK_FAIL)) {
                        return false;
                    }
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<Boolean> transferLeaseCallable(final T lease) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (lease.getLeaseStealer() == null || lease.getLeaseStealer().equals("")) {
                    return false;
                }
                try {
                    UpdateRowRequest updateRowRequest = LeaseManager.this.serializer.getUpdateRowRequestForTransfer(lease);
                    LeaseManager.this.ots.updateRow(updateRowRequest);
                    lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
                    lease.setLeaseOwner(lease.getLeaseStealer());
                    return true;
                }
                catch (TableStoreException ex) {
                    if (ex.getErrorCode().equals(LeaseManager.OTS_CONDITION_CHECK_FAIL)) {
                        return false;
                    }
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<Void> deleteLeaseCallable(final String leaseKey) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    DeleteRowRequest deleteRowRequest = LeaseManager.this.serializer.getDeleteRowRequest(leaseKey);
                    LeaseManager.this.ots.deleteRow(deleteRowRequest);
                    return null;
                }
                catch (TableStoreException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }

    public Callable<Boolean> updateLeaseCallable(final T lease) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    UpdateRowRequest updateRowRequest = LeaseManager.this.serializer.getUpdateRowRequestForUpdate(lease);
                    LeaseManager.this.ots.updateRow(updateRowRequest);
                    lease.setLeaseCounter(lease.getLeaseCounter() + 1L);
                    return true;
                }
                catch (TableStoreException ex) {
                    if (ex.getErrorCode().equals(LeaseManager.OTS_CONDITION_CHECK_FAIL)) {
                        return false;
                    }
                    throw new DependencyException(ex.getMessage(), ex);
                }
                catch (ClientException ex) {
                    throw new DependencyException(ex.getMessage(), ex);
                }
            }
        };
    }
}

