/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common;

import android.util.Log;
import com.alibaba.sdk.android.oss.common.OSSLogToFileUtils;

public class OSSLog {
    private static final String TAG = "OSS-Android-SDK";
    private static boolean enableLog = false;

    public static void enableLog() {
        enableLog = true;
    }

    public static void disableLog() {
        enableLog = false;
    }

    public static boolean isEnableLog() {
        return enableLog;
    }

    public static void logInfo(String msg) {
        OSSLog.logInfo(msg, true);
    }

    public static void logInfo(String msg, boolean write2local) {
        if (enableLog) {
            Log.i((String)TAG, (String)msg);
            OSSLog.log2Local(msg, write2local);
        }
    }

    public static void logVerbose(String msg) {
        OSSLog.logVerbose(msg, true);
    }

    public static void logVerbose(String msg, boolean write2local) {
        if (enableLog) {
            Log.v((String)TAG, (String)msg);
            OSSLog.log2Local(msg, write2local);
        }
    }

    public static void logWarn(String msg) {
        OSSLog.logWarn(msg, true);
    }

    public static void logWarn(String msg, boolean write2local) {
        if (enableLog) {
            Log.w((String)TAG, (String)msg);
            OSSLog.log2Local(msg, write2local);
        }
    }

    public static void logDebug(String msg) {
        OSSLog.logDebug(TAG, msg);
    }

    public static void logDebug(String tag, String msg) {
        OSSLog.logDebug(tag, msg, true);
    }

    public static void logDebug(String msg, boolean write2local) {
        OSSLog.logDebug(TAG, msg, write2local);
    }

    public static void logDebug(String tag, String msg, boolean write2local) {
        if (enableLog) {
            Log.d((String)tag, (String)msg);
            OSSLog.log2Local(msg, write2local);
        }
    }

    public static void logError(String msg) {
        OSSLog.logError(TAG, msg);
    }

    public static void logError(String tag, String msg) {
        OSSLog.logDebug(tag, msg, true);
    }

    public static void logError(String msg, boolean write2local) {
        OSSLog.logError(TAG, msg, write2local);
    }

    public static void logError(String tag, String msg, boolean write2local) {
        if (enableLog) {
            Log.d((String)tag, (String)msg);
            OSSLog.log2Local(msg, write2local);
        }
    }

    public static void logThrowable2Local(Throwable throwable) {
        if (enableLog) {
            OSSLogToFileUtils.getInstance().write(throwable);
        }
    }

    private static void log2Local(String msg, boolean write2local) {
        if (write2local) {
            OSSLogToFileUtils.getInstance().write(msg);
        }
    }
}

