/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.sse;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpResponseHandler;
import darabonba.core.ResponseBytes;
import darabonba.core.async.AsyncResponseHandler;
import darabonba.core.async.ByteArrayAsyncResponseHandler;
import darabonba.core.sse.Event;
import darabonba.core.sse.SSEResponseIterator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SSEHttpResponseHandler
implements HttpResponseHandler {
    private volatile AsyncResponseHandler<?, ?> handler = new ByteArrayAsyncResponseHandler();
    private static final String symbol = "\\r\\n\\r\\n|\\r\\r|\\n\\n";
    private static final Pattern pattern = Pattern.compile("\\r\\n\\r\\n|\\r\\r|\\n\\n");
    private final SSEResponseIterator<?> iterator;
    private volatile AsyncResponseHandler<String, ResponseBytes<String>> errorAsyncResponseHandler;

    public SSEHttpResponseHandler(SSEResponseIterator<?> iterator) {
        this.iterator = iterator;
    }

    public void onStream(Publisher<ByteBuffer> publisher, int httpStatusCode, HttpHeaders headers) {
        this.iterator.setStatusCode(httpStatusCode);
        this.iterator.setHeaders(headers.toMap());
        if (httpStatusCode / 100 != 2) {
            this.errorAsyncResponseHandler = AsyncResponseHandler.toBytes();
            this.errorAsyncResponseHandler.onStream(publisher);
        } else {
            SSEProcessor proc = new SSEProcessor(this.iterator);
            this.handler.onStream((Publisher<ByteBuffer>)proc);
            publisher.subscribe((Subscriber)proc);
        }
    }

    public void onError(Throwable throwable) {
        this.iterator.endOfFailure(throwable);
        this.handler.onError(throwable);
    }

    public byte[] getErrorBodyByteArrayUnsafe() {
        if (this.errorAsyncResponseHandler == null) {
            return null;
        }
        ResponseBytes<String> result = this.errorAsyncResponseHandler.transform("");
        return result.asByteArrayUnsafe();
    }

    public byte[] getErrorBodyByteArray() {
        if (this.errorAsyncResponseHandler == null) {
            return null;
        }
        ResponseBytes<String> result = this.errorAsyncResponseHandler.transform("");
        return result.asByteArray();
    }

    static class SSEProcessor
    implements Processor<ByteBuffer, ByteBuffer> {
        protected volatile Subscriber<? super ByteBuffer> subscriber;
        private final StringBuffer stringBuilder = new StringBuffer();
        private final SSEResponseIterator<?> iterator;

        SSEProcessor(SSEResponseIterator<?> iterator) {
            this.iterator = iterator;
        }

        public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        public void onNext(ByteBuffer byteBuffer) {
            try {
                if (byteBuffer.hasRemaining()) {
                    String data = new String(byteBuffer.array(), StandardCharsets.UTF_8);
                    Matcher m = pattern.matcher(data);
                    if (m.find()) {
                        String[] list = data.split(SSEHttpResponseHandler.symbol, -1);
                        for (int i = 0; i <= list.length - 1; ++i) {
                            String event = list[i];
                            if (i == list.length - 1) {
                                this.stringBuilder.append(event);
                                continue;
                            }
                            this.iterator.addEvent(Event.parse(this.stringBuilder.append(event).toString()));
                            this.stringBuilder.setLength(0);
                        }
                    } else {
                        this.stringBuilder.append(data);
                    }
                }
                this.subscriber.onNext((Object)byteBuffer);
            }
            catch (Exception e) {
                this.iterator.endOfFailure(e);
                this.subscriber.onError((Throwable)e);
            }
        }

        public void onError(Throwable throwable) {
            this.iterator.endOfFailure(throwable);
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            this.iterator.endOfEvent();
            this.subscriber.onComplete();
        }
    }
}

