/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.utils;

import com.aliyuncs.utils.Base64Helper;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class ParameterHelper {
    private static final String TIME_ZONE = "GMT";
    private static final String FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String FORMAT_RFC2616 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN = "^[a-zA-Z0-9_-]+$";
    private static AtomicLong seqId = new AtomicLong(0L);
    private static final long processStartTime = System.currentTimeMillis();

    public static String getUniqueNonce() {
        long threadId = Thread.currentThread().getId();
        long currentTime = System.currentTimeMillis();
        Random random = new Random();
        long seq = seqId.getAndIncrement();
        long rand = random.nextLong();
        StringBuffer sb = new StringBuffer();
        sb.append(processStartTime).append('-').append(threadId).append('-').append(currentTime).append('-').append(seq).append('-').append(rand);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] msg = sb.toString().getBytes();
            sb.setLength(0);
            for (byte b : digest.digest(msg)) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() < 2) {
                    sb.append(0);
                }
                sb.append(hex);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return sb.toString();
    }

    public static void validateParameter(String parameter, String parameterName) {
        if (null == parameter || "".equals(parameter.trim())) {
            return;
        }
        if (Pattern.matches(PATTERN, parameter)) {
            return;
        }
        throw new RuntimeException("The parameter " + parameterName + " not match with " + PATTERN);
    }

    public static String getISO8601Time(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_ISO8601);
        df.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        return df.format(date);
    }

    public static String getRFC2616Date(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_RFC2616, Locale.ENGLISH);
        df.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        return df.format(date);
    }

    public static Date parse(String strDate) throws ParseException {
        if (null == strDate || "".equals(strDate)) {
            return null;
        }
        if (strDate.length() == FORMAT_ISO8601.length() - 4) {
            return ParameterHelper.parseISO8601(strDate);
        }
        if (strDate.length() == FORMAT_RFC2616.length()) {
            return ParameterHelper.parseRFC2616(strDate);
        }
        return null;
    }

    public static Date parseISO8601(String strDate) throws ParseException {
        if (null == strDate || "".equals(strDate)) {
            return null;
        }
        if (strDate.length() != FORMAT_ISO8601.length() - 4) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_ISO8601);
        df.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        return df.parse(strDate);
    }

    public static Date parseRFC2616(String strDate) throws ParseException {
        if (null == strDate || "".equals(strDate) || strDate.length() != FORMAT_RFC2616.length()) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_RFC2616, Locale.ENGLISH);
        df.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        return df.parse(strDate);
    }

    public static String md5Sum(byte[] buff) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(buff);
            return Base64Helper.encode(messageDigest);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getXmlData(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            xml.append("<" + entry.getKey() + ">");
            xml.append(entry.getValue());
            xml.append("</" + entry.getKey() + ">");
        }
        return xml.toString().getBytes("UTF-8");
    }

    public static byte[] getJsonData(Map<String, String> params) throws UnsupportedEncodingException {
        String json = new Gson().toJson(params);
        return json.getBytes("UTF-8");
    }

    public static byte[] getFormData(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString().getBytes("UTF-8");
    }
}

