/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.policy.retry.conditions;

import com.aliyuncs.policy.retry.RetryPolicyContext;
import com.aliyuncs.policy.retry.conditions.RetryCondition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ExceptionsCondition
implements RetryCondition {
    private final Set<Class<? extends Exception>> exceptionsToRetryOn;

    private ExceptionsCondition(Set<Class<? extends Exception>> exceptionsToRetryOn) {
        this.exceptionsToRetryOn = new HashSet<Class<? extends Exception>>(exceptionsToRetryOn);
    }

    @Override
    public boolean meetState(RetryPolicyContext context) {
        Throwable exception = context.exception();
        if (exception == null) {
            return false;
        }
        for (Class<? extends Exception> ex : this.exceptionsToRetryOn) {
            if (!ex.isAssignableFrom(exception.getClass()) && (exception.getCause() == null || !ex.isAssignableFrom(exception.getCause().getClass()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int escapeTime(RetryPolicyContext context) {
        return -1;
    }

    public static ExceptionsCondition create(Set<Class<? extends Exception>> exceptionsToRetryOn) {
        return new ExceptionsCondition(exceptionsToRetryOn);
    }

    public static ExceptionsCondition create(Class<? extends Exception> ... exceptionsToRetryOn) {
        return new ExceptionsCondition(new HashSet<Class<? extends Exception>>(Arrays.asList(exceptionsToRetryOn)));
    }
}

