/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.BearerTokenCredentials;
import com.aliyuncs.auth.KeyPairCredentials;
import com.aliyuncs.auth.SignatureVersion;
import com.aliyuncs.auth.signers.BearerTokenSigner;
import com.aliyuncs.auth.signers.HmacSHA1Signer;
import com.aliyuncs.auth.signers.HmacSHA256Signer;
import com.aliyuncs.auth.signers.HmacSM3Signer;
import com.aliyuncs.auth.signers.NewSHA256withRSASigner;
import com.aliyuncs.auth.signers.SHA256withRSASigner;
import com.aliyuncs.auth.signers.SignatureAlgorithm;
import java.security.NoSuchAlgorithmException;

public abstract class Signer {
    private static final Signer HMACSHA1_SIGNER = new HmacSHA1Signer();
    private static final Signer SHA256_WITH_RSA_SIGNER = new SHA256withRSASigner();
    private static final Signer BEARER_TOKEN_SIGNER = new BearerTokenSigner();
    private static final Signer RSA_SHA256 = new NewSHA256withRSASigner();
    private static final Signer HMAC_SM3 = new HmacSM3Signer();
    private static final Signer HMAC_SHA256 = new HmacSHA256Signer();

    public static Signer getSigner(AlibabaCloudCredentials credentials) {
        if (credentials instanceof KeyPairCredentials) {
            return SHA256_WITH_RSA_SIGNER;
        }
        if (credentials instanceof BearerTokenCredentials) {
            return BEARER_TOKEN_SIGNER;
        }
        return HMACSHA1_SIGNER;
    }

    public static Signer getSigner(AlibabaCloudCredentials credentials, SignatureVersion signatureVersion, SignatureAlgorithm signatureAlgorithm) {
        switch (signatureVersion) {
            case V3: {
                switch (signatureAlgorithm) {
                    case ACS3_RSA_SHA256: {
                        return RSA_SHA256;
                    }
                    case ACS3_HMAC_SM3: {
                        return HMAC_SM3;
                    }
                    case ACS3_HMAC_SHA256: {
                        return HMAC_SHA256;
                    }
                }
            }
        }
        if (credentials instanceof KeyPairCredentials) {
            return SHA256_WITH_RSA_SIGNER;
        }
        if (credentials instanceof BearerTokenCredentials) {
            return BEARER_TOKEN_SIGNER;
        }
        return HMACSHA1_SIGNER;
    }

    public abstract String signString(String var1, AlibabaCloudCredentials var2);

    public abstract String signString(String var1, String var2);

    public abstract String getSignerName();

    public abstract String getSignerVersion();

    public abstract String getSignerType();

    public abstract byte[] hash(byte[] var1) throws NoSuchAlgorithmException;

    public abstract String getContent();
}

