/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.CLIProfileCredentialsProvider;
import com.aliyuncs.auth.EnvironmentVariableCredentialsProvider;
import com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.auth.OIDCCredentialsProvider;
import com.aliyuncs.auth.ProfileCredentialsProvider;
import com.aliyuncs.auth.SystemPropertiesCredentialsProvider;
import com.aliyuncs.auth.URLCredentialsProvider;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.utils.AuthUtils;
import com.aliyuncs.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DefaultCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private List<AlibabaCloudCredentialsProvider> defaultProviders = new ArrayList<AlibabaCloudCredentialsProvider>();
    private static final List<AlibabaCloudCredentialsProvider> USER_CONFIGURATION_PROVIDERS = new Vector<AlibabaCloudCredentialsProvider>();
    private volatile AlibabaCloudCredentialsProvider lastUsedCredentialsProvider;
    private final Boolean reuseLastProviderEnabled;

    public DefaultCredentialsProvider() throws ClientException {
        this.reuseLastProviderEnabled = true;
        this.createDefaultChain();
    }

    private DefaultCredentialsProvider(Builder builder) {
        this.reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        this.createDefaultChain();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void createDefaultChain() {
        String uri;
        this.defaultProviders.add(new SystemPropertiesCredentialsProvider());
        this.defaultProviders.add(new EnvironmentVariableCredentialsProvider());
        if (AuthUtils.environmentEnableOIDC()) {
            this.defaultProviders.add(OIDCCredentialsProvider.builder().build());
        }
        this.defaultProviders.add(CLIProfileCredentialsProvider.builder().build());
        this.defaultProviders.add(new ProfileCredentialsProvider());
        if (!AuthUtils.isDisableECSMetaData()) {
            this.defaultProviders.add(InstanceProfileCredentialsProvider.builder().build());
        }
        if (!StringUtils.isEmpty(uri = AuthUtils.getEnvironmentCredentialsURI())) {
            this.defaultProviders.add(URLCredentialsProvider.builder().credentialsURI(uri).build());
        }
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        AlibabaCloudCredentials credential;
        if (this.reuseLastProviderEnabled.booleanValue() && this.lastUsedCredentialsProvider != null) {
            return this.lastUsedCredentialsProvider.getCredentials();
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (USER_CONFIGURATION_PROVIDERS.size() > 0) {
            for (AlibabaCloudCredentialsProvider provider : USER_CONFIGURATION_PROVIDERS) {
                try {
                    credential = provider.getCredentials();
                    if (null == credential) continue;
                    this.lastUsedCredentialsProvider = provider;
                    return credential;
                }
                catch (Exception e) {
                    errorMessages.add(provider.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
        for (AlibabaCloudCredentialsProvider provider : this.defaultProviders) {
            try {
                credential = provider.getCredentials();
                if (null == credential) continue;
                this.lastUsedCredentialsProvider = provider;
                return credential;
            }
            catch (Exception e) {
                errorMessages.add(provider.getClass().getName() + ": " + e.getMessage());
            }
        }
        throw new ClientException("Unable to load credentials from any of the providers in the chain: " + errorMessages);
    }

    public static boolean addCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.add(provider);
    }

    public static boolean removeCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.remove(provider);
    }

    public static boolean containsCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        return USER_CONFIGURATION_PROVIDERS.contains(provider);
    }

    public static void clearCredentialsProvider() {
        USER_CONFIGURATION_PROVIDERS.clear();
    }

    public static final class Builder {
        private Boolean reuseLastProviderEnabled = true;

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        DefaultCredentialsProvider build() {
            return new DefaultCredentialsProvider(this);
        }
    }
}

