package com.aliyun.core.utils;

import com.aliyun.core.http.Header;
import com.aliyun.core.http.ProxyOptions;

import java.time.Duration;

public final class HttpClientOptions extends ClientOptions {
    private static final Duration MINIMUM_TIMEOUT = Duration.ofSeconds(5);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10);
    private static final Duration NO_TIMEOUT = Duration.ZERO;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;

    @Override
    public HttpClientOptions setProductId(String productId) {
        super.setProductId(productId);
        return this;
    }

    @Override
    public HttpClientOptions setHeaders(Iterable<Header> headers) {
        super.setHeaders(headers);
        return this;
    }

    public HttpClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return proxyOptions;
    }

    public HttpClientOptions setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public HttpClientOptions setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public Duration getWriteTimeout() {
        return getTimeout(writeTimeout);
    }

    public HttpClientOptions responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public Duration getResponseTimeout() {
        return getTimeout(responseTimeout);
    }

    public HttpClientOptions readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return getTimeout(readTimeout);
    }

    private static Duration getTimeout(Duration timeout) {
        // Timeout is null, use the 60 second default.
        if (timeout == null) {
            return DEFAULT_TIMEOUT;
        }

        // Timeout is less than or equal to zero, return no timeout.
        if (timeout.isZero() || timeout.isNegative()) {
            return NO_TIMEOUT;
        }
        // Return the maximum of the timeout period and the minimum allowed timeout period.
        return timeout.compareTo(MINIMUM_TIMEOUT) > 0 ? timeout : MINIMUM_TIMEOUT;
    }
}
