package com.aliyun.core.http;

import com.aliyun.core.utils.BaseUtils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class BufferedHttpResponse extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final ByteBuffer cachedBody;

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        super(innerHttpResponse.getRequest());
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = innerHttpResponse.getBody();
    }

    @Override
    public int getStatusCode() {
        return innerHttpResponse.getStatusCode();
    }

    @Override
    public String getHeaderValue(String name) {
        return innerHttpResponse.getHeaderValue(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return innerHttpResponse.getHeaders();
    }

    @Override
    public ByteBuffer getBody() {
        return cachedBody;
    }

    @Override
    public byte[] getBodyAsByteArray() {
        return cachedBody.array();
    }

    @Override
    public String getBodyAsString() {
        return BaseUtils.bomAwareToString(cachedBody.array(), innerHttpResponse.getHeaderValue("Content-Type"));
    }

    @Override
    public String getBodyAsString(Charset charset) {
        return new String(cachedBody.array(), charset);
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}
