package com.aliyun.core.execption;

import com.aliyun.core.utils.StringUtils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class AliyunException extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public String code;
    public String message;
    public Map<String, Object> data;

    public AliyunException() {
        super();
    }

    public AliyunException(final String message) {
        super(message);
        this.setMessage(message);
    }

    public AliyunException(final Throwable cause) {
        super(cause);
    }

    public AliyunException(final String message, final Throwable cause) {
        super(message, cause);
    }

    public AliyunException(final String message, final Throwable cause, final boolean enableSuppression,
                           final boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public AliyunException(Map<String, Object> map) {
        setData(map);
    }

    public AliyunException(Map<String, Object> map, String message, Throwable cause) {
        super(message, cause);
        setData(map);
    }

    @Override
    public String getMessage() {
        if (StringUtils.isEmpty(message)) {
            return super.getMessage();
        }
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(Map<String, Object> map) {
        this.setCode(String.valueOf(map.get("code")));
        this.setMessage(String.valueOf(map.get("message")));
        Object obj = map.get("data");
        if (obj == null) {
            return;
        }
        if (obj instanceof Map) {
            data = (Map<String, Object>) obj;
            return;
        }
        Map<String, Object> hashMap = new HashMap<String, Object>();
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                hashMap.put(field.getName(), field.get(obj));
            } catch (Exception e) {
                continue;
            }
        }
        this.data = hashMap;
    }
}
