/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class PutMonitorGroupDynamicRuleRequest
extends Request {
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private Long groupId;
    @Query
    @NameInMap(value="GroupRules")
    @Validation(required=true)
    private List<GroupRules> groupRules;
    @Query
    @NameInMap(value="IsAsync")
    private Boolean isAsync;

    private PutMonitorGroupDynamicRuleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.groupId = builder.groupId;
        this.groupRules = builder.groupRules;
        this.isAsync = builder.isAsync;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutMonitorGroupDynamicRuleRequest create() {
        return PutMonitorGroupDynamicRuleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public List<GroupRules> getGroupRules() {
        return this.groupRules;
    }

    public Boolean getIsAsync() {
        return this.isAsync;
    }

    public static class GroupRules
    extends TeaModel {
        @NameInMap(value="Category")
        @Validation(required=true)
        private String category;
        @NameInMap(value="FilterRelation")
        @Validation(required=true)
        private String filterRelation;
        @NameInMap(value="Filters")
        @Validation(required=true)
        private List<Filters> filters;

        private GroupRules(Builder builder) {
            this.category = builder.category;
            this.filterRelation = builder.filterRelation;
            this.filters = builder.filters;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static GroupRules create() {
            return GroupRules.builder().build();
        }

        public String getCategory() {
            return this.category;
        }

        public String getFilterRelation() {
            return this.filterRelation;
        }

        public List<Filters> getFilters() {
            return this.filters;
        }

        public static final class Builder {
            private String category;
            private String filterRelation;
            private List<Filters> filters;

            public Builder category(String category) {
                this.category = category;
                return this;
            }

            public Builder filterRelation(String filterRelation) {
                this.filterRelation = filterRelation;
                return this;
            }

            public Builder filters(List<Filters> filters) {
                this.filters = filters;
                return this;
            }

            public GroupRules build() {
                return new GroupRules(this);
            }
        }
    }

    public static class Filters
    extends TeaModel {
        @NameInMap(value="Function")
        @Validation(required=true)
        private String function;
        @NameInMap(value="Name")
        @Validation(required=true)
        private String name;
        @NameInMap(value="Value")
        @Validation(required=true)
        private String value;

        private Filters(Builder builder) {
            this.function = builder.function;
            this.name = builder.name;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Filters create() {
            return Filters.builder().build();
        }

        public String getFunction() {
            return this.function;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String function;
            private String name;
            private String value;

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Filters build() {
                return new Filters(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<PutMonitorGroupDynamicRuleRequest, Builder> {
        private Long groupId;
        private List<GroupRules> groupRules;
        private Boolean isAsync;

        private Builder() {
        }

        private Builder(PutMonitorGroupDynamicRuleRequest request) {
            super((Request)request);
            this.groupId = request.groupId;
            this.groupRules = request.groupRules;
            this.isAsync = request.isAsync;
        }

        public Builder groupId(Long groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder groupRules(List<GroupRules> groupRules) {
            this.putQueryParameter("GroupRules", groupRules);
            this.groupRules = groupRules;
            return this;
        }

        public Builder isAsync(Boolean isAsync) {
            this.putQueryParameter("IsAsync", isAsync);
            this.isAsync = isAsync;
            return this;
        }

        public PutMonitorGroupDynamicRuleRequest build() {
            return new PutMonitorGroupDynamicRuleRequest(this);
        }
    }
}

