/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class PutMetricRuleTargetsRequest
extends Request {
    @Query
    @NameInMap(value="RuleId")
    @Validation(required=true)
    private String ruleId;
    @Query
    @NameInMap(value="Targets")
    @Validation(required=true)
    private List<Targets> targets;

    private PutMetricRuleTargetsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.ruleId = builder.ruleId;
        this.targets = builder.targets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutMetricRuleTargetsRequest create() {
        return PutMetricRuleTargetsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public List<Targets> getTargets() {
        return this.targets;
    }

    public static class Targets
    extends TeaModel {
        @NameInMap(value="Arn")
        @Validation(required=true)
        private String arn;
        @NameInMap(value="Id")
        @Validation(required=true)
        private String id;
        @NameInMap(value="JsonParams")
        private String jsonParams;
        @NameInMap(value="Level")
        private String level;

        private Targets(Builder builder) {
            this.arn = builder.arn;
            this.id = builder.id;
            this.jsonParams = builder.jsonParams;
            this.level = builder.level;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Targets create() {
            return Targets.builder().build();
        }

        public String getArn() {
            return this.arn;
        }

        public String getId() {
            return this.id;
        }

        public String getJsonParams() {
            return this.jsonParams;
        }

        public String getLevel() {
            return this.level;
        }

        public static final class Builder {
            private String arn;
            private String id;
            private String jsonParams;
            private String level;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder jsonParams(String jsonParams) {
                this.jsonParams = jsonParams;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public Targets build() {
                return new Targets(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<PutMetricRuleTargetsRequest, Builder> {
        private String ruleId;
        private List<Targets> targets;

        private Builder() {
        }

        private Builder(PutMetricRuleTargetsRequest request) {
            super((Request)request);
            this.ruleId = request.ruleId;
            this.targets = request.targets;
        }

        public Builder ruleId(String ruleId) {
            this.putQueryParameter("RuleId", ruleId);
            this.ruleId = ruleId;
            return this;
        }

        public Builder targets(List<Targets> targets) {
            this.putQueryParameter("Targets", targets);
            this.targets = targets;
            return this;
        }

        public PutMetricRuleTargetsRequest build() {
            return new PutMetricRuleTargetsRequest(this);
        }
    }
}

