/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class PutHybridMonitorMetricDataRequest
extends Request {
    @Query
    @NameInMap(value="MetricList")
    @Validation(required=true)
    private List<MetricList> metricList;
    @Query
    @NameInMap(value="Namespace")
    @Validation(required=true)
    private String namespace;

    private PutHybridMonitorMetricDataRequest(Builder builder) {
        super((Request.Builder)builder);
        this.metricList = builder.metricList;
        this.namespace = builder.namespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutHybridMonitorMetricDataRequest create() {
        return PutHybridMonitorMetricDataRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<MetricList> getMetricList() {
        return this.metricList;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static class MetricList
    extends TeaModel {
        @NameInMap(value="Labels")
        private List<Labels> labels;
        @NameInMap(value="Name")
        @Validation(required=true, maxLength=128, minLength=1)
        private String name;
        @NameInMap(value="TS")
        private Long ts;
        @NameInMap(value="Value")
        @Validation(required=true)
        private String value;

        private MetricList(Builder builder) {
            this.labels = builder.labels;
            this.name = builder.name;
            this.ts = builder.ts;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MetricList create() {
            return MetricList.builder().build();
        }

        public List<Labels> getLabels() {
            return this.labels;
        }

        public String getName() {
            return this.name;
        }

        public Long getTs() {
            return this.ts;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private List<Labels> labels;
            private String name;
            private Long ts;
            private String value;

            public Builder labels(List<Labels> labels) {
                this.labels = labels;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder ts(Long ts) {
                this.ts = ts;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MetricList build() {
                return new MetricList(this);
            }
        }
    }

    public static class Labels
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Labels(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Labels create() {
            return Labels.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Labels build() {
                return new Labels(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<PutHybridMonitorMetricDataRequest, Builder> {
        private List<MetricList> metricList;
        private String namespace;

        private Builder() {
        }

        private Builder(PutHybridMonitorMetricDataRequest request) {
            super((Request)request);
            this.metricList = request.metricList;
            this.namespace = request.namespace;
        }

        public Builder metricList(List<MetricList> metricList) {
            this.putQueryParameter("MetricList", metricList);
            this.metricList = metricList;
            return this;
        }

        public Builder namespace(String namespace) {
            this.putQueryParameter("Namespace", namespace);
            this.namespace = namespace;
            return this;
        }

        public PutHybridMonitorMetricDataRequest build() {
            return new PutHybridMonitorMetricDataRequest(this);
        }
    }
}

