/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class PutEventRuleTargetsRequest
extends Request {
    @Query
    @NameInMap(value="ContactParameters")
    private List<ContactParameters> contactParameters;
    @Query
    @NameInMap(value="FcParameters")
    private List<FcParameters> fcParameters;
    @Query
    @NameInMap(value="MnsParameters")
    private List<MnsParameters> mnsParameters;
    @Query
    @NameInMap(value="OpenApiParameters")
    private List<OpenApiParameters> openApiParameters;
    @Query
    @NameInMap(value="RuleName")
    @Validation(required=true)
    private String ruleName;
    @Query
    @NameInMap(value="SlsParameters")
    private List<SlsParameters> slsParameters;
    @Query
    @NameInMap(value="WebhookParameters")
    private List<WebhookParameters> webhookParameters;

    private PutEventRuleTargetsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.contactParameters = builder.contactParameters;
        this.fcParameters = builder.fcParameters;
        this.mnsParameters = builder.mnsParameters;
        this.openApiParameters = builder.openApiParameters;
        this.ruleName = builder.ruleName;
        this.slsParameters = builder.slsParameters;
        this.webhookParameters = builder.webhookParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutEventRuleTargetsRequest create() {
        return PutEventRuleTargetsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<ContactParameters> getContactParameters() {
        return this.contactParameters;
    }

    public List<FcParameters> getFcParameters() {
        return this.fcParameters;
    }

    public List<MnsParameters> getMnsParameters() {
        return this.mnsParameters;
    }

    public List<OpenApiParameters> getOpenApiParameters() {
        return this.openApiParameters;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public List<SlsParameters> getSlsParameters() {
        return this.slsParameters;
    }

    public List<WebhookParameters> getWebhookParameters() {
        return this.webhookParameters;
    }

    public static class WebhookParameters
    extends TeaModel {
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="Method")
        private String method;
        @NameInMap(value="Protocol")
        private String protocol;
        @NameInMap(value="Url")
        private String url;

        private WebhookParameters(Builder builder) {
            this.id = builder.id;
            this.method = builder.method;
            this.protocol = builder.protocol;
            this.url = builder.url;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static WebhookParameters create() {
            return WebhookParameters.builder().build();
        }

        public String getId() {
            return this.id;
        }

        public String getMethod() {
            return this.method;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getUrl() {
            return this.url;
        }

        public static final class Builder {
            private String id;
            private String method;
            private String protocol;
            private String url;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder method(String method) {
                this.method = method;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public WebhookParameters build() {
                return new WebhookParameters(this);
            }
        }
    }

    public static class SlsParameters
    extends TeaModel {
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="LogStore")
        private String logStore;
        @NameInMap(value="Project")
        private String project;
        @NameInMap(value="Region")
        private String region;

        private SlsParameters(Builder builder) {
            this.id = builder.id;
            this.logStore = builder.logStore;
            this.project = builder.project;
            this.region = builder.region;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SlsParameters create() {
            return SlsParameters.builder().build();
        }

        public String getId() {
            return this.id;
        }

        public String getLogStore() {
            return this.logStore;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public static final class Builder {
            private String id;
            private String logStore;
            private String project;
            private String region;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder logStore(String logStore) {
                this.logStore = logStore;
                return this;
            }

            public Builder project(String project) {
                this.project = project;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public SlsParameters build() {
                return new SlsParameters(this);
            }
        }
    }

    public static class OpenApiParameters
    extends TeaModel {
        @NameInMap(value="Action")
        private String action;
        @NameInMap(value="Arn")
        private String arn;
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="JsonParams")
        private String jsonParams;
        @NameInMap(value="Product")
        private String product;
        @NameInMap(value="Region")
        private String region;
        @NameInMap(value="Role")
        private String role;
        @NameInMap(value="Version")
        private String version;

        private OpenApiParameters(Builder builder) {
            this.action = builder.action;
            this.arn = builder.arn;
            this.id = builder.id;
            this.jsonParams = builder.jsonParams;
            this.product = builder.product;
            this.region = builder.region;
            this.role = builder.role;
            this.version = builder.version;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static OpenApiParameters create() {
            return OpenApiParameters.builder().build();
        }

        public String getAction() {
            return this.action;
        }

        public String getArn() {
            return this.arn;
        }

        public String getId() {
            return this.id;
        }

        public String getJsonParams() {
            return this.jsonParams;
        }

        public String getProduct() {
            return this.product;
        }

        public String getRegion() {
            return this.region;
        }

        public String getRole() {
            return this.role;
        }

        public String getVersion() {
            return this.version;
        }

        public static final class Builder {
            private String action;
            private String arn;
            private String id;
            private String jsonParams;
            private String product;
            private String region;
            private String role;
            private String version;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder jsonParams(String jsonParams) {
                this.jsonParams = jsonParams;
                return this;
            }

            public Builder product(String product) {
                this.product = product;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public OpenApiParameters build() {
                return new OpenApiParameters(this);
            }
        }
    }

    public static class MnsParameters
    extends TeaModel {
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="Queue")
        private String queue;
        @NameInMap(value="Region")
        private String region;
        @NameInMap(value="Topic")
        private String topic;

        private MnsParameters(Builder builder) {
            this.id = builder.id;
            this.queue = builder.queue;
            this.region = builder.region;
            this.topic = builder.topic;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MnsParameters create() {
            return MnsParameters.builder().build();
        }

        public String getId() {
            return this.id;
        }

        public String getQueue() {
            return this.queue;
        }

        public String getRegion() {
            return this.region;
        }

        public String getTopic() {
            return this.topic;
        }

        public static final class Builder {
            private String id;
            private String queue;
            private String region;
            private String topic;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder queue(String queue) {
                this.queue = queue;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public MnsParameters build() {
                return new MnsParameters(this);
            }
        }
    }

    public static class FcParameters
    extends TeaModel {
        @NameInMap(value="FunctionName")
        private String functionName;
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="Region")
        private String region;
        @NameInMap(value="ServiceName")
        private String serviceName;

        private FcParameters(Builder builder) {
            this.functionName = builder.functionName;
            this.id = builder.id;
            this.region = builder.region;
            this.serviceName = builder.serviceName;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static FcParameters create() {
            return FcParameters.builder().build();
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getId() {
            return this.id;
        }

        public String getRegion() {
            return this.region;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public static final class Builder {
            private String functionName;
            private String id;
            private String region;
            private String serviceName;

            public Builder functionName(String functionName) {
                this.functionName = functionName;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public FcParameters build() {
                return new FcParameters(this);
            }
        }
    }

    public static class ContactParameters
    extends TeaModel {
        @NameInMap(value="ContactGroupName")
        private String contactGroupName;
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="Level")
        private String level;

        private ContactParameters(Builder builder) {
            this.contactGroupName = builder.contactGroupName;
            this.id = builder.id;
            this.level = builder.level;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ContactParameters create() {
            return ContactParameters.builder().build();
        }

        public String getContactGroupName() {
            return this.contactGroupName;
        }

        public String getId() {
            return this.id;
        }

        public String getLevel() {
            return this.level;
        }

        public static final class Builder {
            private String contactGroupName;
            private String id;
            private String level;

            public Builder contactGroupName(String contactGroupName) {
                this.contactGroupName = contactGroupName;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public ContactParameters build() {
                return new ContactParameters(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<PutEventRuleTargetsRequest, Builder> {
        private List<ContactParameters> contactParameters;
        private List<FcParameters> fcParameters;
        private List<MnsParameters> mnsParameters;
        private List<OpenApiParameters> openApiParameters;
        private String ruleName;
        private List<SlsParameters> slsParameters;
        private List<WebhookParameters> webhookParameters;

        private Builder() {
        }

        private Builder(PutEventRuleTargetsRequest request) {
            super((Request)request);
            this.contactParameters = request.contactParameters;
            this.fcParameters = request.fcParameters;
            this.mnsParameters = request.mnsParameters;
            this.openApiParameters = request.openApiParameters;
            this.ruleName = request.ruleName;
            this.slsParameters = request.slsParameters;
            this.webhookParameters = request.webhookParameters;
        }

        public Builder contactParameters(List<ContactParameters> contactParameters) {
            this.putQueryParameter("ContactParameters", contactParameters);
            this.contactParameters = contactParameters;
            return this;
        }

        public Builder fcParameters(List<FcParameters> fcParameters) {
            this.putQueryParameter("FcParameters", fcParameters);
            this.fcParameters = fcParameters;
            return this;
        }

        public Builder mnsParameters(List<MnsParameters> mnsParameters) {
            this.putQueryParameter("MnsParameters", mnsParameters);
            this.mnsParameters = mnsParameters;
            return this;
        }

        public Builder openApiParameters(List<OpenApiParameters> openApiParameters) {
            this.putQueryParameter("OpenApiParameters", openApiParameters);
            this.openApiParameters = openApiParameters;
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.putQueryParameter("RuleName", ruleName);
            this.ruleName = ruleName;
            return this;
        }

        public Builder slsParameters(List<SlsParameters> slsParameters) {
            this.putQueryParameter("SlsParameters", slsParameters);
            this.slsParameters = slsParameters;
            return this;
        }

        public Builder webhookParameters(List<WebhookParameters> webhookParameters) {
            this.putQueryParameter("WebhookParameters", webhookParameters);
            this.webhookParameters = webhookParameters;
            return this;
        }

        public PutEventRuleTargetsRequest build() {
            return new PutEventRuleTargetsRequest(this);
        }
    }
}

